#!/usr/bin/perl

#
# dhcpadmin
#
# Copyright (C) 2008 DesigNET, INC.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

##########################################################
#
# ϰϴ
#
# $RCSfile: range.cgi,v $
# $Revision: 1.20 $
# $Date: 2009/01/04 23:57:51 $
#
##########################################################

# 饤֥ɲ
use lib "../lib";

use strict;
use CGI;

# 饤֥ɤ߹
require "libcommon.pl";
require "libpage.pl";
require "libpost.pl";
require "librange.pl";
require "libhost.pl";
require "range.pl";

##########################################################
# ڡѥå
##########################################################
package mypage;

my $body;

use vars qw(@ISA);

#
# pageλҥ饹
#
@ISA = qw(page);
sub new
{
    bless {};
}

#
# ɽ
#
sub display_body
{
    print $body;
}

##########################################################
# ᥤѥå
##########################################################
package main;

##########################################################
# 
##########################################################

my $q = new CGI;
my $ret;
my %conf;
my $msg;
my @errmsg;
my $postdata = "REF=range.cgi";  # ե顼ǡǼ
my $DESTFILE = "subnetlist.cgi";
my $selrange = $q->param('range');
my $subnetdir = $q->param('subnetlist');
my $linkflag = 1;
my $ref = $q->param('REF');

# 
if (dhcp_init(\%conf, $linkflag, $ref, \@errmsg) != 0) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ᥤ
##########################################################

my %chgdata;
my %serverlist;
my $mainflg;
my %decryptdata;

# å
$errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_RANGLIST'};

$decryptdata{'selsubnetlist'} = $q->param('subnetlist');

# ֥ͥåȤΰϤƤʤhidden
if (defined($q->param('subnetlist')) == 0) {
    $decryptdata{'selsubnetlist'} = $q->param('selsubnetlist');

    # ʣ粽
    if (hidden_decrypt(\%decryptdata, \%conf, \@errmsg) != 0) {
        # ǧ۾
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }

    $subnetdir = $decryptdata{'selsubnetlist'};
}

# 
if (defined($q->param('back')) == 1) {

    $postdata .= "&subnetlist=" . $decryptdata{'selsubnetlist'};

    # ڡɽ
    if (location_display($DESTFILE, $postdata, \@errmsg) == -1) {
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }
}


# 
if ($q->param('mode') eq "del" ) {
    # ɽѤ/-ִ
    $decryptdata{'selsubnetlist'} =~ s/\//-/;


    # ϰϺ¹
    $ret = del_range($decryptdata{'selsubnetlist'}, $selrange, \@errmsg);
    if ($ret == -1) {
        # ǧ۾
        syserr($errmsg[$main::L_DISP]);
        errlog($errmsg[$main::L_LOG], $conf{'facility'});
        exit 1;
    }

    if ($ret == 0) {
        # ǧ
        $selrange =~ s/\,/-/;   # ɽѤ/-ִ
        $errmsg[$main::L_DISP] = $main::LANG{$ENV{$main::DISPLANG}}{'INFO_RANGE_DATA6'} . "(" . $selrange . ")";
    }
}

##########################################################
# ƥץ졼֤
##########################################################

my $id = "range";		# ɽѥڡID
my $rangehtml;
my %cryptdata;

# ֥ͥåϰϼ
if (make_rangehtml($subnetdir, $selrange, \$rangehtml, \@errmsg) == -1) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ǡŹ沽
$cryptdata{'SELSUBNETLIST'} = $decryptdata{'selsubnetlist'};

if (hidden_crypt(\%cryptdata, \%conf, \@errmsg) == -1) {
    # ǧ۾
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

# ִǡϿ
$chgdata{'SUBNETLIST'} = $decryptdata{'selsubnetlist'};
$chgdata{'SELSUBNETLIST'} = $q->escapeHTML($cryptdata{'SELSUBNETLIST'});
$chgdata{'SUBNETLIST'} =~ s/-/\//;
$chgdata{'RANGELIST'} = $rangehtml;

# ץ졼
if (page::replace_template($id, \$body, \%chgdata, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

##########################################################
# ڡɽ
##########################################################

my $tabId = "nw";
my $obj;
my $sys_err;

# 顼åǼ
if (defined($q->param('dispmsg')) == 1) {
    $errmsg[$main::L_DISP] = $q->param('dispmsg');
}

# ɽʸ<br>ؤѴ
main::conv_br(\$errmsg[$main::L_DISP]);

$obj = new mypage;
if ($obj->display($id, \$sys_err, $tabId, \@errmsg) == -1) {
    syserr($errmsg[$main::L_DISP]);
    errlog($errmsg[$main::L_LOG], $conf{'facility'});
    exit 1;
}

exit 0;
