/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.window;

import com.aibonware.nvrlib.model.BoardType;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.ParsingException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.command.BoardNavigator;
import com.aibonware.viewnaver.command.DenyListNavigator;
import com.aibonware.viewnaver.command.FavoriteNavigator;
import com.aibonware.viewnaver.command.OpenURLCommand;
import com.aibonware.viewnaver.command.ReceivedMessageNavigator;
import com.aibonware.viewnaver.command.SentMessageNavigator;
import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigUser;
import com.aibonware.viewnaver.config.MainWindowConfig;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.BoardTitles;
import com.aibonware.viewnaver.model.BoardTitlesGroup;
import com.aibonware.viewnaver.net.SessionListener;
import com.aibonware.viewnaver.parser.GoyakuJitenParser;
import com.aibonware.viewnaver.parser.IDJitenParser;
import com.aibonware.viewnaver.storage.StorageException;
import com.aibonware.viewnaver.tab.TabTest;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.Navigator;
import com.aibonware.viewnaver.window.ConfigDialog;
import com.aibonware.viewnaver.window.LoginDialog;
import com.aibonware.viewnaver.window.MainWindow;
import com.aibonware.viewnaver.window.MiniServerDialog;
import com.aibonware.viewnaver.window.SearchLocalThreadDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class MainWindowController
implements ConfigUser {
    private final MainWindow mainWindow;
    public MenuAction loginAction = new MenuAction("Login...", 76){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ViewNaver.instance.multiSession.nowLogin()) {
                ViewNaver.println("\u65e2\u306b\u30ed\u30b0\u30a4\u30f3\u6e08\u307f\u3067\u3059\u3002");
                return;
            }
            String currentUserName = ViewNaver.instance.multiSession.getUserName();
            LoginDialog loginDialog = new LoginDialog((Frame)MainWindowController.this.mainWindow, null, currentUserName);
            loginDialog.setVisible(true);
        }
    };
    public MenuAction logoutAction = new MenuAction("Logout", 79){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!ViewNaver.instance.multiSession.nowLogin()) {
                ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getLoginFlow();
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    try {
                        ViewNaver.println("\u30ed\u30b0\u30a2\u30a6\u30c8\u958b\u59cb..");
                        ViewNaver.instance.multiSession.logout();
                        ViewNaver.println("\u30ed\u30b0\u30a2\u30a6\u30c8\u7d42\u4e86\u3002");
                    }
                    catch (NetException e) {
                        ViewNaver.err((Exception)((Object)e));
                    }
                }
            });
        }
    };
    public MenuAction openUrlAction = new MenuAction("Open Url...", 79){

        @Override
        public void actionPerformed(ActionEvent event) {
            String urlText = JOptionPane.showInputDialog(ViewNaver.instance.mainWindow, (Object)"\u30b9\u30ec\u30c3\u30c9\u307e\u305f\u306f\u677f\u306eURL\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\uff1a");
            ViewNaver.instance.childWindowActivator.setClosingChild(new Object());
            if (urlText == null) {
                return;
            }
            if (urlText == null || urlText.trim().equals("")) {
                ViewNaver.println("\u7a7a\u306eURL\u3067\u3059\u3002");
                return;
            }
            new OpenURLCommand(MainWindowController.this.mainWindow, urlText, true).run();
        }
    };
    public MenuAction saveAction = new MenuAction("Save...", 83){

        @Override
        public void actionPerformed(ActionEvent event) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    try {
                        ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u51fa\u529b\u958b\u59cb...");
                        int num = ViewNaver.instance.threadStorage.flash();
                        ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u51fa\u529b\u7d42\u4e86(" + num + "\u30b9\u30ec\u30c3\u30c9\u4fdd\u5b58)");
                    }
                    catch (StorageException e) {
                        ViewNaver.err(e);
                    }
                    ViewNaver.instance.config.saveFile("config.xml");
                }
            });
        }
    };
    public MenuAction readGoyakuAction = new MenuAction("\u8aa4\u8a33\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f(einsamkeit)", 71){

        @Override
        public void actionPerformed(ActionEvent event) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    try {
                        ViewNaver.println("\u8aa4\u8a33\u8f9e\u5178\u306e\u8aad\u8fbc\u958b\u59cb...");
                        GoyakuJitenParser parser = new GoyakuJitenParser("http://einsamkeit.hp.infoseek.co.jp/naver_goyaku.htm");
                        ViewNaver.instance.goyakuList = parser.parse();
                        ViewNaver.println("\u8aa4\u8a33\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                    }
                    catch (NetException e) {
                        ViewNaver.err((Exception)((Object)e));
                    }
                    catch (ParsingException e) {
                        ViewNaver.err((Exception)((Object)e));
                    }
                }
            });
        }
    };
    public MenuAction readIDJitenAction = new MenuAction("ID\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f(enjoyid)", 48){

        @Override
        public void actionPerformed(ActionEvent event) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    try {
                        ViewNaver.println("ID\u8f9e\u5178\u306e\u8aad\u8fbc\u958b\u59cb...");
                        IDJitenParser parser = new IDJitenParser("http://enjoyid.net/xml?mode=main");
                        ViewNaver.instance.idJiten = parser.parse();
                        ViewNaver.println("ID\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                    }
                    catch (NetException e) {
                        ViewNaver.err((Exception)((Object)e));
                    }
                    catch (ParsingException e) {
                        ViewNaver.err((Exception)((Object)e));
                    }
                }
            });
        }
    };
    public MenuAction configAction = new MenuAction("\u8a2d\u5b9a...", 67){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigDialog dialog = new ConfigDialog(MainWindowController.this.mainWindow, ViewNaver.instance.config);
            dialog.setVisible(true);
        }
    };
    public MenuAction miniServerAction = new MenuAction("Remote Control...", 82){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ViewNaver.instance.multiSession.nowLogin()) {
                ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            if (ViewNaver.instance.server != null) {
                ViewNaver.println("Remote Control\u306f\u65e2\u306b\u6709\u52b9\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
                return;
            }
            MiniServerDialog dialog = new MiniServerDialog(MainWindowController.this.mainWindow);
            dialog.setVisible(true);
        }
    };
    public MenuAction searchLocalThreadAction = new MenuAction("\u30ed\u30b0\u691c\u7d22...", 83){

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchLocalThreadDialog dialog = new SearchLocalThreadDialog(MainWindowController.this.mainWindow);
            dialog.setVisible(true);
        }
    };
    public MenuAction exitAction = new MenuAction("Exit", 88){

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewNaver.instance.exit();
        }
    };
    public MenuAction testAction = new MenuAction("test", 84){

        @Override
        public void actionPerformed(ActionEvent e) {
            new TabTest().run();
        }
    };
    public AbstractAction showChildAction = new AbstractAction("\u5b50\u753b\u9762\u8868\u793a"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((MainWindowController)MainWindowController.this).mainWindow.showChildWindowButton.isSelected()) {
                ViewNaver.instance.childWindowActivator.activateChildren();
            }
        }
    };
    Navigator rootNavigator = new Navigator("");
    MessageNavigators currentMessageNavigators = null;

    private Navigator createNavigator(BoardTitle boardTitle) {
        return new BoardNavigator(boardTitle);
    }

    private Navigator createNavigator(BoardTitlesGroup boardGroup) {
        Navigator navigator = new Navigator(boardGroup.groupName);
        int i = 0;
        while (i < boardGroup.getBoardCount()) {
            navigator.addChild(this.createNavigator((BoardTitle)boardGroup.getBoardTitle(i)));
            ++i;
        }
        return navigator;
    }

    public MainWindowController(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        Config config = ViewNaver.instance.config;
        mainWindow.mainWindowConfig = new MainWindowConfig();
        config.addChild(mainWindow.mainWindowConfig);
        config.addConfigUser(this);
    }

    public void start() {
        final SessionListener sessionListener = new SessionListener(){

            @Override
            public void loginChanged(String userName, boolean nowLogin) {
                MainWindowController.this.loginAction.setEnabled(!nowLogin);
                MainWindowController.this.logoutAction.setEnabled(nowLogin);
                if (MainWindowController.this.currentMessageNavigators != null && !MainWindowController.this.currentMessageNavigators.userName.equals(userName)) {
                    MainWindowController.this.rootNavigator.removeChild(MainWindowController.this.currentMessageNavigators);
                    MainWindowController.this.currentMessageNavigators = null;
                }
                if (!userName.equals("") && MainWindowController.this.currentMessageNavigators == null) {
                    MainWindowController.this.currentMessageNavigators = new MessageNavigators(userName);
                    MainWindowController.this.rootNavigator.insertChild(MainWindowController.this.currentMessageNavigators, 1);
                }
            }
        };
        this.mainWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ViewNaver.instance.exit();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ViewNaver.instance.multiSession.removeSessionListener(sessionListener);
            }
        });
        this.mainWindow.loginMenu.setAction(this.loginAction);
        this.mainWindow.logoutMenu.setAction(this.logoutAction);
        this.mainWindow.openUrlMenu.setAction(this.openUrlAction);
        this.mainWindow.saveMenu.setAction(this.saveAction);
        this.mainWindow.readGoyakuMenu.setAction(this.readGoyakuAction);
        this.mainWindow.readIDJitenMenu.setAction(this.readIDJitenAction);
        this.mainWindow.configMenu.setAction(this.configAction);
        this.mainWindow.miniServerMenu.setAction(this.miniServerAction);
        this.mainWindow.searchLocalThreadMenu.setAction(this.searchLocalThreadAction);
        this.mainWindow.exitMenu.setAction(this.exitAction);
        this.mainWindow.testMenu.setAction(this.testAction);
        this.mainWindow.showChildWindowButton.setAction(this.showChildAction);
        this.rootNavigator.addChild(new MainNavigators());
        BoardTitlesGroup textBoardTitlesGroup = new BoardTitlesGroup("text", (BoardTitles)ViewNaver.instance.boardTitles.getBoardTitles(BoardType.Text));
        BoardTitlesGroup imageBoardTitlesGroup = new BoardTitlesGroup("image", (BoardTitles)ViewNaver.instance.boardTitles.getBoardTitles(BoardType.Image));
        this.rootNavigator.addChild(this.createNavigator(textBoardTitlesGroup));
        this.rootNavigator.addChild(this.createNavigator(imageBoardTitlesGroup));
        this.mainWindow.navigationView.setNavigator(this.rootNavigator);
        ViewNaver.instance.multiSession.addSessionListener(sessionListener);
    }

    @Override
    public void configChanged(Config config) {
        if ((this.mainWindow.getExtendedState() & 7) != 0) {
            return;
        }
        this.mainWindow.mainWindowConfig = (MainWindowConfig)config.getAncestor("MainWindow");
        Rectangle r = new Rectangle(this.mainWindow.mainWindowConfig.left, this.mainWindow.mainWindowConfig.top, this.mainWindow.mainWindowConfig.width, this.mainWindow.mainWindowConfig.height);
        if (!r.equals(this.mainWindow.getBounds())) {
            this.mainWindow.setBounds(r);
        }
    }

    private static class MainNavigators
    extends Navigator {
        public MainNavigators() {
            super("\u30e1\u30a4\u30f3");
            this.addChild(new FavoriteNavigator());
        }
    }

    private static class MenuAction
    extends AbstractAction {
        public MenuAction(String name, int mnemonic) {
            super(name);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class MessageNavigators
    extends Navigator {
        public final String userName;

        public MessageNavigators(String userName) {
            super("\u30e1\u30c3\u30bb\u30fc\u30b8(" + userName + ")");
            this.userName = userName;
            this.addChild(new ReceivedMessageNavigator());
            this.addChild(new SentMessageNavigator());
            this.addChild(new DenyListNavigator());
        }
    }
}

