/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.parser;

import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.model.Poster;
import com.aibonware.nvrlib.net.AnonymousSession;
import com.aibonware.nvrlib.net.HttpCancellerProvider;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.ParsingException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.IDJitenList;
import com.aibonware.viewnaver.task.HttpTaskCancellerProvider;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IDJitenParser {
    public String urlString;

    public IDJitenParser(String urlString) {
        this.urlString = urlString;
    }

    public IDJitenList parse() throws NetException, ParsingException {
        AnonymousSession session = new AnonymousSession("", ViewNaver.instance.config.getNetworkConfig().getProxyInfo(), (HttpCancellerProvider)new HttpTaskCancellerProvider());
        InputStream reader = session.openStream(this.urlString);
        IDJitenList result = this.parse(reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("URL\u30af\u30ed\u30fc\u30ba\u5931\u6557", e);
        }
        return result;
    }

    public IDJitenList parse(InputStream reader) throws ParsingException, NetException {
        try {
            IDJitenList list = new IDJitenList();
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(reader);
            Element root = doc.getDocumentElement();
            NodeList persons = root.getChildNodes();
            int i = 0;
            while (i < persons.getLength()) {
                Node personNode = persons.item(i);
                if (personNode.getNodeName().equals("Person")) {
                    Element personElem = (Element)personNode;
                    String country = personElem.getAttribute("Country");
                    String name = personElem.getAttribute("Name");
                    String content = ((Element)personElem.getElementsByTagName("Content").item(0)).getTextContent();
                    content = ViewNaver.htmlToStr(content);
                    NodeList aliases = personElem.getElementsByTagName("Alias");
                    while (content.charAt(0) == '\n') {
                        content = content.substring(1);
                    }
                    Poster person = new Poster(name, Country.strToCountry((String)country));
                    list.addID(person, content);
                    int j = 0;
                    while (j < aliases.getLength()) {
                        String aliaseName = ((Element)aliases.item(j)).getAttribute("Name");
                        list.addID(new Poster(aliaseName, Country.strToCountry((String)country)), content);
                        ++j;
                    }
                }
                ++i;
            }
            return list;
        }
        catch (ParserConfigurationException e) {
            ViewNaver.err(e);
            return null;
        }
        catch (SAXException e) {
            ViewNaver.err(e);
            return null;
        }
        catch (IOException e) {
            ViewNaver.err(e);
            return null;
        }
    }
}

