/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.message;

import com.aibonware.nvrlib.model.Message;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.message.MessageContentView;
import com.aibonware.viewnaver.content.message.MessageListView;
import com.aibonware.viewnaver.storage.StorageException;
import com.aibonware.viewnaver.task.ButtonBarStatus;
import com.aibonware.viewnaver.task.TaskFlow;
import javax.swing.JButton;

public class SentMessageContentView
extends MessageContentView {
    private ButtonBarStatus buttonStatus;

    public SentMessageContentView(TabContentCategory category) {
        super(category, "http://bbs.enjoykorea.jp/memo/save_view.php?no=", new MessageListView.MessageAdapter(){

            @Override
            public void saveMessage(Message message) {
                try {
                    ViewNaver.instance.messageStorage.saveSentMessage(ViewNaver.instance.multiSession.getUserName(), message);
                }
                catch (StorageException e) {
                    ViewNaver.err(e);
                }
            }

            @Override
            public Message getMessage(int messageId) {
                return ViewNaver.instance.messageStorage.getSentMessage(messageId);
            }
        });
        this.buttonStatus = new ButtonBarStatus(new JButton[]{this.updateButton, this.serverButton}, new JButton[]{this.closeButton});
    }

    @Override
    public void beginTask(JButton taskButton, TaskFlow taskFlow) {
        this.buttonStatus.beginTask(taskButton, taskFlow, new JButton[]{this.updateButton, this.serverButton, this.closeButton});
    }

    @Override
    public void beginUpdateTask(TaskFlow taskFlow) {
        this.buttonStatus.beginTask(this.updateButton, taskFlow, new JButton[]{this.serverButton, this.closeButton});
    }

    @Override
    protected void saveServerMessage(int[] messageIdList) throws NetException {
        ViewNaver.instance.multiSession.saveSentMessage(messageIdList);
    }

    @Override
    protected void deleteServerMessage(int[] messageIdList) throws NetException {
        ViewNaver.instance.multiSession.deleteSentMessage(messageIdList);
    }
}

