/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.model.Poster;
import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FavoritePersonConfig
extends ConfigItem {
    public Set<Poster> persons = new HashSet<Poster>();

    public FavoritePersonConfig() {
        super("FavoritePersonList");
        this.loadConfig(null);
    }

    @Override
    public void loadConfig(Element elem) {
        this.persons = new HashSet<Poster>();
        if (elem == null) {
            return;
        }
        NodeList children = elem.getElementsByTagName("FavoritePerson");
        int i = 0;
        while (i < children.getLength()) {
            Element filterElem = (Element)children.item(i);
            Poster poster = Config.getPosterConfig(filterElem, "Poster");
            this.persons.add(poster);
            ++i;
        }
    }

    @Override
    public void saveConfig(Element elem) {
        NodeList children = elem.getElementsByTagName("FavoritePerson");
        int i = 0;
        while (i < children.getLength()) {
            elem.removeChild(children.item(i));
            ++i;
        }
        for (Poster poster : this.persons) {
            Document doc = elem.getOwnerDocument();
            Element personElem = doc.createElement("FavoritePerson");
            elem.appendChild(personElem);
            Config.setPosterConfig(personElem, "Poster", poster);
        }
    }

    @Override
    public String getDispPath() {
        return "\u57fa\u672c.\u304a\u6c17\u306b\u5165\u308aID";
    }

    @Override
    public ConfigItemView getView() {
        return new FavoritePersonConfigView();
    }

    private static class FavoritePersonConfigView
    extends ConfigItemView {
        JTable table;
        JButton deleteButton;
        private FavoritePersonConfig favoritePersonConfig;
        private DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"Country", "Poster"}, 0);

        public FavoritePersonConfigView() {
            this.table = new JTable(this.tableModel);
            this.deleteButton = new JButton("\u524a\u9664");
            this.setAlignmentX(0.0f);
            this.addLine(FavoritePersonConfigView.glue(this.table.getTableHeader()), this.newline(0), FavoritePersonConfigView.glue(this.table), "\n", FavoritePersonConfigView.glue(), this.deleteButton);
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = FavoritePersonConfigView.this.table.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    FavoritePersonConfigView.this.tableModel.removeRow(row);
                }
            });
        }

        @Override
        public void setConfig(ConfigItem config) {
            this.favoritePersonConfig = (FavoritePersonConfig)config;
            for (Poster poster : this.favoritePersonConfig.persons) {
                this.tableModel.addRow(new Object[]{poster.country, poster.name});
            }
        }

        @Override
        public void applyConfig() throws ConfigException {
            this.favoritePersonConfig.persons.clear();
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                Country country = (Country)this.tableModel.getValueAt(i, 0);
                String name = (String)this.tableModel.getValueAt(i, 1);
                this.favoritePersonConfig.persons.add(new Poster(name, country));
                ++i;
            }
        }
    }
}

