/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.browser.win32;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.SimpleBrowserImpl;
import com.aibonware.viewnaver.browser.win32.Win32BrowserThread;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;

public class Win32BrowserImpl
extends SimpleBrowserImpl {
    int hBrowser = 0;
    private final Win32BrowserThread browserThread;
    boolean firstNotify = true;
    private final Canvas canvas;
    private Vector<Runnable> browserCommands = new Vector();

    private void flushCommands() {
        if (this.browserCommands.size() > 0) {
            int i = 0;
            while (i < this.browserCommands.size()) {
                this.browserCommands.elementAt(i).run();
                ++i;
            }
            this.browserCommands.clear();
        }
    }

    private void execBrowserCommand(Runnable r) {
        if (this.hBrowser == 0) {
            this.browserCommands.addElement(r);
        } else {
            this.flushCommands();
            r.run();
        }
    }

    public Win32BrowserImpl(Win32BrowserThread browserThread, String initialHtml) {
        this.canvas = new BrowserCanvas();
        this.canvas.setFocusable(true);
        this.browserThread = browserThread;
        if (initialHtml != null) {
            this.beginDocWriting();
            this.writeDocHtml(initialHtml);
            this.endDocWriting();
        }
    }

    @Override
    public Component getComponent() {
        return this.canvas;
    }

    private void resizeBrowser(final int width, final int height) {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.resizeWin32Browser(Win32BrowserImpl.this.hBrowser, width, height);
            }
        });
    }

    @Override
    public void setBodyHtml(final String html) {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.setWin32BodyHtml(Win32BrowserImpl.this.hBrowser, html);
            }
        });
    }

    @Override
    public void insertBodyHtml(final String tagid, final String html) {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.insertWin32BodyHtml(Win32BrowserImpl.this.hBrowser, tagid, html);
            }
        });
    }

    @Override
    public void replaceBodyHtml(final String tagid, final String html) {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.replaceWin32BodyHtml(Win32BrowserImpl.this.hBrowser, tagid, html);
            }
        });
    }

    public String getBodyHtml() {
        if (this.hBrowser == 0) {
            return null;
        }
        return this.browserThread.getWin32BodyHtml(this.hBrowser);
    }

    public void setEditable(boolean editable) {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.setWin32Editable(this.hBrowser, editable);
    }

    public void toggleBold() {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.toggleWin32Bold(this.hBrowser);
    }

    public void setColor(String color) {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.setWin32Color(this.hBrowser, color);
    }

    public void insertHR() {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.insertWin32HR(this.hBrowser);
    }

    public void toggleItalic() {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.toggleWin32Italic(this.hBrowser);
    }

    public void toggleUnderLine() {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.toggleWin32UnderLine(this.hBrowser);
    }

    public void setFontName(String fontName) {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.setWin32FontName(this.hBrowser, fontName);
    }

    public void setFontSize(String fontSize) {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.setWin32FontSize(this.hBrowser, fontSize);
    }

    @Override
    public void scrollTop(final String tagid) {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.win32scrollTop(Win32BrowserImpl.this.hBrowser, tagid);
            }
        });
    }

    @Override
    public void refresh() {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.win32Refresh(this.hBrowser);
    }

    @Override
    public void reset() {
        if (this.hBrowser == 0) {
            return;
        }
        this.browserThread.win32Reset(this.hBrowser);
    }

    @Override
    public final void beginDocWriting() {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public final void writeDocHtml(final String html) {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.writeWin32DocHtml(Win32BrowserImpl.this.hBrowser, html);
            }
        });
    }

    @Override
    public final void endDocWriting() {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.closeWin32DocHtml(Win32BrowserImpl.this.hBrowser);
            }
        });
    }

    @Override
    public void clearDocHtml() {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.clearWin32DocHtml(Win32BrowserImpl.this.hBrowser);
            }
        });
    }

    @Override
    public void closeDocHtml() {
        this.execBrowserCommand(new Runnable(){

            @Override
            public void run() {
                Win32BrowserImpl.this.browserThread.closeWin32DocHtml(Win32BrowserImpl.this.hBrowser);
            }
        });
    }

    private class BrowserCanvas
    extends Canvas {
        public BrowserCanvas() {
            this.setFocusable(true);
            this.setMinimumSize(new Dimension(1, 1));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!Win32BrowserImpl.this.firstNotify) {
                ViewNaver.println("\u8b66\u544a\uff1aBrowser#addNotify()\u304c\u4e8c\u56de\u547c\u3070\u308c\u307e\u3057\u305f\u304c\u3001Win32BrowserImpl\u306f\u518d\u5229\u7528\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002\n\u7d9a\u884c\u3059\u308b\u3068\u5371\u967a\u306a\u72b6\u614b\u3068\u306a\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\n");
            }
            if (Win32BrowserImpl.this.hBrowser == 0) {
                Win32BrowserImpl.this.hBrowser = Win32BrowserImpl.this.browserThread.createWin32Browser(this);
                Win32BrowserThread.addBrowser(Win32BrowserImpl.this);
                Win32BrowserImpl.this.firstNotify = false;
                Win32BrowserImpl.this.flushCommands();
            }
        }

        @Override
        public void removeNotify() {
            Win32BrowserThread.removeBrowser(Win32BrowserImpl.this);
            if (Win32BrowserImpl.this.hBrowser != 0) {
                Win32BrowserImpl.this.browserThread.disposeWin32Browser(Win32BrowserImpl.this.hBrowser);
                Win32BrowserImpl.this.hBrowser = 0;
            }
            super.removeNotify();
        }

        @Override
        public void setSize(int width, int height) {
            super.setSize(width, height);
            Win32BrowserImpl.this.resizeBrowser(width, height);
        }

        @Override
        public void setSize(Dimension d) {
            super.setSize(d);
            Win32BrowserImpl.this.resizeBrowser(d.width, d.height);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            Win32BrowserImpl.this.resizeBrowser(width, height);
        }

        @Override
        public void setBounds(Rectangle r) {
            super.setBounds(r);
            Win32BrowserImpl.this.resizeBrowser(r.width, r.height);
        }
    }
}

