/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.nvrlib.parser;

import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.model.MessageTitle;
import com.aibonware.nvrlib.model.MessageTitleList;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.ParsingContext;
import com.aibonware.nvrlib.parser.ParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MessageListParser {
    String urlString;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public MessageListParser(String urlString) {
        this.urlString = urlString;
    }

    public MessageTitleList parse(NaverSession naverSession) throws NetException, ParsingException {
        BufferedReader reader = naverSession.open(this.urlString, "UTF8");
        MessageTitleList result = this.parse(reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("URL\u30af\u30ed\u30fc\u30ba\u5931\u6557", e);
        }
        return result;
    }

    public MessageTitleList parse(BufferedReader reader) throws ParsingException, NetException {
        ParsingContext ct = new ParsingContext(reader);
        try {
            ct.seek("\u30e1\u30c3\u30bb\u30fc\u30b8:");
            String receivedMessageNumText = ct.cut("\u53d7\u4fe1\u7bb1", "\u901a");
            String preReceivedMessageNumText = ct.cut("\u672a\u8aad", "\u901a");
            String sendMessageNumText = ct.cut("\u9001\u4fe1\u7bb1", "\u901a");
            int receivedNum = Integer.parseInt(receivedMessageNumText.trim());
            int preReceivedNum = Integer.parseInt(preReceivedMessageNumText.trim());
            int sendNum = Integer.parseInt(sendMessageNumText.trim());
            MessageTitleList messages = new MessageTitleList(receivedNum, preReceivedNum, sendNum);
            ct.seek("<!-- List -->");
            while (ct.seek("<tr", "<!-- //List -->")) {
                String preReceivedText = ct.cut(null, "checkbox");
                boolean received = !preReceivedText.contains("bold");
                boolean stored = preReceivedText.contains("background-color");
                ct.seek("http://static.naver.com/enjoyjapan/tbbs/img_09/ico_message");
                String countryText = ct.cut("http://static.naver.com/enjoykorea/uin/ico_", ".gif");
                Country country = countryText.equals("jpn") ? Country.JAPAN : (countryText.equals("kor") ? Country.KOREA : Country.UNKNOWN);
                ct.seek(">");
                String person = ct.cut(null, "</td>").trim();
                String messageIdText = ct.cut("_view.php?no=", "\">").trim();
                int messageId = Integer.parseInt(messageIdText);
                String messageTitle = ct.cut(null, "</a>").trim();
                String dateText = ct.cut("gray04\">", "</td>");
                Date date = df.parse(dateText);
                MessageTitle message = new MessageTitle(person, country, received, messageId, messageTitle, date, stored);
                messages.addMessageTitle(message);
                ct.seek("</tr>");
            }
            return messages;
        }
        catch (NumberFormatException e) {
            throw new ParsingException(e, ct.text.toString());
        }
        catch (ParseException e) {
            throw new ParsingException(e, ct.text.toString());
        }
    }
}

