/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.runtime.builtin.IRubyObject;

public class TypeConverter {
    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod, boolean raise) {
        if (!obj.respondsTo(convertMethod)) {
            if (raise) {
                String type = obj.isNil() ? "nil" : (obj instanceof RubyBoolean ? (obj.isTrue() ? "true" : "false") : obj.getMetaClass().getRealClass().getName());
                throw obj.getRuntime().newTypeError("can't convert " + type + " into " + target);
            }
            return obj.getRuntime().getNil();
        }
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMethodIndex, convertMethod);
    }

    public static final IRubyObject convertToType(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethodIndex, convertMethod, true);
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }

    public static final IRubyObject convertToTypeWithCheck(IRubyObject obj, RubyClass target, int convertMethodIndex, String convertMethod) {
        if (target.isInstance(obj)) {
            return obj;
        }
        IRubyObject val = TypeConverter.convertToType(obj, target, convertMethodIndex, convertMethod, false);
        if (val.isNil()) {
            return val;
        }
        if (!target.isInstance(val)) {
            throw obj.getRuntime().newTypeError(obj.getMetaClass() + "#" + convertMethod + " should return " + target.getName());
        }
        return val;
    }
}

