/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class RubyTCPSocket
extends RubyIPSocket {
    private static ObjectAllocator TCPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyTCPSocket(runtime, klass);
        }
    };

    static void createTCPSocket(Ruby runtime) {
        RubyClass rb_cTCPSocket = runtime.defineClass("TCPSocket", runtime.fastGetClass("IPSocket"), TCPSOCKET_ALLOCATOR);
        rb_cTCPSocket.includeModule(runtime.fastGetClass("Socket").fastGetConstant("Constants"));
        rb_cTCPSocket.defineAnnotatedMethods(RubyTCPSocket.class);
        runtime.getObject().fastSetConstant("TCPsocket", rb_cTCPSocket);
    }

    public RubyTCPSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private int getPortFrom(IRubyObject arg) {
        return RubyNumeric.fix2int(arg instanceof RubyString ? RubyNumeric.str2inum(this.getRuntime(), (RubyString)arg, 0, true) : arg);
    }

    @JRubyMethod(required=2, optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 2, 4);
        String remoteHost = args[0].isNil() ? "localhost" : args[0].convertToString().toString();
        int remotePort = this.getPortFrom(args[1]);
        String localHost = args.length >= 3 ? args[2].convertToString().toString() : null;
        int localPort = args.length == 4 ? this.getPortFrom(args[3]) : 0;
        try {
            SocketChannel channel = null;
            if (localHost == null) {
                InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(remoteHost), remotePort);
                channel = SocketChannel.open(addr);
            } else {
                channel = SocketChannel.open();
                Socket socket2 = channel.socket();
                socket2.bind(new InetSocketAddress(InetAddress.getByName(localHost), localPort));
                socket2.connect(new InetSocketAddress(InetAddress.getByName(remoteHost), remotePort));
            }
            channel.finishConnect();
            this.initSocket(new ChannelDescriptor(channel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (ConnectException e) {
            throw this.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw RubyTCPSocket.sockerr(this, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw RubyTCPSocket.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(frame=true, rest=true, meta=true)
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyTCPSocket sock = (RubyTCPSocket)recv.callMethod(recv.getRuntime().getCurrentContext(), "new", args);
        if (!block.isGiven()) {
            return sock;
        }
        try {
            IRubyObject iRubyObject = block.yield(recv.getRuntime().getCurrentContext(), sock);
            return iRubyObject;
        }
        finally {
            if (sock.openFile.isOpen()) {
                sock.close();
            }
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(IRubyObject recv, IRubyObject hostname) {
        try {
            IRubyObject[] ret = new IRubyObject[4];
            Ruby r = recv.getRuntime();
            InetAddress addr = InetAddress.getByName(hostname.convertToString().toString());
            ret[0] = r.newString(addr.getCanonicalHostName());
            ret[1] = r.newArray();
            ret[2] = r.newFixnum(2);
            ret[3] = r.newString(addr.getHostAddress());
            return r.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubyTCPSocket.sockerr(recv, "gethostbyname: name or service not known");
        }
    }
}

