/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

@JRubyClass(name={"Range"}, include={"Enumerable"})
public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isExclusive;
    private static final ObjectAllocator RANGE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyRange(runtime, klass);
        }
    };
    private static byte[] DOTDOTDOT = "...".getBytes();
    private static byte[] DOTDOT = "..".getBytes();
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime, Object obj, RubyClass type, MarshalStream marshalStream) throws IOException {
            RubyRange range = (RubyRange)obj;
            marshalStream.registerLinkTarget(range);
            List<Variable<IRubyObject>> attrs = range.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("begin", range.begin));
            attrs.add(new VariableEntry<IRubyObject>("end", range.end));
            attrs.add(new VariableEntry<RubyBoolean>("excl", range.isExclusive ? runtime.getTrue() : runtime.getFalse()));
            marshalStream.dumpVariables(attrs);
        }

        public Object unmarshalFrom(Ruby runtime, RubyClass type, UnmarshalStream unmarshalStream) throws IOException {
            RubyRange range = (RubyRange)type.allocate();
            unmarshalStream.registerLinkTarget(range);
            unmarshalStream.defaultVariablesUnmarshal(range);
            range.begin = range.removeInternalVariable("begin");
            range.end = range.removeInternalVariable("end");
            range.isExclusive = range.removeInternalVariable("excl").isTrue();
            return range;
        }
    };

    public static RubyClass createRangeClass(Ruby runtime) {
        RubyClass result = runtime.defineClass("Range", runtime.getObject(), RANGE_ALLOCATOR);
        runtime.setRange(result);
        result.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyRange;
            }
        };
        result.setMarshal(RANGE_MARSHAL);
        result.includeModule(runtime.getEnumerable());
        result.defineAnnotatedMethods(RubyRange.class);
        return result;
    }

    private RubyRange(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.begin = this.end = runtime.getNil();
    }

    public static RubyRange newRange(Ruby runtime, ThreadContext context, IRubyObject begin, IRubyObject end, boolean isExclusive) {
        RubyRange range = new RubyRange(runtime, runtime.getRange());
        range.init(context, begin, end, isExclusive);
        return range;
    }

    public static RubyRange newExclusiveRange(Ruby runtime, ThreadContext context, IRubyObject begin, IRubyObject end) {
        RubyRange range = new RubyRange(runtime, runtime.getRange());
        range.init(context, begin, end, true);
        return range;
    }

    public static RubyRange newInclusiveRange(Ruby runtime, ThreadContext context, IRubyObject begin, IRubyObject end) {
        RubyRange range = new RubyRange(runtime, runtime.getRange());
        range.init(context, begin, end, false);
        return range;
    }

    protected void copySpecialInstanceVariables(IRubyObject clone) {
        RubyRange range = (RubyRange)clone;
        range.begin = this.begin;
        range.end = this.end;
        range.isExclusive = this.isExclusive;
    }

    final long[] begLen(long len, int err) {
        long beg = RubyNumeric.num2long(this.begin);
        long end = RubyNumeric.num2long(this.end);
        if (beg < 0L && (beg += len) < 0L) {
            if (err != 0) {
                throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw this.getRuntime().newRangeError(beg + ".." + (this.isExclusive ? "." : "") + end + " out of range");
                }
                return null;
            }
            if (end > len) {
                end = len;
            }
        }
        if (end < 0L) {
            end += len;
        }
        if (!this.isExclusive) {
            ++end;
        }
        if ((len = end - beg) < 0L) {
            len = 0L;
        }
        return new long[]{beg, len};
    }

    private void init(ThreadContext context, IRubyObject begin, IRubyObject end, boolean isExclusive) {
        if (!(begin instanceof RubyFixnum) || !(end instanceof RubyFixnum)) {
            try {
                IRubyObject result = begin.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", end);
                if (result.isNil()) {
                    throw this.getRuntime().newArgumentError("bad value for range");
                }
            }
            catch (RaiseException re) {
                throw this.getRuntime().newArgumentError("bad value for range");
            }
        }
        this.begin = begin;
        this.end = end;
        this.isExclusive = isExclusive;
    }

    @JRubyMethod(name={"initialize"}, required=2, optional=1, frame=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args, Block unusedBlock) {
        this.init(context, args[0], args[1], args.length > 2 && args[2].isTrue());
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"first", "begin"})
    public IRubyObject first() {
        return this.begin;
    }

    @JRubyMethod(name={"last", "end"})
    public IRubyObject last() {
        return this.end;
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        long hash;
        long h = hash = this.isExclusive ? 1L : 0L;
        long v = this.begin.callMethod(context, MethodIndex.HASH, "hash").convertToInteger().getLongValue();
        hash ^= v << 1;
        v = this.end.callMethod(context, MethodIndex.HASH, "hash").convertToInteger().getLongValue();
        hash ^= v << 9;
        return this.getRuntime().newFixnum(hash ^= h << 24);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        RubyString str = RubyRange.inspect(context, this.begin).strDup();
        RubyString str2 = RubyRange.inspect(context, this.end);
        str.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        str.concat(str2);
        str.infectBy(str2);
        return str;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        RubyString str = RubyString.objAsString(context, this.begin).strDup();
        RubyString str2 = RubyString.objAsString(context, this.end);
        str.cat(this.isExclusive ? DOTDOTDOT : DOTDOT);
        str.concat(str2);
        str.infectBy(str2);
        return str;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p() {
        return this.getRuntime().newBoolean(this.isExclusive);
    }

    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)other;
        if (RubyRange.equalInternal(context, this.begin, otherRange.begin) && RubyRange.equalInternal(context, this.end, otherRange.end) && this.isExclusive == otherRange.isExclusive) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRange)) {
            return this.getRuntime().getFalse();
        }
        RubyRange otherRange = (RubyRange)other;
        if (RubyRange.eqlInternal(context, this.begin, otherRange.begin) && RubyRange.eqlInternal(context, this.end, otherRange.end) && this.isExclusive == otherRange.isExclusive) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private IRubyObject rangeLt(ThreadContext context, IRubyObject a, IRubyObject b) {
        IRubyObject result = a.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", b);
        if (result.isNil()) {
            return null;
        }
        return RubyComparable.cmpint(context, result, a, b) < 0 ? this.getRuntime().getTrue() : null;
    }

    private IRubyObject rangeLe(ThreadContext context, IRubyObject a, IRubyObject b) {
        IRubyObject result = a.callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", b);
        if (result.isNil()) {
            return null;
        }
        int c = RubyComparable.cmpint(context, result, a, b);
        if (c == 0) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return c < 0 ? this.getRuntime().getTrue() : null;
    }

    private void rangeEach(ThreadContext context, RangeCallBack callback) {
        IRubyObject v = this.begin;
        if (this.isExclusive) {
            while (this.rangeLt(context, v, this.end) != null) {
                callback.call(context, v);
                v = v.callMethod(context, "succ");
            }
        } else {
            IRubyObject c;
            while ((c = this.rangeLe(context, v, this.end)) != null && c.isTrue()) {
                callback.call(context, v);
                if (c != RubyFixnum.zero(this.getRuntime())) {
                    v = v.callMethod(context, "succ");
                    continue;
                }
                break;
            }
        }
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(ThreadContext context, final Block block) {
        if (!this.begin.respondsTo("succ")) {
            throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long lim = ((RubyFixnum)this.end).getLongValue();
            if (!this.isExclusive) {
                ++lim;
            }
            for (long i = ((RubyFixnum)this.begin).getLongValue(); i < lim; ++i) {
                block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
            }
        } else if (this.begin instanceof RubyString) {
            ((RubyString)this.begin).upto(context, this.end, this.isExclusive, block);
        } else {
            this.rangeEach(context, new RangeCallBack(){

                void call(ThreadContext context, IRubyObject arg) {
                    block.yield(context, arg);
                }
            });
        }
        return this;
    }

    @JRubyMethod(name={"step"}, optional=1, frame=true)
    public IRubyObject step(ThreadContext context, IRubyObject[] args, Block block) {
        IRubyObject step = args.length == 0 ? RubyFixnum.one(this.getRuntime()) : args[0];
        long unit = RubyNumeric.num2long(step);
        if (unit < 0L) {
            throw this.getRuntime().newArgumentError("step can't be negative");
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            if (unit == 0L) {
                throw this.getRuntime().newArgumentError("step can't be 0");
            }
            long e = ((RubyFixnum)this.end).getLongValue();
            if (!this.isExclusive) {
                ++e;
            }
            for (long i = ((RubyFixnum)this.begin).getLongValue(); i < e; i += unit) {
                block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
            }
        } else {
            IRubyObject tmp = this.begin.checkStringType();
            if (!tmp.isNil()) {
                if (unit == 0L) {
                    throw this.getRuntime().newArgumentError("step can't be 0");
                }
                StepBlockCallBack callback = new StepBlockCallBack(block, RubyFixnum.one(this.getRuntime()), step);
                Block blockCallback = CallBlock.newCallClosure(this, this.getRuntime().getRange(), Arity.singleArgument(), callback, context);
                ((RubyString)tmp).upto(context, this.end, this.isExclusive, blockCallback);
            } else if (this.begin instanceof RubyNumeric) {
                int methodIndex;
                String method;
                if (RubyRange.equalInternal(context, step, RubyFixnum.zero(this.getRuntime()))) {
                    throw this.getRuntime().newArgumentError("step can't be 0");
                }
                if (this.isExclusive) {
                    method = "<";
                    methodIndex = MethodIndex.OP_LT;
                } else {
                    method = "<=";
                    methodIndex = MethodIndex.OP_LE;
                }
                IRubyObject beg = this.begin;
                while (beg.callMethod(context, methodIndex, method, this.end).isTrue()) {
                    block.yield(context, beg);
                    beg = beg.callMethod(context, MethodIndex.OP_PLUS, "+", step);
                }
            } else {
                if (unit == 0L) {
                    throw this.getRuntime().newArgumentError("step can't be 0");
                }
                if (!this.begin.respondsTo("succ")) {
                    throw this.getRuntime().newTypeError("can't iterate from " + this.begin.getMetaClass().getName());
                }
                this.rangeEach(context, new StepBlockCallBack(block, RubyFixnum.one(this.getRuntime()), step));
            }
        }
        return this;
    }

    @JRubyMethod(name={"include?", "member?", "==="}, required=1)
    public RubyBoolean include_p(ThreadContext context, IRubyObject obj) {
        if (this.rangeLe(context, this.begin, obj) != null && (this.isExclusive ? this.rangeLt(context, obj, this.end) != null : this.rangeLe(context, obj, this.end) != null)) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    private static final class StepBlockCallBack
    extends RangeCallBack
    implements BlockCallback {
        final Block block;
        IRubyObject iter;
        final IRubyObject step;

        StepBlockCallBack(Block block, IRubyObject iter, IRubyObject step) {
            this.block = block;
            this.iter = iter;
            this.step = step;
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] args, Block originalBlock) {
            this.call(context, args[0]);
            return context.getRuntime().getNil();
        }

        void call(ThreadContext context, IRubyObject arg) {
            this.iter = this.iter instanceof RubyFixnum ? RubyFixnum.newFixnum(context.getRuntime(), ((RubyFixnum)this.iter).getLongValue() - 1L) : this.iter.callMethod(context, MethodIndex.OP_MINUS, "-", RubyFixnum.one(context.getRuntime()));
            if (this.iter == RubyFixnum.zero(context.getRuntime())) {
                this.block.yield(context, arg);
                this.iter = this.step;
            }
        }
    }

    private static abstract class RangeCallBack {
        private RangeCallBack() {
        }

        abstract void call(ThreadContext var1, IRubyObject var2);
    }
}

