/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.CompatVersion;
import org.jruby.Profile;
import org.jruby.Ruby;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.MainExitException;
import org.jruby.runtime.Constants;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.ClassCache;
import org.jruby.util.JRubyFile;
import org.jruby.util.KCode;
import org.jruby.util.NormalizedFile;
import org.jruby.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyInstanceConfig {
    private InputStream input = System.in;
    private PrintStream output = System.out;
    private PrintStream error = System.err;
    private Profile profile = Profile.DEFAULT;
    private boolean objectSpaceEnabled = SafePropertyAccessor.getBoolean("jruby.objectspace.enabled", false);
    private CompileMode compileMode = CompileMode.JIT;
    private boolean runRubyInProcess = true;
    private String currentDirectory;
    private Map environment;
    private String[] argv = new String[0];
    private final boolean jitLogging;
    private final boolean jitLoggingVerbose;
    private final int jitLogEvery;
    private final int jitThreshold;
    private final int jitMax;
    private final boolean samplingEnabled;
    private CompatVersion compatVersion;
    private ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
    private ClassLoader loader = this.contextLoader == null ? RubyInstanceConfig.class.getClassLoader() : this.contextLoader;
    private ClassCache<Script> classCache;
    private List<String> loadPaths = new ArrayList<String>();
    private StringBuffer inlineScript = new StringBuffer();
    private boolean hasInlineScript = false;
    private String scriptFileName = null;
    private List<String> requiredLibraries = new ArrayList<String>();
    private boolean benchmarking = false;
    private boolean argvGlobalsOn = false;
    private boolean assumeLoop = false;
    private boolean assumePrinting = false;
    private Map optionGlobals = new HashMap();
    private boolean processLineEnds = false;
    private boolean split = false;
    private Boolean verbose = Boolean.FALSE;
    private boolean debug = false;
    private boolean showVersion = false;
    private boolean showCopyright = false;
    private boolean endOfArguments = false;
    private boolean shouldRunInterpreter = true;
    private boolean shouldPrintUsage = false;
    private boolean shouldPrintProperties = false;
    private boolean yarv = false;
    private boolean rubinius = false;
    private boolean yarvCompile = false;
    private KCode kcode = KCode.NONE;
    private String recordSeparator = "\n";
    private boolean shouldCheckSyntax = false;
    private String inputFieldSeparator = null;
    private int safeLevel = 0;
    private String jrubyHome;
    public static final boolean FASTEST_COMPILE_ENABLED = SafePropertyAccessor.getBoolean("jruby.compile.fastest");
    public static final boolean BOXED_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.boxed");
    public static final boolean FASTOPS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.fastops");
    public static final boolean FRAMELESS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.frameless");
    public static final boolean POSITIONLESS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.positionless");
    public static final boolean THREADLESS_COMPILE_ENABLED = FASTEST_COMPILE_ENABLED || SafePropertyAccessor.getBoolean("jruby.compile.threadless");
    public static final boolean INDEXED_METHODS = SafePropertyAccessor.getBoolean("jruby.indexed.methods");
    public static final boolean FORK_ENABLED = SafePropertyAccessor.getBoolean("jruby.fork.enabled");
    public static final boolean POOLING_ENABLED = SafePropertyAccessor.getBoolean("jruby.thread.pool.enabled");
    public static final int POOL_MAX = SafePropertyAccessor.getInt("jruby.thread.pool.max", Integer.MAX_VALUE);
    public static final int POOL_MIN = SafePropertyAccessor.getInt("jruby.thread.pool.min", 0);
    public static final int POOL_TTL = SafePropertyAccessor.getInt("jruby.thread.pool.ttl", 60);
    public static final boolean NATIVE_NET_PROTOCOL = SafePropertyAccessor.getBoolean("jruby.native.net.protocol", false);
    public static boolean nativeEnabled = true;
    private LoadServiceCreator creator = LoadServiceCreator.DEFAULT;
    public int characterIndex = 0;

    public RubyInstanceConfig() {
        this.currentDirectory = Ruby.isSecurityRestricted() ? "/" : JRubyFile.getFileProperty("user.dir");
        this.samplingEnabled = SafePropertyAccessor.getBoolean("jruby.sampling.enabled", false);
        String compatString = SafePropertyAccessor.getProperty("jruby.compat.version", "RUBY1_8");
        if (compatString.equalsIgnoreCase("RUBY1_8")) {
            this.compatVersion = CompatVersion.RUBY1_8;
        } else if (compatString.equalsIgnoreCase("RUBY1_9")) {
            this.compatVersion = CompatVersion.RUBY1_9;
        } else {
            System.err.println("Compatibility version `" + compatString + "' invalid; use RUBY1_8 or RUBY1_9. Using RUBY1_8.");
            this.compatVersion = CompatVersion.RUBY1_8;
        }
        if (Ruby.isSecurityRestricted()) {
            this.compileMode = CompileMode.OFF;
            this.jitLogging = false;
            this.jitLoggingVerbose = false;
            this.jitLogEvery = 0;
            this.jitThreshold = -1;
            this.jitMax = 0;
        } else {
            boolean jitProperty;
            String threshold = SafePropertyAccessor.getProperty("jruby.jit.threshold");
            String max = SafePropertyAccessor.getProperty("jruby.jit.max");
            this.runRubyInProcess = SafePropertyAccessor.getBoolean("jruby.launch.inproc", true);
            boolean bl = jitProperty = SafePropertyAccessor.getProperty("jruby.jit.enabled") != null;
            if (jitProperty) {
                this.error.print("jruby.jit.enabled property is deprecated; use jruby.compile.mode=(OFF|JIT|FORCE) for -C, default, and +C flags");
                this.compileMode = SafePropertyAccessor.getBoolean("jruby.jit.enabled") ? CompileMode.JIT : CompileMode.OFF;
            } else {
                String jitModeProperty = SafePropertyAccessor.getProperty("jruby.compile.mode", "JIT");
                if (jitModeProperty.equals("OFF")) {
                    this.compileMode = CompileMode.OFF;
                } else if (jitModeProperty.equals("JIT")) {
                    this.compileMode = CompileMode.JIT;
                } else if (jitModeProperty.equals("FORCE")) {
                    this.compileMode = CompileMode.FORCE;
                } else {
                    this.error.print("jruby.compile.mode property must be OFF, JIT, FORCE, or unset; defaulting to JIT");
                    this.compileMode = CompileMode.JIT;
                }
            }
            this.jitLogging = SafePropertyAccessor.getBoolean("jruby.jit.logging");
            this.jitLoggingVerbose = SafePropertyAccessor.getBoolean("jruby.jit.logging.verbose");
            String logEvery = SafePropertyAccessor.getProperty("jruby.jit.logEvery");
            this.jitLogEvery = logEvery == null ? 0 : Integer.parseInt(logEvery);
            this.jitThreshold = threshold == null ? 50 : Integer.parseInt(threshold);
            this.jitMax = max == null ? 4096 : Integer.parseInt(max);
        }
        this.classCache = new ClassCache(this.loader, this.jitMax);
        if (FORK_ENABLED) {
            this.error.print("WARNING: fork is highly unlikely to be safe or stable on the JVM. Have fun!\n");
        }
    }

    public LoadServiceCreator getLoadServiceCreator() {
        return this.creator;
    }

    public void setLoadServiceCreator(LoadServiceCreator creator) {
        this.creator = creator;
    }

    public LoadService createLoadService(Ruby runtime) {
        return this.creator.create(runtime);
    }

    public String getBasicUsageHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("Usage: jruby [switches] [--] [programfile] [arguments]\n").append("  -0[octal]       specify record separator (\u0000, if no argument)\n").append("  -a              autosplit mode with -n or -p (splits $_ into $F)\n").append("  -b              benchmark mode, times the script execution\n").append("  -c              check syntax only\n").append("  -Cdirectory     cd to directory, before executing your script\n").append("  -d              set debugging flags (set $DEBUG to true)\n").append("  -e 'command'    one line of script. Several -e's allowed. Omit [programfile]\n").append("  -Fpattern       split() pattern for autosplit (-a)\n").append("  -Idirectory     specify $LOAD_PATH directory (may be used more than once)\n").append("  -J[java option] pass an option on to the JVM (e.g. -J-Xmx512m)\n").append("                    use --properties to list JRuby properties\n").append("  -Kkcode         specifies KANJI (Japanese) code-set\n").append("  -l              enable line ending processing\n").append("  -n              assume 'while gets(); ... end' loop around your script\n").append("  -p              assume loop like -n but print line also like sed\n").append("  -rlibrary       require the library, before executing your script\n").append("  -s              enable some switch parsing for switches after script name\n").append("  -S              look for the script in bin or using PATH environment variable\n").append("  -T[level]       turn on tainting checks\n").append("  -v              print version number, then turn on verbose mode\n").append("  -w              turn warnings on for your script\n").append("  -W[level]       set warning level; 0=silence, 1=medium, 2=verbose (default)\n").append("  -X[option]      enable extended option (omit option to list)\n").append("  --copyright     print the copyright\n").append("  --debug         sets the execution mode most suitable for debugger functionality\n").append("  --jdb           runs JRuby process under JDB\n").append("  --properties    List all configuration Java properties (pass -J-Dproperty=value)\n").append("  --version       print the version\n");
        return sb.toString();
    }

    public String getExtendedHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("These flags are for extended JRuby options.\n").append("Specify them by passing -X<option>\n").append("  -O              run with ObjectSpace disabled (default; improves performance)\n").append("  +O              run with ObjectSpace enabled (reduces performance)\n").append("  -C              disable all compilation\n").append("  +C              force compilation of all scripts before they are run (except eval)\n").append("  -y              read a YARV-compiled Ruby script and run that (EXPERIMENTAL)\n").append("  -Y              compile a Ruby script into YARV bytecodes and run this (EXPERIMENTAL)\n").append("  -R              read a Rubinius-compiled Ruby script and run that (EXPERIMENTAL)\n");
        return sb.toString();
    }

    public String getPropertyHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("These properties can be used to alter runtime behavior for perf or compatibility.\n").append("Specify them by passing -J-D<property>=<value>\n").append("\nCOMPILER SETTINGS:\n").append("    jruby.compile.mode=JIT|FORCE|OFF\n").append("       Set compilation mode. JIT is default; FORCE compiles all, OFF disables\n").append("    jruby.compile.fastest=true|false\n").append("       (EXPERIMENTAL) Turn on all experimental compiler optimizations\n").append("    jruby.compile.boxed=true|false\n").append("       (EXPERIMENTAL) Use boxed variables; this can speed up some methods. Default is false\n").append("    jruby.compile.frameless=true|false\n").append("       (EXPERIMENTAL) Turn on frameless compilation where possible\n").append("    jruby.compile.positionless=true|false\n").append("       (EXPERIMENTAL) Turn on compilation that avoids updating Ruby position info. Default is false\n").append("    jruby.compile.threadless=true|false\n").append("       (EXPERIMENTAL) Turn on compilation without polling for \"unsafe\" thread events. Default is false\n").append("    jruby.compile.fastops=true|false\n").append("       (EXPERIMENTAL) Turn on fast operators for Fixnum. Default is false\n").append("\nJIT SETTINGS:\n").append("    jruby.jit.threshold=<invocation count>\n").append("       Set the JIT threshold to the specified method invocation count. Default is 20\n").append("    jruby.jit.max=<method count>\n").append("       Set the max count of active methods eligible for JIT-compilation.\n").append("       Default is 2048 per runtime. A value of 0 disables JIT, -1 disables max.\n").append("    jruby.jit.logging=true|false\n").append("       Enable JIT logging (reports successful compilation). Default is false\n").append("    jruby.jit.logging.verbose=true|false\n").append("       Enable verbose JIT logging (reports failed compilation). Default is false\n").append("    jruby.jit.logEvery=<method count>\n").append("       Log a message every n methods JIT compiled. Default is 0 (off).\n").append("\nNATIVE SUPPORT:\n").append("    jruby.native.enabled=true|false\n").append("       Enable/disable native extensions (like JNA for non-Java APIs; Default is true\n").append("       (This affects all JRuby instances in a given JVM)\n").append("    jruby.native.verbose=true|false\n").append("       Enable verbose logging of native extension loading. Default is false.\n").append("    jruby.fork.enabled=true|false\n").append("       (EXPERIMENTAL, maybe dangerous) Enable fork(2) on platforms that support it.\n").append("\nTHREAD POOLING:\n").append("    jruby.thread.pool.enabled=true|false\n").append("       Enable reuse of native backing threads via a thread pool. Default is false.\n").append("    jruby.thread.pool.min=<min thread count>\n").append("       The minimum number of threads to keep alive in the pool. Default is 0.\n").append("    jruby.thread.pool.max=<max thread count>\n").append("       The maximum number of threads to allow in the pool. Default is unlimited.\n").append("    jruby.thread.pool.ttl=<time to live, in seconds>\n").append("       The maximum number of seconds to keep alive an idle thread. Default is 60.\n").append("\nMISCELLANY:\n").append("    jruby.compat.version=RUBY1_8|RUBY1_9\n").append("       Specify the major Ruby version to be compatible with; Default is RUBY1_8\n").append("    jruby.indexed.methods=true|false\n").append("       Generate \"invokers\" for core classes using a single indexed class\n").append("    jruby.objectspace.enabled=true|false\n").append("       Enable or disable ObjectSpace.each_object (default is disabled)\n").append("    jruby.launch.inproc=true|false\n").append("       Set in-process launching of e.g. system('ruby ...'). Default is true\n");
        return sb.toString();
    }

    public String getVersionString() {
        StringBuffer buf = new StringBuffer("ruby ");
        switch (this.compatVersion) {
            case RUBY1_8: {
                buf.append(Constants.RUBY_VERSION);
                break;
            }
            case RUBY1_9: {
                buf.append(Constants.RUBY1_9_VERSION);
            }
        }
        buf.append(" (").append(Constants.COMPILE_DATE + " rev " + Constants.REVISION).append(") [").append(SafePropertyAccessor.getProperty("os.arch", "unknown") + "-jruby" + Constants.VERSION).append("]").append("\n");
        return buf.toString();
    }

    public String getCopyrightString() {
        return "JRuby - Copyright (C) 2001-2008 The JRuby Community (and contribs)\n";
    }

    public void processArguments(String[] arguments) {
        new ArgumentProcessor(arguments).processArguments();
    }

    public CompileMode getCompileMode() {
        return this.compileMode;
    }

    public void setCompileMode(CompileMode compileMode) {
        this.compileMode = compileMode;
    }

    public boolean isJitLogging() {
        return this.jitLogging;
    }

    public boolean isJitLoggingVerbose() {
        return this.jitLoggingVerbose;
    }

    public int getJitLogEvery() {
        return this.jitLogEvery;
    }

    public boolean isSamplingEnabled() {
        return this.samplingEnabled;
    }

    public int getJitThreshold() {
        return this.jitThreshold;
    }

    public int getJitMax() {
        return this.jitMax;
    }

    public boolean isRunRubyInProcess() {
        return this.runRubyInProcess;
    }

    public void setRunRubyInProcess(boolean flag) {
        this.runRubyInProcess = flag;
    }

    public void setInput(InputStream newInput) {
        this.input = newInput;
    }

    public InputStream getInput() {
        return this.input;
    }

    public CompatVersion getCompatVersion() {
        return this.compatVersion;
    }

    public void setOutput(PrintStream newOutput) {
        this.output = newOutput;
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public void setError(PrintStream newError) {
        this.error = newError;
    }

    public PrintStream getError() {
        return this.error;
    }

    public void setCurrentDirectory(String newCurrentDirectory) {
        this.currentDirectory = newCurrentDirectory;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setProfile(Profile newProfile) {
        this.profile = newProfile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setObjectSpaceEnabled(boolean newObjectSpaceEnabled) {
        this.objectSpaceEnabled = newObjectSpaceEnabled;
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setEnvironment(Map newEnvironment) {
        this.environment = newEnvironment;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        if (this.loader != loader) {
            this.classCache = new ClassCache(loader, this.classCache.getMax());
        }
        this.loader = loader;
    }

    public String[] getArgv() {
        return this.argv;
    }

    public void setArgv(String[] argv) {
        this.argv = argv;
    }

    public String getJRubyHome() {
        if (this.jrubyHome == null) {
            if (Ruby.isSecurityRestricted()) {
                return "SECURITY RESTRICTED";
            }
            this.jrubyHome = this.verifyHome(SafePropertyAccessor.getProperty("jruby.home", SafePropertyAccessor.getProperty("user.home") + "/.jruby"));
            try {
                this.jrubyHome = new NormalizedFile(this.jrubyHome).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jrubyHome = new NormalizedFile(this.jrubyHome).getAbsolutePath();
        }
        return this.jrubyHome;
    }

    public void setJRubyHome(String home) {
        this.jrubyHome = this.verifyHome(home);
    }

    private String verifyHome(String home) {
        if (home.equals(".")) {
            home = System.getProperty("user.dir");
        }
        if (!home.startsWith("file:")) {
            NormalizedFile f = new NormalizedFile(home);
            if (!f.isAbsolute()) {
                home = f.getAbsolutePath();
            }
            f.mkdirs();
        }
        return home;
    }

    public byte[] inlineScript() {
        try {
            return this.inlineScript.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return this.inlineScript.toString().getBytes();
        }
    }

    public List<String> requiredLibraries() {
        return this.requiredLibraries;
    }

    public List<String> loadPaths() {
        return this.loadPaths;
    }

    public boolean shouldRunInterpreter() {
        if (this.isShowVersion() && (this.hasInlineScript || this.scriptFileName != null)) {
            return true;
        }
        return this.isShouldRunInterpreter();
    }

    public boolean shouldPrintUsage() {
        return this.shouldPrintUsage;
    }

    public boolean shouldPrintProperties() {
        return this.shouldPrintProperties;
    }

    private boolean isSourceFromStdin() {
        return this.getScriptFileName() == null;
    }

    public boolean isInlineScript() {
        return this.hasInlineScript;
    }

    public InputStream getScriptSource() {
        try {
            if (this.hasInlineScript) {
                return new ByteArrayInputStream(this.inlineScript());
            }
            if (this.isSourceFromStdin()) {
                if (this.isShowVersion()) {
                    return null;
                }
                return this.getInput();
            }
            JRubyFile file = JRubyFile.create(this.getCurrentDirectory(), this.getScriptFileName());
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new MainExitException(1, "Error opening script file: " + e.getMessage());
        }
    }

    public String displayedFileName() {
        if (this.hasInlineScript) {
            if (this.scriptFileName != null) {
                return this.scriptFileName;
            }
            return "-e";
        }
        if (this.isSourceFromStdin()) {
            return "-";
        }
        return this.getScriptFileName();
    }

    private void setScriptFileName(String scriptFileName) {
        this.scriptFileName = scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public boolean isBenchmarking() {
        return this.benchmarking;
    }

    public boolean isAssumeLoop() {
        return this.assumeLoop;
    }

    public boolean isAssumePrinting() {
        return this.assumePrinting;
    }

    public boolean isProcessLineEnds() {
        return this.processLineEnds;
    }

    public boolean isSplit() {
        return this.split;
    }

    public boolean isVerbose() {
        return this.verbose == Boolean.TRUE;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public boolean isShowCopyright() {
        return this.showCopyright;
    }

    protected void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    protected void setShowCopyright(boolean showCopyright) {
        this.showCopyright = showCopyright;
    }

    public boolean isShouldRunInterpreter() {
        return this.shouldRunInterpreter;
    }

    public boolean isShouldCheckSyntax() {
        return this.shouldCheckSyntax;
    }

    public boolean isYARVEnabled() {
        return this.yarv;
    }

    public String getInputFieldSeparator() {
        return this.inputFieldSeparator;
    }

    public boolean isRubiniusEnabled() {
        return this.rubinius;
    }

    public boolean isYARVCompileEnabled() {
        return this.yarvCompile;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    public void setClassCache(ClassCache classCache) {
        this.classCache = classCache;
    }

    public Map getOptionGlobals() {
        return this.optionGlobals;
    }

    static /* synthetic */ String[] access$502(RubyInstanceConfig x0, String[] x1) {
        x0.argv = x1;
        return x1;
    }

    static {
        try {
            if (System.getProperty("jruby.native.enabled") != null) {
                nativeEnabled = Boolean.getBoolean("jruby.native.enabled");
            }
        }
        catch (SecurityException se) {
            nativeEnabled = false;
        }
    }

    private class ArgumentProcessor {
        private String[] arguments;
        private int argumentIndex = 0;

        public ArgumentProcessor(String[] arguments) {
            this.arguments = arguments;
        }

        public void processArguments() {
            while (this.argumentIndex < this.arguments.length && this.isInterpreterArgument(this.arguments[this.argumentIndex])) {
                this.processArgument();
                ++this.argumentIndex;
            }
            if (!RubyInstanceConfig.this.hasInlineScript && RubyInstanceConfig.this.scriptFileName == null && this.argumentIndex < this.arguments.length) {
                RubyInstanceConfig.this.setScriptFileName(this.arguments[this.argumentIndex]);
                ++this.argumentIndex;
            }
            this.processArgv();
        }

        private void processArgv() {
            ArrayList<String> arglist = new ArrayList<String>();
            while (this.argumentIndex < this.arguments.length) {
                String arg = this.arguments[this.argumentIndex];
                if (RubyInstanceConfig.this.argvGlobalsOn && arg.startsWith("-")) {
                    if ((arg = arg.substring(1)).indexOf(61) > 0) {
                        String[] keyvalue = arg.split("=", 2);
                        RubyInstanceConfig.this.optionGlobals.put(keyvalue[0], keyvalue[1]);
                    } else {
                        RubyInstanceConfig.this.optionGlobals.put(arg, null);
                    }
                } else {
                    RubyInstanceConfig.this.argvGlobalsOn = false;
                    arglist.add(arg);
                }
                ++this.argumentIndex;
            }
            RubyInstanceConfig.access$502(RubyInstanceConfig.this, arglist.toArray(new String[arglist.size()]));
        }

        private boolean isInterpreterArgument(String argument) {
            return (argument.charAt(0) == '-' || argument.charAt(0) == '+') && !RubyInstanceConfig.this.endOfArguments;
        }

        private String getArgumentError(String additionalError) {
            return "jruby: invalid argument\n" + additionalError + "\n";
        }

        private void processArgument() {
            String argument = this.arguments[this.argumentIndex];
            RubyInstanceConfig.this.characterIndex = 1;
            block36: while (RubyInstanceConfig.this.characterIndex < argument.length()) {
                switch (argument.charAt(RubyInstanceConfig.this.characterIndex)) {
                    case '0': {
                        String temp = this.grabOptionalValue();
                        if (null == temp) {
                            RubyInstanceConfig.this.recordSeparator = "\u0000";
                            break block36;
                        }
                        if (temp.equals("0")) {
                            RubyInstanceConfig.this.recordSeparator = "\n\n";
                            break block36;
                        }
                        if (temp.equals("777")) {
                            RubyInstanceConfig.this.recordSeparator = "\uffff";
                            break block36;
                        }
                        try {
                            int val = Integer.parseInt(temp, 8);
                            RubyInstanceConfig.this.recordSeparator = "" + (char)val;
                            break block36;
                        }
                        catch (Exception e) {
                            MainExitException mee = new MainExitException(1, this.getArgumentError(" -0 must be followed by either 0, 777, or a valid octal value"));
                            mee.setUsageError(true);
                            throw mee;
                        }
                    }
                    case 'a': {
                        RubyInstanceConfig.this.split = true;
                        break;
                    }
                    case 'b': {
                        RubyInstanceConfig.this.benchmarking = true;
                        break;
                    }
                    case 'c': {
                        RubyInstanceConfig.this.shouldCheckSyntax = true;
                        break;
                    }
                    case 'C': {
                        try {
                            String saved = this.grabValue(this.getArgumentError(" -C must be followed by a directory expression"));
                            File base = new File(RubyInstanceConfig.this.currentDirectory);
                            File newDir = new File(saved);
                            if (newDir.isAbsolute()) {
                                RubyInstanceConfig.this.currentDirectory = newDir.getCanonicalPath();
                            } else {
                                RubyInstanceConfig.this.currentDirectory = new File(base, newDir.getPath()).getCanonicalPath();
                            }
                            if (!new File(RubyInstanceConfig.this.currentDirectory).isDirectory()) {
                                MainExitException mee = new MainExitException(1, "jruby: Can't chdir to " + saved + " (fatal)");
                                mee.setUsageError(true);
                                throw mee;
                            }
                            break;
                        }
                        catch (IOException e) {
                            MainExitException mee = new MainExitException(1, this.getArgumentError(" -C must be followed by a valid directory"));
                            mee.setUsageError(true);
                            throw mee;
                        }
                    }
                    case 'd': {
                        RubyInstanceConfig.this.debug = true;
                        RubyInstanceConfig.this.verbose = Boolean.TRUE;
                        break;
                    }
                    case 'e': {
                        RubyInstanceConfig.this.inlineScript.append(this.grabValue(this.getArgumentError(" -e must be followed by an expression to evaluate")));
                        RubyInstanceConfig.this.inlineScript.append('\n');
                        RubyInstanceConfig.this.hasInlineScript = true;
                        break block36;
                    }
                    case 'F': {
                        RubyInstanceConfig.this.inputFieldSeparator = this.grabValue(this.getArgumentError(" -F must be followed by a pattern for input field separation"));
                        break;
                    }
                    case 'h': {
                        RubyInstanceConfig.this.shouldPrintUsage = true;
                        RubyInstanceConfig.this.shouldRunInterpreter = false;
                        break;
                    }
                    case 'I': {
                        String s = this.grabValue(this.getArgumentError("-I must be followed by a directory name to add to lib path"));
                        String[] ls = s.split(File.pathSeparator);
                        for (int i = 0; i < ls.length; ++i) {
                            RubyInstanceConfig.this.loadPaths.add(ls[i]);
                        }
                        break block36;
                    }
                    case 'K': {
                        String eArg = this.grabValue(this.getArgumentError("provide a value for -K"));
                        RubyInstanceConfig.this.kcode = KCode.create(null, eArg);
                        break;
                    }
                    case 'l': {
                        RubyInstanceConfig.this.processLineEnds = true;
                        break;
                    }
                    case 'n': {
                        RubyInstanceConfig.this.assumeLoop = true;
                        break;
                    }
                    case 'p': {
                        RubyInstanceConfig.this.assumePrinting = true;
                        RubyInstanceConfig.this.assumeLoop = true;
                        break;
                    }
                    case 'r': {
                        RubyInstanceConfig.this.requiredLibraries.add(this.grabValue(this.getArgumentError("-r must be followed by a package to require")));
                        break block36;
                    }
                    case 's': {
                        RubyInstanceConfig.this.argvGlobalsOn = true;
                        break;
                    }
                    case 'S': {
                        this.runBinScript();
                        break block36;
                    }
                    case 'T': {
                        String temp = this.grabOptionalValue();
                        int value = 1;
                        if (temp != null) {
                            try {
                                value = Integer.parseInt(temp, 8);
                            }
                            catch (Exception e) {
                                value = 1;
                            }
                        }
                        RubyInstanceConfig.this.safeLevel = value;
                        break block36;
                    }
                    case 'v': {
                        RubyInstanceConfig.this.verbose = Boolean.TRUE;
                        RubyInstanceConfig.this.setShowVersion(true);
                        break;
                    }
                    case 'w': {
                        RubyInstanceConfig.this.verbose = Boolean.TRUE;
                        break;
                    }
                    case 'W': {
                        String temp = this.grabOptionalValue();
                        int value = 2;
                        if (null != temp) {
                            if (temp.equals("2")) {
                                value = 2;
                            } else if (temp.equals("1")) {
                                value = 1;
                            } else if (temp.equals("0")) {
                                value = 0;
                            } else {
                                MainExitException mee = new MainExitException(1, this.getArgumentError(" -W must be followed by either 0, 1, 2 or nothing"));
                                mee.setUsageError(true);
                                throw mee;
                            }
                        }
                        switch (value) {
                            case 0: {
                                RubyInstanceConfig.this.verbose = null;
                                break;
                            }
                            case 1: {
                                RubyInstanceConfig.this.verbose = Boolean.FALSE;
                                break;
                            }
                            case 2: {
                                RubyInstanceConfig.this.verbose = Boolean.TRUE;
                            }
                        }
                        break block36;
                    }
                    case 'X': {
                        String extendedOption = this.grabValue("jruby: missing extended option, listing available options\n" + RubyInstanceConfig.this.getExtendedHelp());
                        if (extendedOption.equals("-O")) {
                            RubyInstanceConfig.this.objectSpaceEnabled = false;
                            break block36;
                        }
                        if (extendedOption.equals("+O")) {
                            RubyInstanceConfig.this.objectSpaceEnabled = true;
                            break block36;
                        }
                        if (extendedOption.equals("-C")) {
                            RubyInstanceConfig.this.compileMode = CompileMode.OFF;
                            break block36;
                        }
                        if (extendedOption.equals("+C")) {
                            RubyInstanceConfig.this.compileMode = CompileMode.FORCE;
                            break block36;
                        }
                        if (extendedOption.equals("y")) {
                            RubyInstanceConfig.this.yarv = true;
                            break block36;
                        }
                        if (extendedOption.equals("Y")) {
                            RubyInstanceConfig.this.yarvCompile = true;
                            break block36;
                        }
                        if (extendedOption.equals("R")) {
                            RubyInstanceConfig.this.rubinius = true;
                            break block36;
                        }
                        MainExitException mee = new MainExitException(1, "jruby: invalid extended option " + extendedOption + " (-X will list valid options)\n");
                        mee.setUsageError(true);
                        throw mee;
                    }
                    case '-': {
                        if (argument.equals("--command") || argument.equals("--bin")) {
                            RubyInstanceConfig.this.characterIndex = argument.length();
                            this.runBinScript();
                            break;
                        }
                        if (argument.equals("--compat")) {
                            RubyInstanceConfig.this.characterIndex = argument.length();
                            RubyInstanceConfig.this.compatVersion = CompatVersion.getVersionFromString(this.grabValue(this.getArgumentError("--compat must be RUBY1_8 or RUBY1_9")));
                            if (RubyInstanceConfig.this.compatVersion != null) break block36;
                            RubyInstanceConfig.this.compatVersion = CompatVersion.RUBY1_8;
                            break block36;
                        }
                        if (argument.equals("--copyright")) {
                            RubyInstanceConfig.this.setShowCopyright(true);
                            RubyInstanceConfig.this.shouldRunInterpreter = false;
                            break block36;
                        }
                        if (argument.equals("--debug")) {
                            RubyInstanceConfig.this.compileMode = CompileMode.OFF;
                            System.setProperty("jruby.reflection", "true");
                            break block36;
                        }
                        if (argument.equals("--jdb")) {
                            RubyInstanceConfig.this.debug = true;
                            RubyInstanceConfig.this.verbose = Boolean.TRUE;
                            break;
                        }
                        if (argument.equals("--help")) {
                            RubyInstanceConfig.this.shouldPrintUsage = true;
                            RubyInstanceConfig.this.shouldRunInterpreter = false;
                            break;
                        }
                        if (argument.equals("--properties")) {
                            RubyInstanceConfig.this.shouldPrintProperties = true;
                            RubyInstanceConfig.this.shouldRunInterpreter = false;
                            break;
                        }
                        if (argument.equals("--version")) {
                            RubyInstanceConfig.this.setShowVersion(true);
                            break block36;
                        }
                        if (argument.equals("--")) {
                            RubyInstanceConfig.this.endOfArguments = true;
                            break;
                        }
                    }
                    default: {
                        throw new MainExitException(1, "jruby: unknown option " + argument);
                    }
                }
                ++RubyInstanceConfig.this.characterIndex;
            }
        }

        private void runBinScript() {
            String scriptName = this.grabValue("jruby: provide a bin script to execute");
            if (scriptName.equals("irb")) {
                scriptName = "jirb";
            }
            try {
                String jrubyHome = JRubyFile.create(System.getProperty("user.dir"), JRubyFile.getFileProperty("jruby.home")).getCanonicalPath();
                RubyInstanceConfig.this.scriptFileName = JRubyFile.create(jrubyHome + JRubyFile.separator + "bin", scriptName).getCanonicalPath();
            }
            catch (IOException io2) {
                MainExitException mee = new MainExitException(1, "jruby: Can't determine script filename");
                mee.setUsageError(true);
                throw mee;
            }
            if (scriptName.equals("gem") || !new File(RubyInstanceConfig.this.scriptFileName).exists()) {
                RubyInstanceConfig.this.requiredLibraries.add("jruby/commands");
                RubyInstanceConfig.this.inlineScript.append("JRuby::Commands." + scriptName);
                RubyInstanceConfig.this.inlineScript.append("\n");
                RubyInstanceConfig.this.hasInlineScript = true;
            }
            RubyInstanceConfig.this.endOfArguments = true;
        }

        private String grabValue(String errorMessage) {
            ++RubyInstanceConfig.this.characterIndex;
            if (RubyInstanceConfig.this.characterIndex < this.arguments[this.argumentIndex].length()) {
                return this.arguments[this.argumentIndex].substring(RubyInstanceConfig.this.characterIndex);
            }
            ++this.argumentIndex;
            if (this.argumentIndex < this.arguments.length) {
                return this.arguments[this.argumentIndex];
            }
            MainExitException mee = new MainExitException(1, errorMessage);
            mee.setUsageError(true);
            throw mee;
        }

        private String grabOptionalValue() {
            ++RubyInstanceConfig.this.characterIndex;
            if (RubyInstanceConfig.this.characterIndex < this.arguments[this.argumentIndex].length()) {
                return this.arguments[this.argumentIndex].substring(RubyInstanceConfig.this.characterIndex);
            }
            return null;
        }
    }

    public static interface LoadServiceCreator {
        public static final LoadServiceCreator DEFAULT = new LoadServiceCreator(){

            public LoadService create(Ruby runtime) {
                return new LoadService(runtime);
            }
        };

        public LoadService create(Ruby var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompileMode {
        JIT,
        FORCE,
        OFF;


        public boolean shouldPrecompileCLI() {
            switch (this) {
                case JIT: 
                case FORCE: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldJIT() {
            switch (this) {
                case JIT: 
                case FORCE: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldPrecompileAll() {
            return this == FORCE;
        }
    }
}

