/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.ruby;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlowImpl;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.LogView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.jruby.RubyException;
import org.jruby.exceptions.RaiseException;

public class RubyTerminal {
    private JTextArea inputView;
    private LogView outputView;
    private JPanel panel;
    private ScriptEngine ruby;
    JSplitPane split;
    private Writer outputWriter = new OutputWriter();

    public RubyTerminal() {
        this.panel = new JPanel(new BorderLayout());
        this.inputView = new JTextArea();
        this.outputView = new LogView();
        this.outputWriter = new OutputWriter();
        this.split = new JSplitPane(0, true);
        this.split.setTopComponent(new JScrollPane(this.inputView, 20, 30));
        this.split.setBottomComponent(new JScrollPane((Component)this.outputView, 20, 30));
        this.split.setDividerSize(2);
        JPanel buttons = new JPanel(new FlowLayout(2));
        JButton execButton = new JButton();
        buttons.add(execButton);
        this.panel.add((Component)this.split, "Center");
        this.panel.add((Component)buttons, "South");
        execButton.setAction(new AbstractAction("\u5b9f\u884c"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String script = RubyTerminal.this.inputView.getText();
                while (script.endsWith("\n")) {
                    script = script.substring(0, script.length() - 1);
                }
                RubyTerminal.this.print("> " + script.replaceAll("\n", "\n> ") + "\n");
                final String fscript = script;
                new TaskFlowImpl(new Object()).execute(new WorkerTask(ViewNaver.instance.appTools){

                    public void exec() {
                        RubyTerminal.this.execScript(fscript);
                        RubyTerminal.this.inputView.selectAll();
                        RubyTerminal.this.inputView.requestFocus();
                        RubyTerminal.this.println("done.");
                    }
                });
            }
        });
        new TaskFlowImpl(new Object()).execute(new WorkerTask(ViewNaver.instance.appTools){

            public void exec() {
                try {
                    String line;
                    ViewNaver.println((String)"Ruby\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u306e\u521d\u671f\u5316\u4e2d...");
                    ScriptEngineManager engineManager = new ScriptEngineManager();
                    RubyTerminal.this.ruby = engineManager.getEngineByName("jruby");
                    if (RubyTerminal.this.ruby == null) {
                        throw new Exception();
                    }
                    RubyTerminal.this.ruby.getContext().setWriter(RubyTerminal.this.outputWriter);
                    RubyTerminal.this.ruby.getContext().setErrorWriter(RubyTerminal.this.outputWriter);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(RubyTerminal.this.getClass().getResourceAsStream("initscript.rb")));
                    StringBuffer initScript = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        initScript.append(String.valueOf(line) + "\n");
                    }
                    reader.close();
                    if (!RubyTerminal.this.execScript(initScript.toString())) {
                        throw new Exception();
                    }
                    ViewNaver.println((String)"Ruby\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u306e\u521d\u671f\u5316\u5b8c\u4e86...");
                }
                catch (Exception e) {
                    ViewNaver.err((Exception)e);
                    ViewNaver.println((String)"Ruby\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
            }
        });
    }

    public void showNewFrame() {
        JFrame frame = new JFrame("Ruby Terminal");
        frame.setDefaultCloseOperation(2);
        frame.setContentPane(this.panel);
        frame.setBounds(100, 100, 400, 400);
        this.split.setResizeWeight(0.5);
        this.split.setDividerLocation(0.5);
        frame.setVisible(true);
    }

    private void print(final String s) {
        new TaskFlowImpl(new Object()).execute(new GUITask(ViewNaver.instance.appTools){

            public void exec() {
                RubyTerminal.this.outputView.print(s);
            }
        });
    }

    private void println(String s) {
        this.print(String.valueOf(s) + '\n');
    }

    private boolean execScript(String script) {
        try {
            this.ruby.eval(script);
            return true;
        }
        catch (ScriptException e) {
            if (e.getCause() instanceof RaiseException) {
                RubyException re = ((RaiseException)e.getCause()).getException();
                this.println("error: " + re.message.asJavaString());
            }
            return false;
        }
    }

    private class OutputWriter
    extends Writer {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            RubyTerminal.this.print(new String(cbuf, off, len));
        }
    }
}

