/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.nvrlib.net;

import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.net.AnonymousSession;
import com.aibonware.nvrlib.net.HttpCancellerProvider;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.net.ProxyInfo;
import com.aibonware.nvrlib.task.TaskCanceller;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class LoginSession
extends AnonymousSession {
    private boolean nowLogin = false;

    public LoginSession(String userName, ProxyInfo proxy, HttpCancellerProvider canellerProvider) {
        super(userName, proxy, canellerProvider);
    }

    @Override
    public void login(String loginPassword) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                PostMethod method = new PostMethod("http://id.enjoykorea.jp/global/join_login_modify_formaction.php");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                method.addParameter("action_mode", "login");
                method.addParameter("url", "about:blank");
                method.addParameter("memberid", this.userName);
                method.addParameter("password", loginPassword);
                method.addParameter("id_chk", "");
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                if (httpStatus != 302 && httpStatus != 200) {
                    throw new NetException("login failed (status code=" + httpStatus + ")");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                this.checkLoginResult(httpStatus, text);
                method.releaseConnection();
                this.nowLogin = true;
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    private void checkLoginResult(int httpStatus, String text) throws NetException {
        this.checkLoginResult(httpStatus, text, null);
    }

    private void checkLoginResult(int httpStatus, String text, String succeededSign) throws NetException {
        if (httpStatus == 302 && text.indexOf("<body><h1>Object Moved</h1>This object may be found <a HREF=\"\">here</a>.</body>") >= 0) {
            return;
        }
        if (httpStatus == 200 && text.indexOf("alert") < 0) {
            return;
        }
        String alertString = LoginSession.getAlertString(text);
        if (succeededSign == null || !alertString.equals(succeededSign)) {
            throw new NetException(alertString);
        }
    }

    @Override
    public void logout() throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                this.nowLogin = false;
                GetMethod method = new GetMethod("http://id.enjoykorea.jp/login/logout.html");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                this.client.executeMethod((HttpMethod)method);
                method.releaseConnection();
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public boolean nowLogin() {
        return this.nowLogin;
    }

    @Override
    public void postArticle(String rawBoardName, int nid, String htmlContent) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                if (nid == 0 || htmlContent == null) {
                    throw new NetException("\u4e0d\u6b63\u306a\u6295\u7a3f\u5185\u5bb9\u3067\u3059");
                }
                PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/ment_action.php");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                method.addParameter("board_id", rawBoardName);
                method.addParameter("nid", String.valueOf(nid));
                method.addParameter("rtn_url", "about:blank");
                method.addParameter("work", "write");
                method.addParameter("ment_id", "");
                method.addParameter("ment_reply", "");
                method.addParameter("sno", "");
                method.addParameter("ment_passwd", "");
                method.addParameter("ment_writer", this.userName);
                method.addParameter("ment_passwd_temp", "");
                method.addParameter("ment_ment", htmlContent);
                method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public void replyArticle(String rawBoardName, int nid, String htmlContent, int sno) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                if (nid == 0 || htmlContent == null) {
                    throw new NetException("\u4e0d\u6b63\u306a\u6295\u7a3f\u5185\u5bb9\u3067\u3059");
                }
                PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/ment_action.php");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                method.addParameter("board_id", rawBoardName);
                method.addParameter("nid", String.valueOf(nid));
                method.addParameter("rtn_url", "about:blank");
                method.addParameter("work", "write");
                method.addParameter("ment_id", "");
                method.addParameter("ment_reply", htmlContent);
                method.addParameter("sno", String.valueOf(sno));
                method.addParameter("ment_passwd", "");
                method.addParameter("ment_writer", this.userName);
                method.addParameter("ment_passwd_temp", "");
                method.addParameter("ment_ment", "");
                method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public void deleteArticle(String rawBoardName, int nid, int articleId) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/ment_action.php?board_id=" + rawBoardName + "&ment_id=");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                method.addParameter("board_id", rawBoardName);
                method.addParameter("nid", String.valueOf(nid));
                method.addParameter("rtn_url", "about:blank");
                method.addParameter("work", "delete");
                method.addParameter("ment_id", String.valueOf(articleId));
                method.addParameter("ment_reply", "");
                method.addParameter("sno", "");
                method.addParameter("ment_passwd", "");
                method.addParameter("ment_writer", this.userName);
                method.addParameter("ment_passwd_temp", "");
                method.addParameter("ment_ment", "");
                method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int postThread(String boardName, String title, String content) throws NetException {
        TaskCanceller canceller = null;
        try {
            PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/write_action.php?chkclick=on");
            canceller = this.canellerProvider.createCanceller((HttpMethod)method);
            method.setFollowRedirects(false);
            Part[] parts = new Part[]{new StringPart("status", "", "utf8"), new StringPart("board_id", boardName, "utf8"), new StringPart("board_id_app", boardName, "utf8"), new StringPart("work", "write", "utf8"), new StringPart("page", "1", "utf8"), new StringPart("nid", "", "utf8"), new StringPart("st", "", "utf8"), new StringPart("sw", "", "utf8"), new StringPart("have_file", "", "utf8"), new StringPart("sno", "", "utf8"), new StringPart("g1", "", "utf8"), new StringPart("g2", "", "utf8"), new StringPart("list_url", "/tbbs/list.php?board_id=" + boardName + "&work=write", "utf8"), new StringPart("use_editor", "Y", "utf8"), new StringPart("use_poll", "", "utf8"), new StringPart("attachpolls", "", "utf8"), new StringPart("fav_list", "", "utf8"), new StringPart("html_mode", "M", "utf8"), new StringPart("board_st", boardName, "utf8"), new StringPart("writer_name", this.userName, "utf8"), new StringPart("national", "J", "utf8"), new StringPart("title", title, "utf8"), new StringPart("urlimage_layer", "http://", "utf8"), new StringPart("hyper_layer", "http://", "utf8"), new StringPart("nvSourceEdit", content, "utf8"), new StringPart("content", content, "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("total_attached_size", "0", "utf8"), new StringPart("pre_total_attached_size", "0", "utf8"), new StringPart("user_defined_size", "512000", "utf8"), new StringPart("user_defined_num", "10", "utf8"), new StringPart("total_attached_size_kb", "0", "utf8")};
            method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
            int httpStatus = this.client.executeMethod((HttpMethod)method);
            BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
            String text = "";
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    int nid;
                    method.releaseConnection();
                    this.checkLoginResult(httpStatus, text);
                    int n = nid = this.getResultNid(boardName, text, "write_confirm.php?board_id=" + boardName + "&nid=");
                    this.canellerProvider.disposeCanceller(canceller);
                    return n;
                }
                text = String.valueOf(text) + line;
            }
        }
        catch (HttpException e) {
            try {
                throw new NetException(e);
                catch (IOException e2) {
                    throw new NetException(e2);
                }
            }
            catch (Throwable throwable) {
                this.canellerProvider.disposeCanceller(canceller);
                throw throwable;
            }
        }
    }

    private int getResultNid(String boardName, String text, String prefix) {
        int start = text.indexOf(prefix);
        if (start == -1) {
            return -1;
        }
        int end = text.indexOf("&", start += prefix.length());
        if (end == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(text.substring(start, end));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public void replyThread(String boardName, String title, String content, int nid, int sno) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/write_action.php");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                Part[] parts = new Part[]{new StringPart("status", "", "utf8"), new StringPart("board_id", boardName, "utf8"), new StringPart("board_id_app", boardName, "utf8"), new StringPart("work", "reply", "utf8"), new StringPart("page", "1", "utf8"), new StringPart("nid", String.valueOf(nid), "utf8"), new StringPart("st", "", "utf8"), new StringPart("sw", "", "utf8"), new StringPart("have_file", "N", "utf8"), new StringPart("sno", String.valueOf(sno), "utf8"), new StringPart("g1", "", "utf8"), new StringPart("g2", "", "utf8"), new StringPart("list_url", "/tbbs/list.php?board_id=" + boardName + "&work=reply&nid=" + nid, "utf8"), new StringPart("use_editor", "Y", "utf8"), new StringPart("use_poll", "", "utf8"), new StringPart("attachpolls", "", "utf8"), new StringPart("fav_list", "", "utf8"), new StringPart("html_mode", "M", "utf8"), new StringPart("board_st", boardName, "utf8"), new StringPart("writer_name", this.userName, "utf8"), new StringPart("national", "J", "utf8"), new StringPart("title", title, "utf8"), new StringPart("urlimage_layer", "http://", "utf8"), new StringPart("hyper_layer", "http://", "utf8"), new StringPart("nvSourceEdit", content, "utf8"), new StringPart("content", content, "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("total_attached_size", "0", "utf8"), new StringPart("pre_total_attached_size", "0", "utf8"), new StringPart("user_defined_size", "512000", "utf8"), new StringPart("user_defined_num", "10", "utf8"), new StringPart("total_attached_size_kb", "0", "utf8")};
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public void modifyThread(String boardName, String title, String content, int nid) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/tbbs/write_action.php");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                Part[] parts = new Part[]{new StringPart("status", "", "utf8"), new StringPart("board_id", boardName, "utf8"), new StringPart("board_id_app", boardName, "utf8"), new StringPart("work", "modify", "utf8"), new StringPart("page", "1", "utf8"), new StringPart("nid", String.valueOf(nid), "utf8"), new StringPart("st", "", "utf8"), new StringPart("sw", "", "utf8"), new StringPart("have_file", "", "utf8"), new StringPart("sno", "", "utf8"), new StringPart("g1", "", "utf8"), new StringPart("g2", "", "utf8"), new StringPart("list_url", "/tbbs/list.php?board_id=" + boardName + "&work=modify&nid=" + nid, "utf8"), new StringPart("use_editor", "Y", "utf8"), new StringPart("use_poll", "", "utf8"), new StringPart("attachpolls", "", "utf8"), new StringPart("fav_list", "", "utf8"), new StringPart("html_mode", "M", "utf8"), new StringPart("board_st", boardName, "utf8"), new StringPart("writer_name", this.userName, "utf8"), new StringPart("national", "J", "utf8"), new StringPart("title", title, "utf8"), new StringPart("urlimage_layer", "http://", "utf8"), new StringPart("hyper_layer", "http://", "utf8"), new StringPart("nvSourceEdit", content, "utf8"), new StringPart("content", content, "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("file_info[]", "", "utf8"), new StringPart("total_attached_size", "0", "utf8"), new StringPart("pre_total_attached_size", "0", "utf8"), new StringPart("user_defined_size", "512000", "utf8"), new StringPart("user_defined_num", "10", "utf8"), new StringPart("total_attached_size_kb", "0", "utf8")};
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public void deleteThread(String boardName, int nid) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                GetMethod method = new GetMethod("http://bbs.enjoykorea.jp/tbbs/write_action.php?board_id=" + boardName + "&work=delete&nid=" + nid);
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public void sendMessage(String receiver, Country country, String messageText, boolean saveServer) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                receiver = receiver.trim();
                if (receiver.length() == 0) {
                    throw new NetException("\u9001\u4fe1\u5148\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
                if (country.equals((Object)Country.UNKNOWN)) {
                    throw new NetException("\u4e0d\u660e\u306a\u56fd\u7a2e\u5225\u3067\u3059\u3002");
                }
                if (messageText.length() == 0) {
                    throw new NetException("\u6295\u7a3f\u5185\u5bb9\u304c\u7a7a\u3067\u3059\u3002");
                }
                if (messageText.length() >= 400) {
                    throw new NetException("\u6295\u7a3f\u5185\u5bb9\u304c\u5236\u9650\u5024400\u6587\u5b57\u3092\u8d85\u3048\u3066\u3044\u307e\u3059");
                }
                PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/memo/memo_write.php");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                method.addParameter("mode", "write");
                method.addParameter("receive_id", receiver);
                if (country.equals((Object)Country.JAPAN)) {
                    method.addParameter("id_national", "J");
                } else {
                    method.addParameter("id_national", "K");
                }
                if (saveServer) {
                    method.addParameter("send_chk", "Y");
                } else {
                    method.addParameter("send_chk", "");
                }
                method.addParameter("content", messageText);
                method.addParameter("txtLen", String.valueOf(String.valueOf(messageText.length()) + "\u5b57 /400\u5b57"));
                method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text, "\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002");
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    private void saveMessage(String url, int[] messageIdList) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                if (messageIdList.length == 0) {
                    throw new NetException("\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
                PostMethod method = new PostMethod(url);
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                method.addParameter("check_list", "false");
                method.addParameter("page", "1");
                method.addParameter("mode", "save");
                int i = 0;
                while (i < messageIdList.length) {
                    method.addParameter("nidA[]", String.valueOf(messageIdList[i]));
                    ++i;
                }
                method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public void saveReceivedMessage(int[] messageIdList) throws NetException {
        this.saveMessage("http://bbs.enjoykorea.jp/memo/memo_list.php", messageIdList);
    }

    @Override
    public void saveSentMessage(int[] messageIdList) throws NetException {
        this.saveMessage("http://bbs.enjoykorea.jp/memo/save_list.php", messageIdList);
    }

    private void deleteMessage(String url, int[] messageIdList) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                if (messageIdList.length == 0) {
                    throw new NetException("\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
                PostMethod method = new PostMethod(url);
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                method.addParameter("check_list", "false");
                method.addParameter("page", "1");
                method.addParameter("mode", "delete");
                int i = 0;
                while (i < messageIdList.length) {
                    method.addParameter("nidA[]", String.valueOf(messageIdList[i]));
                    ++i;
                }
                method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public void deleteReceivedMessage(int[] messageIdList) throws NetException {
        this.deleteMessage("http://bbs.enjoykorea.jp/memo/memo_list.php", messageIdList);
    }

    @Override
    public void deleteSentMessage(int[] messageIdList) throws NetException {
        this.deleteMessage("http://bbs.enjoykorea.jp/memo/save_list.php", messageIdList);
    }

    @Override
    public void denyMessage(String sender, Country country) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                GetMethod method = new GetMethod("http://bbs.enjoykorea.jp/memo/m_reject_ok.php?id=" + sender + "&national=" + country.toChar());
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text);
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }

    @Override
    public void cancelDenyList(int[] nidA) throws NetException {
        TaskCanceller canceller = null;
        try {
            try {
                String line;
                if (nidA.length == 0) {
                    throw new NetException("ID\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
                PostMethod method = new PostMethod("http://bbs.enjoykorea.jp/memo/m_reject_list.php");
                canceller = this.canellerProvider.createCanceller((HttpMethod)method);
                method.setFollowRedirects(false);
                method.addParameter("mode", "delete");
                int i = 0;
                while (i < nidA.length) {
                    method.addParameter("nidA[]", String.valueOf(nidA[i]));
                    ++i;
                }
                method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                int httpStatus = this.client.executeMethod((HttpMethod)method);
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF8"));
                String text = "";
                while ((line = reader.readLine()) != null) {
                    text = String.valueOf(text) + line;
                }
                method.releaseConnection();
                this.checkLoginResult(httpStatus, text, "\u53d7\u4fe1\u62d2\u5426\u3092\u89e3\u9664\u3057\u307e\u3057\u305f");
            }
            catch (HttpException e) {
                throw new NetException(e);
            }
            catch (IOException e) {
                throw new NetException(e);
            }
        }
        catch (Throwable throwable) {
            this.canellerProvider.disposeCanceller(canceller);
            throw throwable;
        }
        this.canellerProvider.disposeCanceller(canceller);
    }
}

