/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.window;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.component.StatusBar;
import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigUser;
import com.aibonware.viewnaver.config.ThreadWindowConfig;
import com.aibonware.viewnaver.content.TabContainer;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.thread.ThreadContent;
import com.aibonware.viewnaver.content.thread.ThreadViewFactory;
import com.aibonware.viewnaver.window.ChildWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ThreadWindow
extends JDialog
implements ConfigUser,
ChildWindow {
    public TabContainerView threadListView;
    public TabContainer container;

    public ThreadWindow(JFrame parent) {
        super(parent);
        this.setTitle("thread");
        this.setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ThreadWindow.this.setVisible(false);
            }
        });
        this.container = new TabContainer(ViewNaver.instance.defaultCategoryComparator);
        this.threadListView = new TabContainerView();
        this.threadListView.setClientContainer(this.container);
        this.threadListView.addFactory(ThreadContent.class, new ThreadViewFactory());
        this.add((Component)this.threadListView, "Center");
        this.add((Component)new StatusBar(this), "South");
        ViewNaver.instance.config.addConfigUser(this);
        this.addComponentListener(new ComponentAdapter(){

            private void updteBounds() {
                Rectangle r = ThreadWindow.this.getBounds();
                ThreadWindowConfig threadWindowConfig = ViewNaver.instance.config.getThreadWindowConfig();
                threadWindowConfig.left = r.x;
                threadWindowConfig.top = r.y;
                threadWindowConfig.width = r.width;
                threadWindowConfig.height = r.height;
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.updteBounds();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.updteBounds();
            }
        });
        ViewNaver.instance.childWindowActivator.addChildWindow(this);
    }

    @Override
    public void configChanged(Config config) {
        ThreadWindowConfig threadWindowConfig = ViewNaver.instance.config.getThreadWindowConfig();
        Rectangle r = new Rectangle(threadWindowConfig.left, threadWindowConfig.top, threadWindowConfig.width, threadWindowConfig.height);
        if (!r.equals(this.getBounds())) {
            this.setBounds(r);
        }
    }
}

