/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.w3c.dom.Element;

public class ThreadWindowConfig
extends ConfigItem {
    public int maxThreadTabTitleLen = 10;
    public int left;
    public int top;
    public int width;
    public int height;
    public boolean sortArticle = true;

    public ThreadWindowConfig() {
        super("ThreadWindow");
        this.loadConfig(null);
    }

    @Override
    public void loadConfig(Element elem) {
        this.maxThreadTabTitleLen = Config.getIntConfig(elem, "MaxThreadTabTitleLen", 10);
        this.left = Config.getIntConfig(elem, "Left", 150);
        this.top = Config.getIntConfig(elem, "Top", 150);
        this.width = Config.getIntConfig(elem, "Width", 500);
        this.height = Config.getIntConfig(elem, "Height", 500);
        this.sortArticle = Config.getBooleanConfig(elem, "SortArticle", true);
    }

    @Override
    public void saveConfig(Element elem) {
        Config.setIntConfig(elem, "MaxThreadTabTitleLen", this.maxThreadTabTitleLen);
        Config.setIntConfig(elem, "Left", this.left);
        Config.setIntConfig(elem, "Top", this.top);
        Config.setIntConfig(elem, "Width", this.width);
        Config.setIntConfig(elem, "Height", this.height);
        Config.setBooleanConfig(elem, "SortArticle", this.sortArticle);
    }

    @Override
    public String getDispPath() {
        return "\u57fa\u672c.\u30b9\u30ec\u30c3\u30c9\u8868\u793a\u753b\u9762";
    }

    @Override
    public ConfigItemView getView() {
        return new ThreadWindowConfigView();
    }

    private static class ThreadWindowConfigView
    extends ConfigItemView {
        private JTextField textField = new JTextField();
        private ThreadWindowConfig threadWindowConfig;
        private JCheckBox sortArticleCheck = new JCheckBox("\u30ec\u30b9\u3092\u30bd\u30fc\u30c8\u3059\u308b");

        ThreadWindowConfigView() {
            this.addLine("\u30bf\u30d6\u6700\u5927\u6587\u5b57\u6570\uff1a\t", ThreadWindowConfigView.glue(this.textField));
            this.addLine(ThreadWindowConfigView.glue(this.sortArticleCheck));
        }

        @Override
        public void setConfig(ConfigItem config) {
            this.threadWindowConfig = (ThreadWindowConfig)config;
            this.textField.setText(String.valueOf(this.threadWindowConfig.maxThreadTabTitleLen));
            this.sortArticleCheck.setSelected(this.threadWindowConfig.sortArticle);
        }

        @Override
        public void applyConfig() throws ConfigException {
            try {
                this.threadWindowConfig.maxThreadTabTitleLen = Integer.parseInt(this.textField.getText());
            }
            catch (NumberFormatException e) {
                throw new ConfigException("\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            this.threadWindowConfig.sortArticle = this.sortArticleCheck.isSelected();
        }
    }
}

