/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.component.FastScrollPane;
import com.aibonware.viewnaver.component.PagePanel;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class ConfigView
extends JPanel {
    private HashMap<String, Vector<ConfigItemView>> viewMap;
    private JTree tree;
    DefaultMutableTreeNode root;
    private CardLayout cardLayout;
    private JPanel panel;
    private JPanel emptyView = new JPanel(new BorderLayout()){
        {
            this.setOpaque(true);
        }
    };

    public ConfigView(ConfigItem config) {
        this.setLayout(new BorderLayout());
        this.cardLayout = new CardLayout();
        this.panel = new JPanel(this.cardLayout);
        this.viewMap = new HashMap();
        this.root = new DefaultMutableTreeNode("\u8a2d\u5b9a");
        this.root.setUserObject(new DispPath("\u8a2d\u5b9a"));
        this.setConfigTree(config);
        Set<String> paths = this.viewMap.keySet();
        for (String path : paths) {
            DefaultMutableTreeNode node = this.makeSure(path);
            node.setUserObject(new DispPath(path));
        }
        for (String path : paths) {
            PagePanel page = new PagePanel();
            for (ConfigItemView view : this.viewMap.get(path)) {
                page.addLine(PagePanel.glue(view));
            }
            this.panel.add((Component)new FastScrollPane(page), path);
        }
        this.panel.add((Component)this.emptyView, "EmptyView");
        this.cardLayout.show(this.panel, "EmptyView");
        this.tree = new JTree(this.root);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        this.tree.setCellRenderer(renderer);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treePath = ConfigView.this.tree.getSelectionPath();
                if (treePath == null) {
                    return;
                }
                String configPath = ((DispPath)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()).path;
                if (ConfigView.this.viewMap.get(configPath) != null) {
                    ConfigView.this.cardLayout.show(ConfigView.this.panel, configPath);
                } else {
                    ConfigView.this.cardLayout.show(ConfigView.this.panel, "EmptyView");
                }
            }
        });
        JSplitPane split = new JSplitPane(1);
        split.setLeftComponent(this.tree);
        split.setRightComponent(this.panel);
        split.setDividerSize(4);
        split.setResizeWeight(0.0);
        split.setDividerLocation(100);
        this.add((Component)split, "Center");
    }

    private DefaultMutableTreeNode makeSure(String path) {
        StringTokenizer tokens = new StringTokenizer(path, ".");
        DefaultMutableTreeNode cur = this.root;
        String curPath = "";
        String delimitor = "";
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            curPath = String.valueOf(curPath) + delimitor + token;
            delimitor = ".";
            DefaultMutableTreeNode next = this.getChildNode(cur, token);
            if (next == null) {
                next = new DefaultMutableTreeNode(token);
                next.setUserObject(new DispPath(curPath));
                cur.add(next);
            }
            cur = next;
        }
        return cur;
    }

    private DefaultMutableTreeNode getChildNode(DefaultMutableTreeNode parent, String childName) {
        int i = 0;
        while (i < parent.getChildCount()) {
            if (parent.getChildAt(i).toString().equals(childName)) {
                return (DefaultMutableTreeNode)parent.getChildAt(i);
            }
            ++i;
        }
        return null;
    }

    public void setConfigTree(ConfigItem config) {
        ConfigItemView view = config.getView();
        if (view != null) {
            String path = config.getDispPath();
            view.setConfig(config);
            if (this.viewMap.get(path) == null) {
                this.viewMap.put(path, new Vector());
            }
            Vector<ConfigItemView> views = this.viewMap.get(path);
            views.addElement(view);
        }
        int i = 0;
        while (i < config.getChildCount()) {
            this.setConfigTree(config.getChild(i));
            ++i;
        }
    }

    public void applyConfig() throws ConfigException {
        for (Vector<ConfigItemView> views : this.viewMap.values()) {
            for (ConfigItemView view : views) {
                view.applyConfig();
            }
        }
    }

    private static class DispPath {
        public final String path;
        public final String name;

        public DispPath(String path) {
            this.path = path;
            int pos = path.lastIndexOf(46);
            this.name = pos == -1 ? path : path.substring(pos + 1);
        }

        public String toString() {
            return this.name;
        }
    }
}

