/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.browser.basic;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.SimpleBrowserImpl;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;

public class BasicBrowserImpl
extends SimpleBrowserImpl {
    public JEditorPane comp = new JEditorPane();
    public JScrollPane scr = new JScrollPane(this.comp);
    private StringBuffer writingBuf = null;

    public BasicBrowserImpl(boolean editable) {
        this.comp.setEditable(editable);
        this.comp.setContentType("text/html");
        this.comp.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (e.getDescription() == null) {
                    return;
                }
                String url = e.getDescription();
                BasicBrowserImpl.this.notifyBeforeNavigate(url);
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.scr;
    }

    private Element getBodyElement(HTMLDocument doc) {
        Element root = doc.getDefaultRootElement();
        int i = 0;
        while (i < root.getElementCount()) {
            Element child = root.getElement(i);
            if (child.getName().equalsIgnoreCase("body")) {
                return child;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setBodyHtml(String html) {
        try {
            HTMLDocument doc = (HTMLDocument)this.comp.getDocument();
            Element body = this.getBodyElement(doc);
            doc.setInnerHTML(body, html);
        }
        catch (Exception e) {
            ViewNaver.err(e);
        }
    }

    @Override
    public void insertBodyHtml(String tagid, String html) {
        try {
            HTMLDocument doc = (HTMLDocument)this.comp.getDocument();
            Element elem = doc.getElement(tagid);
            doc.insertAfterEnd(elem, html);
        }
        catch (Exception e) {
            ViewNaver.err(e);
        }
    }

    @Override
    public void replaceBodyHtml(String tagid, String html) {
        try {
            HTMLDocument doc = (HTMLDocument)this.comp.getDocument();
            Element elem = doc.getElement(tagid);
            doc.setInnerHTML(elem, "<div align=\"left\">" + html + "</div>");
        }
        catch (Exception e) {
            ViewNaver.err(e);
        }
    }

    public String getBodyHtml() {
        boolean oldEditable = this.comp.isEditable();
        try {
            String html;
            if (oldEditable) {
                this.comp.setEditable(false);
            }
            HTMLDocument doc = (HTMLDocument)this.comp.getDocument();
            Element body = this.getBodyElement(doc);
            int start = body.getStartOffset();
            int end = body.getEndOffset();
            String string = html = doc.getText(start, end - start);
            return string;
        }
        catch (Exception e) {
            ViewNaver.err(e);
            return "";
        }
        finally {
            this.comp.setEditable(oldEditable);
        }
    }

    @Override
    public void scrollTop(String tagid) {
        this.scr.getVerticalScrollBar().setValue(0);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void beginDocWriting() {
        this.writingBuf = new StringBuffer();
    }

    @Override
    public void writeDocHtml(String html) {
        this.writingBuf.append(html);
    }

    @Override
    public void endDocWriting() {
        String html = this.writingBuf.toString();
        this.comp.setText(html);
        this.writingBuf = null;
    }

    @Override
    public void clearDocHtml() {
        this.comp.setText("");
    }

    @Override
    public void closeDocHtml() {
    }
}

