/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.nvrlib.model;

import com.aibonware.nvrlib.model.BaseThread;
import com.aibonware.nvrlib.model.BoardType;
import java.util.Iterator;
import java.util.Vector;

public abstract class BaseBoard<TThread extends BaseThread>
implements Iterable<TThread> {
    public final String boardName;
    public final String dispName;
    public final BoardType boardType;
    public final int pageNo;
    public final int totalPages;
    private Vector<TThread> threads = new Vector();

    public BaseBoard(String boardName, String dispName, BoardType boardType, int pageNo, int totalPages) {
        this.boardName = boardName;
        this.dispName = dispName;
        this.boardType = boardType;
        this.pageNo = pageNo;
        this.totalPages = totalPages;
    }

    public void addThread(TThread thread) {
        this.threads.addElement(thread);
    }

    public TThread getThread(int index) {
        return (TThread)((BaseThread)this.threads.elementAt(index));
    }

    public void removeThread(int index) {
        this.threads.removeElementAt(index);
    }

    public int getThreadCount() {
        return this.threads.size();
    }

    public TThread getThreadByNid(int nid) {
        int i = 0;
        while (i < this.getThreadCount()) {
            TThread header = this.getThread(i);
            if (((BaseThread)header).nid == nid) {
                return header;
            }
            ++i;
        }
        throw new RuntimeException("invalid nid " + nid);
    }

    @Override
    public Iterator<TThread> iterator() {
        return this.threads.iterator();
    }

    public String toString() {
        return this.dispName;
    }
}

