/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.xml;

import com.aibonware.nvrlib.model.Country;
import com.aibonware.viewnaver.model.SessionType;
import com.aibonware.viewnaver.xml.XMLNotFoundException;
import com.aibonware.viewnaver.xml.XMLReaderException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BaseXMLReader {
    protected SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");

    public static final Element getAttrElem(Element elem, String name) throws XMLReaderException {
        Node child = elem.getFirstChild();
        while (child != null) {
            if (child instanceof Element && child.getNodeName().equals(name)) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        throw new XMLNotFoundException("\u30bf\u30b0" + name + "\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
    }

    public static final Vector<Element> getAttrElems(Element elem, String name) {
        Vector<Element> children = new Vector<Element>();
        Node child = elem.getFirstChild();
        while (child != null) {
            if (child instanceof Element && child.getNodeName().equals(name)) {
                children.addElement((Element)child);
            }
            child = child.getNextSibling();
        }
        return children;
    }

    protected String readStringElem(Element elem, String name) throws XMLReaderException {
        String s;
        try {
            s = BaseXMLReader.getAttrElem(elem, name).getTextContent();
        }
        catch (XMLReaderException e) {
            return null;
        }
        return s;
    }

    protected int readIntElem(Element elem, String name) throws XMLReaderException {
        String s = BaseXMLReader.getAttrElem(elem, name).getTextContent();
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new XMLReaderException("\u30bf\u30b0'" + name + "'\u306e\u5024'" + s + "'\u306f\u4e0d\u6b63\u306a\u6574\u6570\u8868\u73fe\u3067\u3059\u3002", e);
        }
    }

    protected int readIntElem(Element elem, String name, int defaultValue) throws XMLReaderException {
        try {
            String s = BaseXMLReader.getAttrElem(elem, name).getTextContent();
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new XMLReaderException("\u30bf\u30b0'" + name + "'\u306e\u5024'" + s + "'\u306f\u4e0d\u6b63\u306a\u6574\u6570\u8868\u73fe\u3067\u3059\u3002", e);
            }
        }
        catch (XMLNotFoundException e) {
            return defaultValue;
        }
        catch (XMLReaderException e) {
            throw e;
        }
    }

    protected boolean readBoolElem(Element elem, String name) throws XMLReaderException {
        String s = BaseXMLReader.getAttrElem(elem, name).getTextContent();
        return Boolean.parseBoolean(s);
    }

    protected Date readDateElem(Element elem, String name) throws XMLReaderException {
        String s;
        try {
            s = BaseXMLReader.getAttrElem(elem, name).getTextContent();
        }
        catch (XMLReaderException e) {
            return null;
        }
        try {
            return this.df.parse(s);
        }
        catch (ParseException e) {
            throw new XMLReaderException("\u30bf\u30b0'" + name + "'\u306e\u5024'" + s + "'\u306f\u4e0d\u6b63\u306a\u65e5\u4ed8\u8868\u73fe\u3067\u3059\u3002", e);
        }
    }

    protected Country readCountryElem(Element elem, String name) throws XMLReaderException {
        String s = BaseXMLReader.getAttrElem(elem, name).getTextContent();
        try {
            return Country.valueOf((String)s);
        }
        catch (IllegalArgumentException e) {
            throw new XMLReaderException("\u30bf\u30b0'" + name + "'\u306e\u5024'" + s + "'\u306f\u4e0d\u6b63\u306a\u56fd\u7a2e\u5225\u8868\u73fe\u3067\u3059\u3002", e);
        }
    }

    protected SessionType readSessionTypeElem(Element elem, String name) throws XMLReaderException {
        String s;
        try {
            s = BaseXMLReader.getAttrElem(elem, name).getTextContent();
        }
        catch (XMLNotFoundException e) {
            s = "UNKNOWN";
        }
        if ("0".equals(s)) {
            s = SessionType.ANONYMOUS.name();
        }
        if ("1".equals(s)) {
            s = SessionType.LOGIN.name();
        }
        try {
            return SessionType.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw new XMLReaderException("\u30bf\u30b0'" + name + "'\u306e\u5024'" + s + "'\u306f\u4e0d\u6b63\u306a\u56fd\u7a2e\u5225\u8868\u73fe\u3067\u3059\u3002", e);
        }
    }
}

