/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.browser.win32;

import com.aibonware.nvrlib.model.Poster;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.win32.URLAction;
import com.aibonware.viewnaver.browser.win32.URLActions;
import com.aibonware.viewnaver.browser.win32.URLPolicy;
import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComboBox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Win32BrowserConfig
extends ConfigItem {
    public URLActions actions = new URLActions();
    public Set<Poster> persons = new HashSet<Poster>();
    public String startTag = "<font color=\"blue\">";
    public String endTag = "</font>";

    public Win32BrowserConfig() {
        super("BrowserConfig");
        this.loadConfig(null);
    }

    @Override
    public void loadConfig(Element elem) {
        this.actions = new URLActions();
        if (elem == null) {
            return;
        }
        NodeList children = elem.getElementsByTagName("URLAction");
        if (children.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < children.getLength()) {
            int policy;
            int maxAction;
            Element actionElem = (Element)children.item(i);
            int minAction = Config.getIntConfig(actionElem, "MinAction", -1);
            URLAction action = this.actions.findAction(minAction, maxAction = Config.getIntConfig(actionElem, "MaxAction", -1), policy = Config.getIntConfig(actionElem, "Policy", -1));
            if (action == null) {
                ViewNaver.println("\u4e0d\u6b63\u306aURLAction\u6307\u5b9a(" + minAction + ", " + maxAction + ", " + policy + ")");
                break;
            }
            action.currentPolicy = policy;
            ++i;
        }
    }

    @Override
    public void saveConfig(Element elem) {
        NodeList children = elem.getElementsByTagName("URLAction");
        int i = 0;
        while (i < children.getLength()) {
            elem.removeChild(children.item(i));
            ++i;
        }
        Document doc = elem.getOwnerDocument();
        URLAction[] uRLActionArray = this.actions.children;
        int n = this.actions.children.length;
        int n2 = 0;
        while (n2 < n) {
            URLAction a = uRLActionArray[n2];
            Element actionElem = doc.createElement("URLAction");
            Config.setIntConfig(actionElem, "MinAction", a.minAction);
            Config.setIntConfig(actionElem, "MaxAction", a.maxAction);
            Config.setIntConfig(actionElem, "Policy", a.currentPolicy);
            elem.appendChild(actionElem);
            ++n2;
        }
    }

    @Override
    public String getDispPath() {
        return "\u30d6\u30e9\u30a6\u30b6";
    }

    @Override
    public ConfigItemView getView() {
        return new Win32BrowserConfigView();
    }

    private static class Win32BrowserConfigView
    extends ConfigItemView {
        JComboBox[] policiesList;
        Win32BrowserConfig browserConfig;

        public Win32BrowserConfigView() {
            URLActions defs = new URLActions();
            this.policiesList = new JComboBox[defs.children.length];
            int i = 0;
            while (i < defs.children.length) {
                JComboBox<URLPolicy> plist = new JComboBox<URLPolicy>(defs.children[i].policies);
                plist.setPreferredSize(new Dimension(100, 20));
                plist.setMaximumSize(new Dimension(100, 20));
                this.policiesList[i] = plist;
                int finalIndex = i++;
                this.addLine(String.valueOf(defs.children[finalIndex].name) + ": \t", plist);
            }
        }

        @Override
        public void setConfig(ConfigItem config) {
            this.browserConfig = (Win32BrowserConfig)config;
            int i = 0;
            while (i < this.browserConfig.actions.children.length) {
                URLAction action = this.browserConfig.actions.children[i];
                this.policiesList[i].setSelectedIndex(action.getPolicyIndex(action.currentPolicy));
                ++i;
            }
        }

        @Override
        public void applyConfig() throws ConfigException {
            int i = 0;
            while (i < this.policiesList.length) {
                URLAction action = this.browserConfig.actions.children[i];
                action.currentPolicy = action.policies[this.policiesList[i].getSelectedIndex()].policy;
                ++i;
            }
        }
    }
}

