/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public class CTabItem
extends Item {
    CTabFolder parent;
    int x;
    int y;
    int width;
    int height = 0;
    Control control;
    String toolTipText;
    String shortenedText;
    int shortenedTextWidth;
    Font font;
    Image disabledImage;
    Rectangle closeRect = new Rectangle(0, 0, 0, 0);
    int closeImageState = 0;
    boolean showClose = false;
    boolean showing = false;
    static final int TOP_MARGIN = 2;
    static final int BOTTOM_MARGIN = 2;
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 4;
    static final int INTERNAL_SPACING = 4;
    static final int FLAGS = 9;
    static final String ELLIPSIS = "...";

    public CTabItem(CTabFolder cTabFolder, int n) {
        this(cTabFolder, n, cTabFolder.getItemCount());
    }

    public CTabItem(CTabFolder cTabFolder, int n, int n2) {
        super(cTabFolder, n);
        this.showClose = (n & 0x40) != 0;
        cTabFolder.createItem(this, n2);
    }

    boolean useEllipses() {
        return this.parent.simple;
    }

    String shortenText(GC gC, String string, int n) {
        return this.useEllipses() ? this.shortenText(gC, string, n, ELLIPSIS) : this.shortenText(gC, string, n, "");
    }

    String shortenText(GC gC, String string, int n, String string2) {
        if (gC.textExtent((String)string, (int)9).x <= n) {
            return string;
        }
        int n2 = gC.textExtent((String)string2, (int)9).x;
        int n3 = string.length();
        TextLayout textLayout = new TextLayout(this.getDisplay());
        textLayout.setText(string);
        int n4 = textLayout.getPreviousOffset(n3, 2);
        while (n4 > 0) {
            string = string.substring(0, n4);
            int n5 = gC.textExtent((String)string, (int)9).x;
            if (n5 + n2 <= n) break;
            n4 = textLayout.getPreviousOffset(n4, 2);
        }
        textLayout.dispose();
        return n4 == 0 ? string.substring(0, 1) : String.valueOf(string) + string2;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.parent.destroyItem(this);
        super.dispose();
        this.parent = null;
        this.control = null;
        this.toolTipText = null;
        this.shortenedText = null;
        this.font = null;
    }

    void drawClose(GC gC) {
        if (this.closeRect.width == 0 || this.closeRect.height == 0) {
            return;
        }
        Display display = this.getDisplay();
        int n = Math.max(1, 4);
        int n2 = this.closeRect.x + n;
        int n3 = this.closeRect.y + n;
        n3 += this.parent.onBottom ? -1 : 1;
        Color color = display.getSystemColor(17);
        switch (this.closeImageState) {
            case 1: {
                int[] nArray = new int[]{n2, n3, n2 + 2, n3, n2 + 4, n3 + 2, n2 + 5, n3 + 2, n2 + 7, n3, n2 + 9, n3, n2 + 9, n3 + 2, n2 + 7, n3 + 4, n2 + 7, n3 + 5, n2 + 9, n3 + 7, n2 + 9, n3 + 9, n2 + 7, n3 + 9, n2 + 5, n3 + 7, n2 + 4, n3 + 7, n2 + 2, n3 + 9, n2, n3 + 9, n2, n3 + 7, n2 + 2, n3 + 5, n2 + 2, n3 + 4, n2, n3 + 2};
                gC.setBackground(display.getSystemColor(25));
                gC.fillPolygon(nArray);
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 2: {
                int[] nArray = new int[]{n2, n3, n2 + 2, n3, n2 + 4, n3 + 2, n2 + 5, n3 + 2, n2 + 7, n3, n2 + 9, n3, n2 + 9, n3 + 2, n2 + 7, n3 + 4, n2 + 7, n3 + 5, n2 + 9, n3 + 7, n2 + 9, n3 + 9, n2 + 7, n3 + 9, n2 + 5, n3 + 7, n2 + 4, n3 + 7, n2 + 2, n3 + 9, n2, n3 + 9, n2, n3 + 7, n2 + 2, n3 + 5, n2 + 2, n3 + 4, n2, n3 + 2};
                Color color2 = new Color(display, CTabFolder.CLOSE_FILL);
                gC.setBackground(color2);
                gC.fillPolygon(nArray);
                color2.dispose();
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 3: {
                int[] nArray = new int[]{n2 + 1, n3 + 1, n2 + 3, n3 + 1, n2 + 5, n3 + 3, n2 + 6, n3 + 3, n2 + 8, n3 + 1, n2 + 10, n3 + 1, n2 + 10, n3 + 3, n2 + 8, n3 + 5, n2 + 8, n3 + 6, n2 + 10, n3 + 8, n2 + 10, n3 + 10, n2 + 8, n3 + 10, n2 + 6, n3 + 8, n2 + 5, n3 + 8, n2 + 3, n3 + 10, n2 + 1, n3 + 10, n2 + 1, n3 + 8, n2 + 3, n3 + 6, n2 + 3, n3 + 5, n2 + 1, n3 + 3};
                Color color3 = new Color(display, CTabFolder.CLOSE_FILL);
                gC.setBackground(color3);
                gC.fillPolygon(nArray);
                color3.dispose();
                gC.setForeground(color);
                gC.drawPolygon(nArray);
                break;
            }
            case 0: {
                int[] nArray = new int[]{n2, n3, n2 + 10, n3, n2 + 10, n3 + 10, n2, n3 + 10};
                if (this.parent.gradientColors != null && !this.parent.gradientVertical) {
                    this.parent.drawBackground(gC, nArray, false);
                    break;
                }
                Color color4 = this.parent.getBackground();
                Image image = this.parent.bgImage;
                Color[] colorArray = this.parent.gradientColors;
                int[] nArray2 = this.parent.gradientPercents;
                boolean bl = this.parent.gradientVertical;
                this.parent.drawBackground(gC, nArray, n2, n3, 10, 10, color4, image, colorArray, nArray2, bl);
            }
        }
    }

    void drawSelected(GC gC) {
        Object object;
        Object object2;
        Point point = this.parent.getSize();
        int n = Math.min(this.x + this.width, this.parent.getRightItemEdge());
        int n2 = this.parent.borderLeft;
        int n3 = this.parent.onBottom ? point.y - this.parent.borderBottom - this.parent.tabHeight - this.parent.highlight_header : this.parent.borderTop + this.parent.tabHeight + 1;
        int n4 = point.x - this.parent.borderLeft - this.parent.borderRight;
        int n5 = this.parent.highlight_header - 1;
        int[] nArray = new int[]{n2, n3, n2 + n4, n3, n2 + n4, n3 + n5, n2, n3 + n5};
        if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
            this.parent.drawBackground(gC, nArray, true);
        } else {
            gC.setBackground(this.parent.selectionBackground);
            gC.fillRectangle(n2, n3, n4, n5);
        }
        if (this.parent.single) {
            if (!this.showing) {
                return;
            }
        } else {
            Object object3;
            int n6;
            int n7;
            Object object4;
            if (!this.showing) {
                int n8 = Math.max(0, this.parent.borderLeft - 1);
                int n9 = this.parent.onBottom ? this.y - 1 : this.y + this.height;
                int n10 = point.x - this.parent.borderRight;
                gC.setForeground(CTabFolder.borderColor);
                gC.drawLine(n8, n9, n10, n9);
                return;
            }
            nArray = null;
            if (this.parent.onBottom) {
                object4 = this.parent.simple ? CTabFolder.SIMPLE_BOTTOM_LEFT_CORNER : CTabFolder.BOTTOM_LEFT_CORNER;
                object2 = this.parent.simple ? CTabFolder.SIMPLE_BOTTOM_RIGHT_CORNER : this.parent.curve;
                if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                    object4 = new int[]{this.x, this.y + this.height};
                }
                nArray = new int[((int[])object4).length + ((Object)object2).length + 8];
                n7 = 0;
                nArray[n7++] = this.x;
                nArray[n7++] = this.y - 1;
                nArray[n7++] = this.x;
                nArray[n7++] = this.y - 1;
                n6 = 0;
                while (n6 < ((int[])object4).length / 2) {
                    nArray[n7++] = this.x + object4[2 * n6];
                    nArray[n7++] = this.y + this.height + object4[2 * n6 + 1] - 1;
                    ++n6;
                }
                n6 = 0;
                while (n6 < ((Object)object2).length / 2) {
                    nArray[n7++] = this.parent.simple ? n - 1 + object2[2 * n6] : n - this.parent.curveIndent + object2[2 * n6];
                    nArray[n7++] = this.parent.simple ? this.y + this.height + object2[2 * n6 + 1] - 1 : this.y + object2[2 * n6 + 1] - 2;
                    ++n6;
                }
                nArray[n7++] = this.parent.simple ? n - 1 : n + this.parent.curveWidth - this.parent.curveIndent;
                nArray[n7++] = this.y - 1;
                nArray[n7++] = this.parent.simple ? n - 1 : n + this.parent.curveWidth - this.parent.curveIndent;
                nArray[n7++] = this.y - 1;
            } else {
                object4 = this.parent.simple ? CTabFolder.SIMPLE_TOP_LEFT_CORNER : CTabFolder.TOP_LEFT_CORNER;
                object2 = this.parent.simple ? CTabFolder.SIMPLE_TOP_RIGHT_CORNER : this.parent.curve;
                if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                    object4 = new int[]{this.x, this.y};
                }
                nArray = new int[((int[])object4).length + ((Object)object2).length + 8];
                n7 = 0;
                nArray[n7++] = this.x;
                nArray[n7++] = this.y + this.height + 1;
                nArray[n7++] = this.x;
                nArray[n7++] = this.y + this.height + 1;
                n6 = 0;
                while (n6 < ((int[])object4).length / 2) {
                    nArray[n7++] = this.x + object4[2 * n6];
                    nArray[n7++] = this.y + object4[2 * n6 + 1];
                    ++n6;
                }
                n6 = 0;
                while (n6 < ((Object)object2).length / 2) {
                    nArray[n7++] = this.parent.simple ? n - 1 + object2[2 * n6] : n - this.parent.curveIndent + object2[2 * n6];
                    nArray[n7++] = this.y + object2[2 * n6 + 1];
                    ++n6;
                }
                nArray[n7++] = this.parent.simple ? n - 1 : n + this.parent.curveWidth - this.parent.curveIndent;
                nArray[n7++] = this.y + this.height + 1;
                nArray[n7++] = this.parent.simple ? n - 1 : n + this.parent.curveWidth - this.parent.curveIndent;
                nArray[n7++] = this.y + this.height + 1;
            }
            object4 = gC.getClipping();
            object2 = this.getBounds();
            ++((Rectangle)object2).height;
            if (this.parent.onBottom) {
                --((Rectangle)object2).y;
            }
            if ((n7 = (int)(((Rectangle)object4).intersects((Rectangle)object2) ? 1 : 0)) != 0) {
                if (this.parent.selectionGradientColors != null && !this.parent.selectionGradientVertical) {
                    this.parent.drawBackground(gC, nArray, true);
                } else {
                    Color color = this.parent.selectionBackground;
                    object3 = this.parent.selectionBgImage;
                    Color[] colorArray = this.parent.selectionGradientColors;
                    object = this.parent.selectionGradientPercents;
                    boolean bl = this.parent.selectionGradientVertical;
                    n2 = this.x;
                    n3 = this.parent.onBottom ? this.y - 1 : this.y + 1;
                    n4 = this.width;
                    n5 = this.height;
                    if (!this.parent.single && !this.parent.simple) {
                        n4 += this.parent.curveWidth - this.parent.curveIndent;
                    }
                    this.parent.drawBackground(gC, nArray, n2, n3, n4, n5, color, (Image)object3, colorArray, (int[])object, bl);
                }
            }
            this.drawHighlight(gC, n);
            nArray[0] = Math.max(0, this.parent.borderLeft - 1);
            if (this.parent.borderLeft == 0 && this.parent.indexOf(this) == this.parent.firstIndex) {
                nArray[1] = this.parent.onBottom ? this.y + this.height - 1 : this.y;
                nArray[5] = nArray[3] = nArray[1];
            }
            nArray[nArray.length - 2] = point.x - this.parent.borderRight + 1;
            int n11 = 0;
            while (n11 < nArray.length / 2) {
                if (nArray[2 * n11 + 1] == this.y + this.height + 1) {
                    int n12 = 2 * n11 + 1;
                    nArray[n12] = nArray[n12] - 1;
                }
                ++n11;
            }
            RGB rGB = this.parent.selectionBackground.getRGB();
            if (this.parent.selectionBgImage != null || this.parent.selectionGradientColors != null && this.parent.selectionGradientColors.length > 1) {
                rGB = null;
            }
            object3 = this.parent.getBackground().getRGB();
            if (this.parent.bgImage != null || this.parent.gradientColors != null && this.parent.gradientColors.length > 1) {
                object3 = null;
            }
            this.parent.antialias(nArray, CTabFolder.borderColor.getRGB(), rGB, (RGB)object3, gC);
            gC.setForeground(CTabFolder.borderColor);
            gC.drawPolyline(nArray);
            if (n7 == 0) {
                return;
            }
        }
        int n13 = this.x + 4;
        if (this.parent.single && (this.parent.showClose || this.showClose)) {
            n13 += 18;
        }
        if ((object2 = this.getImage()) != null) {
            Rectangle rectangle = ((Image)object2).getBounds();
            int n14 = n - n13 - 4;
            if (!this.parent.single && this.closeRect.width > 0) {
                n14 -= this.closeRect.width + 4;
            }
            if (rectangle.width < n14) {
                int n15 = n13;
                int n16 = this.y + (this.height - rectangle.height) / 2;
                gC.drawImage((Image)object2, n15, n16 += this.parent.onBottom ? -1 : 1);
                n13 += rectangle.width + 4;
            }
        }
        int n17 = n - n13 - 4;
        if (!this.parent.single && this.closeRect.width > 0) {
            n17 -= this.closeRect.width + 4;
        }
        if (n17 > 0) {
            Font font = gC.getFont();
            gC.setFont(this.font == null ? this.parent.getFont() : this.font);
            if (this.shortenedText == null || this.shortenedTextWidth != n17) {
                this.shortenedText = this.shortenText(gC, this.getText(), n17);
                this.shortenedTextWidth = n17;
            }
            Point point2 = gC.textExtent(this.shortenedText, 9);
            int n18 = this.y + (this.height - point2.y) / 2;
            int n19 = this.parent.onBottom ? -1 : 1;
            gC.setForeground(this.parent.selectionForeground);
            gC.drawText(this.shortenedText, n13, n18 += n19, 9);
            gC.setFont(font);
            if (this.parent.isFocusControl()) {
                object = this.getDisplay();
                if (this.parent.simple || this.parent.single) {
                    gC.setBackground(((Display)object).getSystemColor(2));
                    gC.setForeground(((Display)object).getSystemColor(1));
                    gC.drawFocus(n13 - 1, n18 - 1, point2.x + 2, point2.y + 2);
                } else {
                    gC.setForeground(((Display)object).getSystemColor(17));
                    gC.drawLine(n13, n18 + point2.y + 1, n13 + point2.x + 1, n18 + point2.y + 1);
                }
            }
        }
        if (this.parent.showClose || this.showClose) {
            this.drawClose(gC);
        }
    }

    void drawHighlight(GC gC, int n) {
        int n2;
        int n3;
        int n4;
        if (this.parent.simple || this.parent.onBottom) {
            return;
        }
        if (this.parent.selectionHighlightGradientBegin == null) {
            return;
        }
        Color[] colorArray = this.parent.selectionHighlightGradientColorsCache;
        if (colorArray == null) {
            return;
        }
        int n5 = colorArray.length;
        if (n5 == 0) {
            return;
        }
        gC.setForeground(colorArray[0]);
        gC.drawLine(CTabFolder.TOP_LEFT_CORNER_HILITE[0] + this.x + 1, 1 + this.y, n - this.parent.curveIndent, 1 + this.y);
        int[] nArray = CTabFolder.TOP_LEFT_CORNER_HILITE;
        int n6 = this.parent.tabHeight - this.parent.topCurveHighlightEnd.length / 2;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < nArray.length / 2) {
            n4 = nArray[n10 * 2];
            n3 = nArray[n10 * 2 + 1];
            n7 = n4 + this.x;
            n8 = n3 + this.y;
            n9 = n3 - 1;
            gC.setForeground(colorArray[n9]);
            gC.drawPoint(n7, n8);
            ++n10;
        }
        n10 = n9;
        while (n10 < n5) {
            gC.setForeground(colorArray[n10]);
            gC.drawPoint(n7, 1 + n8++);
            ++n10;
        }
        n10 = n - this.parent.curveIndent;
        n4 = 0;
        while (n4 < this.parent.topCurveHighlightStart.length / 2) {
            n3 = this.parent.topCurveHighlightStart[n4 * 2];
            n2 = this.parent.topCurveHighlightStart[n4 * 2 + 1];
            n7 = n3 + n10;
            n8 = n2 + this.y;
            n9 = n2 - 1;
            if (n9 >= n5) break;
            gC.setForeground(colorArray[n9]);
            gC.drawPoint(n7, n8);
            ++n4;
        }
        n4 = n9;
        while (n4 < n9 + n6) {
            if (n4 >= n5) break;
            gC.setForeground(colorArray[n4]);
            gC.drawPoint(1 + n7++, 1 + n8++);
            ++n4;
        }
        n4 = 0;
        while (n4 < this.parent.topCurveHighlightEnd.length / 2) {
            n3 = this.parent.topCurveHighlightEnd[n4 * 2];
            n2 = this.parent.topCurveHighlightEnd[n4 * 2 + 1];
            n7 = n3 + n10;
            n8 = n2 + this.y;
            n9 = n2 - 1;
            if (n9 >= n5) break;
            gC.setForeground(colorArray[n9]);
            gC.drawPoint(n7, n8);
            ++n4;
        }
    }

    void drawRightUnselectedBorder(GC gC) {
        int[] nArray = null;
        int n = this.x + this.width - 1;
        if (this.parent.onBottom) {
            int[] nArray2 = this.parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.BOTTOM_RIGHT_CORNER;
            nArray = new int[nArray2.length + 2];
            int n2 = 0;
            int n3 = 0;
            while (n3 < nArray2.length / 2) {
                nArray[n2++] = n + nArray2[2 * n3];
                nArray[n2++] = this.y + this.height + nArray2[2 * n3 + 1] - 1;
                ++n3;
            }
            nArray[n2++] = n;
            nArray[n2++] = this.y - 1;
        } else {
            int[] nArray3 = this.parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.TOP_RIGHT_CORNER;
            nArray = new int[nArray3.length + 2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < nArray3.length / 2) {
                nArray[n4++] = n + nArray3[2 * n5];
                nArray[n4++] = this.y + nArray3[2 * n5 + 1];
                ++n5;
            }
            nArray[n4++] = n;
            nArray[n4++] = this.y + this.height;
        }
        this.drawBorder(gC, nArray);
    }

    void drawBorder(GC gC, int[] nArray) {
        gC.setForeground(CTabFolder.borderColor);
        gC.drawPolyline(nArray);
    }

    void drawLeftUnselectedBorder(GC gC) {
        int[] nArray = null;
        if (this.parent.onBottom) {
            int[] nArray2 = this.parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.BOTTOM_LEFT_CORNER;
            nArray = new int[nArray2.length + 2];
            int n = 0;
            nArray[n++] = this.x;
            nArray[n++] = this.y - 1;
            int n2 = 0;
            while (n2 < nArray2.length / 2) {
                nArray[n++] = this.x + nArray2[2 * n2];
                nArray[n++] = this.y + this.height + nArray2[2 * n2 + 1] - 1;
                ++n2;
            }
        } else {
            int[] nArray3 = this.parent.simple ? CTabFolder.SIMPLE_UNSELECTED_INNER_CORNER : CTabFolder.TOP_LEFT_CORNER;
            nArray = new int[nArray3.length + 2];
            int n = 0;
            nArray[n++] = this.x;
            nArray[n++] = this.y + this.height;
            int n3 = 0;
            while (n3 < nArray3.length / 2) {
                nArray[n++] = this.x + nArray3[2 * n3];
                nArray[n++] = this.y + nArray3[2 * n3 + 1];
                ++n3;
            }
        }
        this.drawBorder(gC, nArray);
    }

    void drawUnselected(GC gC) {
        int n;
        Rectangle rectangle;
        if (!this.showing) {
            return;
        }
        Rectangle rectangle2 = gC.getClipping();
        if (!rectangle2.intersects(rectangle = this.getBounds())) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 > 0 && n2 < this.parent.selectedIndex) {
            this.drawLeftUnselectedBorder(gC);
        }
        if (n2 > this.parent.selectedIndex) {
            this.drawRightUnselectedBorder(gC);
        }
        int n3 = this.x + 4;
        Image image = this.getImage();
        if (image != null && this.parent.showUnselectedImage) {
            Rectangle rectangle3 = image.getBounds();
            int n4 = this.x + this.width - n3 - 4;
            if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
                n4 -= this.closeRect.width + 4;
            }
            if (rectangle3.width < n4) {
                int n5 = n3;
                n = rectangle3.height;
                int n6 = this.y + (this.height - n) / 2;
                int n7 = this.parent.onBottom ? -1 : 1;
                int n8 = rectangle3.width * n / rectangle3.height;
                gC.drawImage(image, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, n5, n6 += n7, n8, n);
                n3 += n8 + 4;
            }
        }
        int n9 = this.x + this.width - n3 - 4;
        if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
            n9 -= this.closeRect.width + 4;
        }
        if (n9 > 0) {
            Font font = gC.getFont();
            gC.setFont(this.font == null ? this.parent.getFont() : this.font);
            if (this.shortenedText == null || this.shortenedTextWidth != n9) {
                this.shortenedText = this.shortenText(gC, this.getText(), n9);
                this.shortenedTextWidth = n9;
            }
            Point point = gC.textExtent(this.shortenedText, 9);
            n = this.y + (this.height - point.y) / 2;
            int n10 = this.parent.onBottom ? -1 : 1;
            gC.setForeground(this.parent.getForeground());
            gC.drawText(this.shortenedText, n3, n += n10, 9);
            gC.setFont(font);
        }
        if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
            this.drawClose(gC);
        }
    }

    public Rectangle getBounds() {
        int n = this.width;
        if (!this.parent.simple && !this.parent.single && this.parent.indexOf(this) == this.parent.selectedIndex) {
            n += this.parent.curveWidth - this.parent.curveIndent;
        }
        return new Rectangle(this.x, this.y, n, this.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public CTabFolder getParent() {
        return this.parent;
    }

    public boolean getShowClose() {
        this.checkWidget();
        return this.showClose;
    }

    public String getToolTipText() {
        String string;
        this.checkWidget();
        if (this.toolTipText == null && this.shortenedText != null && !this.shortenedText.equals(string = this.getText())) {
            return string;
        }
        return this.toolTipText;
    }

    public boolean isShowing() {
        this.checkWidget();
        return this.showing;
    }

    void onPaint(GC gC, boolean bl) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (bl) {
            this.drawSelected(gC);
        } else {
            this.drawUnselected(gC);
        }
    }

    int preferredHeight(GC gC) {
        Image image = this.getImage();
        int n = image == null ? 0 : image.getBounds().height;
        String string = this.getText();
        if (this.font == null) {
            n = Math.max(n, gC.textExtent((String)string, (int)9).y);
        } else {
            Font font = gC.getFont();
            gC.setFont(this.font);
            n = Math.max(n, gC.textExtent((String)string, (int)9).y);
            gC.setFont(font);
        }
        return n + 2 + 2;
    }

    int preferredWidth(GC gC, boolean bl, boolean bl2) {
        if (this.isDisposed()) {
            return 0;
        }
        int n = 0;
        Image image = this.getImage();
        if (image != null && (bl || this.parent.showUnselectedImage)) {
            n += image.getBounds().width;
        }
        String string = null;
        if (bl2) {
            int n2 = this.parent.minChars;
            String string2 = string = n2 == 0 ? null : this.getText();
            if (string != null && string.length() > n2) {
                if (this.useEllipses()) {
                    int n3 = n2 < ELLIPSIS.length() + 1 ? n2 : n2 - ELLIPSIS.length();
                    string = string.substring(0, n3);
                    if (n2 > ELLIPSIS.length() + 1) {
                        string = String.valueOf(string) + ELLIPSIS;
                    }
                } else {
                    int n4 = n2;
                    string = string.substring(0, n4);
                }
            }
        } else {
            string = this.getText();
        }
        if (string != null) {
            if (n > 0) {
                n += 4;
            }
            if (this.font == null) {
                n += gC.textExtent((String)string, (int)9).x;
            } else {
                Font font = gC.getFont();
                gC.setFont(this.font);
                n += gC.textExtent((String)string, (int)9).x;
                gC.setFont(font);
            }
        }
        if ((this.parent.showClose || this.showClose) && (bl || this.parent.showUnselectedClose)) {
            if (n > 0) {
                n += 4;
            }
            n += 18;
        }
        return n + 4 + 4;
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                SWT.error(5);
            }
            if (control.getParent() != this.parent) {
                SWT.error(32);
            }
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
        this.control = control;
        if (this.control != null) {
            int n = this.parent.indexOf(this);
            if (n == this.parent.getSelectionIndex()) {
                this.control.setBounds(this.parent.getClientArea());
                this.control.setVisible(true);
            } else {
                this.control.setVisible(false);
            }
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        this.disabledImage = image;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (font == null && this.font == null) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        if (!this.parent.updateTabHeight(false)) {
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        Image image2 = this.getImage();
        if (image == null && image2 == null) {
            return;
        }
        if (image != null && image.equals(image2)) {
            return;
        }
        super.setImage(image);
        if (!this.parent.updateTabHeight(false)) {
            if (image2 != null && image != null) {
                Rectangle rectangle = image2.getBounds();
                Rectangle rectangle2 = image.getBounds();
                if (rectangle2.width == rectangle.width && rectangle2.height == rectangle.height) {
                    if (this.showing) {
                        boolean bl;
                        boolean bl2 = bl = this.parent.indexOf(this) == this.parent.selectedIndex;
                        if (bl || this.parent.showUnselectedImage) {
                            int n;
                            int n2;
                            int n3 = this.x + 4;
                            if (bl) {
                                if (this.parent.single && (this.parent.showClose || this.showClose)) {
                                    n3 += 18;
                                }
                                n2 = Math.min(this.x + this.width, this.parent.getRightItemEdge());
                                n = n2 - n3 - 4;
                                if (!this.parent.single && this.closeRect.width > 0) {
                                    n -= this.closeRect.width + 4;
                                }
                            } else {
                                n = this.x + this.width - n3 - 4;
                                if (this.parent.showUnselectedClose && (this.parent.showClose || this.showClose)) {
                                    n -= this.closeRect.width + 4;
                                }
                            }
                            if (rectangle2.width < n) {
                                n2 = this.y + (this.height - rectangle2.height) / 2 + (this.parent.onBottom ? -1 : 1);
                                this.parent.redraw(n3, n2, rectangle2.width, rectangle2.height, false);
                            }
                        }
                    }
                    return;
                }
            }
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setShowClose(boolean bl) {
        this.checkWidget();
        if (this.showClose == bl) {
            return;
        }
        this.showClose = bl;
        this.parent.updateItems();
        this.parent.redrawTabs();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.getText())) {
            return;
        }
        super.setText(string);
        this.shortenedText = null;
        this.shortenedTextWidth = 0;
        if (!this.parent.updateTabHeight(false)) {
            this.parent.updateItems();
            this.parent.redrawTabs();
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

