/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.utilities;

import chrriis.dj.nativeswing.CommandMessage;
import chrriis.dj.nativeswing.SWTUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;

public class FileTypeLauncher {
    private static Map<Integer, FileTypeLauncherInfo> idToFileTypeLauncherInfoMap;
    private static Map<Program, FileTypeLauncherInfo> programToFileTypeLauncherInfoMap;
    private static boolean isNativeInitialized;
    private static boolean hasInitializedLaunchers;
    private static boolean hasInitializedExtensions;
    private int id;
    private String[] registeredExtensions;
    private String name;
    private ImageIcon icon;
    private boolean isIconInitialized;
    private Integer hashCode;
    private static Map<Integer, FileTypeLauncher> idToFileTypeLauncherMap;
    private static boolean isDefaultIconLoaded;
    private static ImageIcon defaultIcon;

    private static boolean isProgramValid(Program program) {
        String name = program.getName();
        return name != null && name.length() > 0;
    }

    private static void initNative() {
        if (isNativeInitialized) {
            return;
        }
        isNativeInitialized = true;
        programToFileTypeLauncherInfoMap = new HashMap<Program, FileTypeLauncherInfo>();
        idToFileTypeLauncherInfoMap = new HashMap<Integer, FileTypeLauncherInfo>();
    }

    public static void load() {
        FileTypeLauncher.initializeExtensions();
        FileTypeLauncher.initializeLaunchers();
    }

    private static void initializeLaunchers() {
        if (hasInitializedLaunchers) {
            return;
        }
        hasInitializedLaunchers = true;
        new CMN_initializeLaunchers().syncExec(new Object[0]);
    }

    private static void initializeExtensions() {
        if (hasInitializedExtensions) {
            return;
        }
        hasInitializedExtensions = true;
        new CMN_initializeExtensions().syncExec(new Object[0]);
    }

    public static String[] getAllRegisteredExtensions() {
        FileTypeLauncher.initializeExtensions();
        return (String[])new CMN_getAllRegisteredExtensions().syncExec(new Object[0]);
    }

    private FileTypeLauncher(int id) {
        this.id = id;
    }

    public String[] getRegisteredExtensions() {
        if (this.registeredExtensions == null) {
            FileTypeLauncher.initializeExtensions();
            this.registeredExtensions = (String[])new CMN_getRegisteredExtensions().syncExec(this.id);
        }
        return this.registeredExtensions;
    }

    public String getName() {
        if (this.name == null) {
            this.name = (String)new CMN_getName().syncExec(this.id);
        }
        return this.name;
    }

    public ImageIcon getIcon() {
        if (!this.isIconInitialized) {
            this.isIconInitialized = true;
            this.icon = (ImageIcon)new CMN_getIcon().syncExec(this.id);
        }
        return this.icon == null ? FileTypeLauncher.getDefaultIcon() : this.icon;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = (Integer)new CMN_hashCode().syncExec(this.id);
        }
        return this.hashCode;
    }

    public void launch(String filePath) {
        new CMN_launch().asyncExec(this.id, filePath);
    }

    public static FileTypeLauncher getLauncher(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        String extension = fileName.substring(index);
        Integer id = (Integer)new CMN_getLauncherID().syncExec(extension);
        if (id == null) {
            return null;
        }
        FileTypeLauncher fileTypeLauncher = idToFileTypeLauncherMap.get(id);
        if (fileTypeLauncher == null) {
            fileTypeLauncher = new FileTypeLauncher(id);
            idToFileTypeLauncherMap.put(id, fileTypeLauncher);
        }
        return fileTypeLauncher;
    }

    public static FileTypeLauncher[] getLaunchers() {
        FileTypeLauncher.load();
        int[] ids = (int[])new CMN_getLauncherIDs().syncExec(new Object[0]);
        if (idToFileTypeLauncherMap == null) {
            idToFileTypeLauncherMap = new HashMap<Integer, FileTypeLauncher>();
        }
        FileTypeLauncher[] fileTypeLaunchers = new FileTypeLauncher[ids.length];
        int i = 0;
        while (i < ids.length) {
            int id = ids[i];
            FileTypeLauncher fileTypeLauncher = idToFileTypeLauncherMap.get(id);
            if (fileTypeLauncher == null) {
                fileTypeLauncher = new FileTypeLauncher(id);
                idToFileTypeLauncherMap.put(id, fileTypeLauncher);
            }
            fileTypeLaunchers[i] = fileTypeLauncher;
            ++i;
        }
        return fileTypeLaunchers;
    }

    public static ImageIcon getDefaultIcon() {
        if (!isDefaultIconLoaded) {
            Icon defaultIcon_;
            isDefaultIconLoaded = true;
            try {
                File tmpFile = File.createTempFile("~djn", "~.qwertyuiop");
                tmpFile.deleteOnExit();
                defaultIcon_ = FileSystemView.getFileSystemView().getSystemIcon(tmpFile);
                tmpFile.delete();
            }
            catch (Exception e) {
                defaultIcon_ = UIManager.getIcon("FileView.fileIcon");
            }
            if (!(defaultIcon_ instanceof ImageIcon)) {
                int width = defaultIcon_.getIconWidth();
                int height = defaultIcon_.getIconHeight();
                BufferedImage image = new BufferedImage(width, height, 2);
                Graphics gc = image.getGraphics();
                defaultIcon_.paintIcon(null, gc, 0, 0);
                gc.dispose();
                defaultIcon_ = new ImageIcon(image);
            }
            defaultIcon = (ImageIcon)defaultIcon_;
        }
        return defaultIcon;
    }

    public static Dimension getIconSize() {
        ImageIcon defaultIcon = FileTypeLauncher.getDefaultIcon();
        return defaultIcon == null ? new Dimension(16, 16) : new Dimension(defaultIcon.getIconWidth(), defaultIcon.getIconHeight());
    }

    private static class CMN_getAllRegisteredExtensions
    extends CommandMessage {
        private CMN_getAllRegisteredExtensions() {
        }

        public Object run(Object[] args) {
            ArrayList<String> extensionList = new ArrayList<String>();
            for (FileTypeLauncherInfo launcherInfo : programToFileTypeLauncherInfoMap.values()) {
                String[] stringArray = launcherInfo.getRegisteredExtensions();
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String registeredExtension = stringArray[n];
                    extensionList.add(registeredExtension);
                    ++n;
                }
            }
            return extensionList.toArray(new String[0]);
        }
    }

    private static class CMN_getIcon
    extends CommandMessage {
        private CMN_getIcon() {
        }

        public Object run(Object[] args) {
            return ((FileTypeLauncherInfo)idToFileTypeLauncherInfoMap.get(args[0])).getIcon();
        }
    }

    private static class CMN_getLauncherID
    extends CommandMessage {
        private CMN_getLauncherID() {
        }

        public Object run(Object[] args) {
            String extension = (String)args[0];
            Program program = Program.findProgram((String)extension);
            if (program == null) {
                return null;
            }
            FileTypeLauncher.initNative();
            FileTypeLauncherInfo fileTypeLauncher = (FileTypeLauncherInfo)programToFileTypeLauncherInfoMap.get(program);
            if (fileTypeLauncher == null && FileTypeLauncher.isProgramValid(program)) {
                fileTypeLauncher = new FileTypeLauncherInfo(program);
                programToFileTypeLauncherInfoMap.put(program, fileTypeLauncher);
            }
            if (fileTypeLauncher != null) {
                if (!hasInitializedExtensions) {
                    fileTypeLauncher.addExtension(extension);
                }
                return fileTypeLauncher.getID();
            }
            return null;
        }
    }

    private static class CMN_getLauncherIDs
    extends CommandMessage {
        private CMN_getLauncherIDs() {
        }

        public Object run(Object[] args) {
            FileTypeLauncher.initNative();
            FileTypeLauncherInfo[] fileTypeLaunchers = programToFileTypeLauncherInfoMap.values().toArray(new FileTypeLauncherInfo[0]);
            Arrays.sort(fileTypeLaunchers, new Comparator<FileTypeLauncherInfo>(){

                @Override
                public int compare(FileTypeLauncherInfo o1, FileTypeLauncherInfo o2) {
                    return o1.getProgram().getName().toLowerCase().compareTo(o2.getProgram().getName().toLowerCase());
                }
            });
            int[] ids = new int[fileTypeLaunchers.length];
            int i = 0;
            while (i < fileTypeLaunchers.length) {
                ids[i] = fileTypeLaunchers[i].getID();
                ++i;
            }
            return ids;
        }
    }

    private static class CMN_getName
    extends CommandMessage {
        private CMN_getName() {
        }

        public Object run(Object[] args) {
            return ((FileTypeLauncherInfo)idToFileTypeLauncherInfoMap.get(args[0])).getProgram().getName();
        }
    }

    private static class CMN_getRegisteredExtensions
    extends CommandMessage {
        private CMN_getRegisteredExtensions() {
        }

        public Object run(Object[] args) {
            return ((FileTypeLauncherInfo)idToFileTypeLauncherInfoMap.get(args[0])).getRegisteredExtensions();
        }
    }

    private static class CMN_hashCode
    extends CommandMessage {
        private CMN_hashCode() {
        }

        public Object run(Object[] args) {
            return ((FileTypeLauncherInfo)idToFileTypeLauncherInfoMap.get(args[0])).getProgram().hashCode();
        }
    }

    private static class CMN_initializeExtensions
    extends CommandMessage {
        private CMN_initializeExtensions() {
        }

        public Object run(Object[] args) {
            String[] stringArray = Program.getExtensions();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String extension = stringArray[n];
                Program program = Program.findProgram((String)extension);
                if (program != null) {
                    FileTypeLauncher.initNative();
                    FileTypeLauncherInfo fileTypeLauncherInfo = (FileTypeLauncherInfo)programToFileTypeLauncherInfoMap.get(program);
                    if (fileTypeLauncherInfo == null && FileTypeLauncher.isProgramValid(program)) {
                        fileTypeLauncherInfo = new FileTypeLauncherInfo(program);
                        programToFileTypeLauncherInfoMap.put(program, fileTypeLauncherInfo);
                    }
                    if (fileTypeLauncherInfo != null) {
                        fileTypeLauncherInfo.addExtension(extension);
                    }
                }
                ++n;
            }
            return null;
        }
    }

    private static class CMN_initializeLaunchers
    extends CommandMessage {
        private CMN_initializeLaunchers() {
        }

        public Object run(Object[] args) {
            Program[] programArray = Program.getPrograms();
            int n = 0;
            int n2 = programArray.length;
            while (n < n2) {
                Program program = programArray[n];
                if (!programToFileTypeLauncherInfoMap.containsKey(program) && FileTypeLauncher.isProgramValid(program) && program.getImageData() != null) {
                    programToFileTypeLauncherInfoMap.put(program, new FileTypeLauncherInfo(program));
                }
                ++n;
            }
            return null;
        }
    }

    private static class CMN_launch
    extends CommandMessage {
        private CMN_launch() {
        }

        public Object run(Object[] args) {
            ((FileTypeLauncherInfo)idToFileTypeLauncherInfoMap.get(args[0])).getProgram().execute((String)args[1]);
            return null;
        }
    }

    private static class FileTypeLauncherInfo {
        public static int nextID = 1;
        private int id = nextID++;
        private Program program;
        private List<String> registeredExtensionList;
        private boolean isIconInitialized;
        private ImageIcon icon;

        public FileTypeLauncherInfo(Program program) {
            this.program = program;
            idToFileTypeLauncherInfoMap.put(this.getID(), this);
        }

        private void addExtension(String extension) {
            if (this.registeredExtensionList == null) {
                this.registeredExtensionList = new ArrayList<String>(1);
            }
            if (!this.registeredExtensionList.contains(extension)) {
                this.registeredExtensionList.add(extension);
            }
        }

        public int getID() {
            return this.id;
        }

        public String[] getRegisteredExtensions() {
            return this.registeredExtensionList == null ? new String[]{} : this.registeredExtensionList.toArray(new String[0]);
        }

        public Program getProgram() {
            return this.program;
        }

        public ImageIcon getIcon() {
            if (!this.isIconInitialized) {
                this.isIconInitialized = true;
                ImageData imageData = this.program.getImageData();
                this.icon = imageData == null ? null : new ImageIcon(SWTUtils.convertSWTImage(imageData));
            }
            return this.icon;
        }
    }
}

