/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.components;

import chrriis.dj.nativeswing.WebBrowserObject;
import chrriis.dj.nativeswing.components.JVLCPlayer;

public class VLCInput {
    private WebBrowserObject webBrowserObject;

    VLCInput(JVLCPlayer vlcPlayer) {
        this.webBrowserObject = vlcPlayer.getWebBrowserObject();
    }

    public int getDuration() {
        Object value = this.webBrowserObject.getObjectProperty("input.length");
        return value == null ? -1 : ((Number)value).intValue();
    }

    public float getFrameRate() {
        Object value = this.webBrowserObject.getObjectProperty("input.fps");
        return value == null ? Float.NaN : ((Number)value).floatValue();
    }

    public boolean isVideoDisplayed() {
        return Boolean.TRUE.equals(this.webBrowserObject.getObjectProperty("input.isVout"));
    }

    public void setRelativePosition(float position) {
        if (position >= 0.0f && position <= 1.0f) {
            this.webBrowserObject.setObjectProperty("input.position", Float.valueOf(position));
            return;
        }
        throw new IllegalArgumentException("The position must be between 0 and 1");
    }

    public float getRelativePosition() {
        Object value = this.webBrowserObject.getObjectProperty("input.position");
        return value == null ? Float.NaN : ((Number)value).floatValue();
    }

    public void setAbsolutePosition(int time) {
        this.webBrowserObject.setObjectProperty("input.time", time);
    }

    public int getAbsolutePosition() {
        Object value = this.webBrowserObject.getObjectProperty("input.time");
        return value == null ? -1 : ((Number)value).intValue();
    }

    public VLCMediaState getMediaState() {
        Object value = this.webBrowserObject.getObjectProperty("input.state");
        if (value == null) {
            return null;
        }
        switch (((Number)value).intValue()) {
            case 0: {
                return VLCMediaState.IDLE_CLOSE;
            }
            case 1: {
                return VLCMediaState.OPENING;
            }
            case 2: {
                return VLCMediaState.BUFFERING;
            }
            case 3: {
                return VLCMediaState.PLAYING;
            }
            case 4: {
                return VLCMediaState.PAUSED;
            }
            case 5: {
                return VLCMediaState.STOPPING;
            }
            case 6: {
                return VLCMediaState.ERROR;
            }
        }
        return null;
    }

    public void setPlaySpeedFactor(float speedFactor) {
        this.webBrowserObject.setObjectProperty("input.rate", Float.valueOf(speedFactor));
    }

    public float getPlaySpeedFactor() {
        Object value = this.webBrowserObject.getObjectProperty("input.rate");
        return value == null ? Float.NaN : ((Number)value).floatValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VLCMediaState {
        IDLE_CLOSE,
        OPENING,
        BUFFERING,
        PLAYING,
        PAUSED,
        STOPPING,
        ERROR;

    }
}

