/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.components;

import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.NSPanelComponent;
import chrriis.dj.nativeswing.WebBrowserObject;
import chrriis.dj.nativeswing.components.JWebBrowser;
import chrriis.dj.nativeswing.components.VLCAudio;
import chrriis.dj.nativeswing.components.VLCInput;
import chrriis.dj.nativeswing.components.VLCPlaylist;
import chrriis.dj.nativeswing.components.VLCPluginOptions;
import chrriis.dj.nativeswing.components.VLCVideo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVLCPlayer
extends NSPanelComponent {
    private final ResourceBundle RESOURCES = ResourceBundle.getBundle(String.valueOf(JVLCPlayer.class.getPackage().getName().replace('.', '/')) + "/resource/VLCPlayer");
    private JPanel webBrowserPanel;
    private JWebBrowser webBrowser;
    private JPanel controlBarPane;
    private JButton playButton;
    private JButton pauseButton;
    private JButton stopButton;
    private WebBrowserObject webBrowserObject;
    private JSlider seekBarSlider;
    private volatile boolean isAdjustingSeekBar;
    private volatile Thread updateThread;
    private JLabel timeLabel;
    private JButton volumeButton;
    private JSlider volumeSlider;
    private boolean isAdjustingVolume;
    private VLCPluginOptions options;
    private VLCAudio vlcAudio;
    private VLCInput vlcInput;
    private VLCPlaylist vlcPlaylist;
    private VLCVideo vlcVideo;
    private List<ClassLoader> referenceClassLoaderList = new ArrayList<ClassLoader>(1);

    WebBrowserObject getWebBrowserObject() {
        return this.webBrowserObject;
    }

    void adjustVolumePanel() {
        this.volumeButton.setEnabled(true);
        VLCAudio vlcAudio = this.getVLCAudio();
        boolean isMute = vlcAudio.isMute();
        if (isMute) {
            this.volumeButton.setIcon(this.createIcon("VolumeOffIcon"));
            this.volumeButton.setToolTipText(this.RESOURCES.getString("VolumeOffText"));
        } else {
            this.volumeButton.setIcon(this.createIcon("VolumeOnIcon"));
            this.volumeButton.setToolTipText(this.RESOURCES.getString("VolumeOnText"));
        }
        this.volumeSlider.setEnabled(!isMute);
        if (!isMute) {
            this.isAdjustingVolume = true;
            this.volumeSlider.setValue(vlcAudio.getVolume());
            this.isAdjustingVolume = false;
        }
    }

    @Override
    public void removeNotify() {
        this.stopUpdateThread();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.webBrowserObject.hasContent()) {
            this.startUpdateThread();
        }
    }

    private void stopUpdateThread() {
        this.updateThread = null;
    }

    private void startUpdateThread() {
        if (this.updateThread != null) {
            return;
        }
        if (this.isNativePeerDisposed()) {
            return;
        }
        this.updateThread = new Thread("NativeSwing - VLC Player control bar update"){

            public void run() {
                final 1 currentThread = this;
                while (currentThread == JVLCPlayer.this.updateThread) {
                    if (JVLCPlayer.this.isNativePeerDisposed()) {
                        JVLCPlayer.this.stopUpdateThread();
                        return;
                    }
                    try {
                        1.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            boolean isValid;
                            if (currentThread != JVLCPlayer.this.updateThread) {
                                return;
                            }
                            if (!JVLCPlayer.this.isNativePeerValid()) {
                                return;
                            }
                            VLCInput vlcInput = JVLCPlayer.this.getVLCInput();
                            VLCInput.VLCMediaState state = vlcInput.getMediaState();
                            boolean bl = isValid = state == VLCInput.VLCMediaState.OPENING || state == VLCInput.VLCMediaState.BUFFERING || state == VLCInput.VLCMediaState.PLAYING || state == VLCInput.VLCMediaState.PAUSED || state == VLCInput.VLCMediaState.STOPPING;
                            if (isValid) {
                                int time = vlcInput.getAbsolutePosition();
                                int length = vlcInput.getDuration();
                                boolean bl2 = isValid = time >= 0 && length > 0;
                                if (isValid) {
                                    JVLCPlayer.this.isAdjustingSeekBar = true;
                                    JVLCPlayer.this.seekBarSlider.setValue(Math.round((float)time * 10000.0f / (float)length));
                                    JVLCPlayer.this.isAdjustingSeekBar = false;
                                    JVLCPlayer.this.timeLabel.setText(String.valueOf(JVLCPlayer.formatTime(time, length >= 3600000)) + " / " + JVLCPlayer.formatTime(length, false));
                                }
                            }
                            if (!isValid) {
                                JVLCPlayer.this.timeLabel.setText("");
                            }
                            JVLCPlayer.this.seekBarSlider.setVisible(isValid);
                        }
                    });
                }
            }
        };
        this.updateThread.setDaemon(true);
        this.updateThread.start();
    }

    private static String formatTime(int milliseconds, boolean showHours) {
        int seconds = milliseconds / 1000;
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        seconds %= 60;
        StringBuilder sb = new StringBuilder();
        if (hours != 0 || showHours) {
            sb.append(hours).append(':');
        }
        sb.append(minutes < 10 ? "0" : "").append(minutes).append(':');
        sb.append(seconds < 10 ? "0" : "").append(seconds);
        return sb.toString();
    }

    public JVLCPlayer(NSOption ... options) {
        this.webBrowser = new JWebBrowser(options);
        this.initialize(this.webBrowser.getNativeComponent());
        this.webBrowserObject = new NWebBrowserObject(this);
        this.vlcAudio = new VLCAudio(this);
        this.vlcInput = new VLCInput(this);
        this.vlcPlaylist = new VLCPlaylist(this);
        this.vlcVideo = new VLCVideo(this);
        this.webBrowserPanel = new JPanel(new BorderLayout(0, 0));
        this.webBrowserPanel.add((Component)this.webBrowser, "Center");
        this.add((Component)this.webBrowserPanel, "Center");
        this.controlBarPane = new JPanel(new BorderLayout(0, 0));
        this.seekBarSlider = new JSlider(0, 10000, 0);
        this.seekBarSlider.setVisible(false);
        this.seekBarSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!JVLCPlayer.this.isAdjustingSeekBar) {
                    JVLCPlayer.this.getVLCInput().setRelativePosition((float)JVLCPlayer.this.seekBarSlider.getValue() / 10000.0f);
                }
            }
        });
        this.controlBarPane.add((Component)this.seekBarSlider, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 4, 2));
        this.playButton = new JButton(this.createIcon("PlayIcon"));
        this.playButton.setEnabled(false);
        this.playButton.setToolTipText(this.RESOURCES.getString("PlayText"));
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JVLCPlayer.this.getVLCPlaylist().play();
            }
        });
        buttonPanel.add(this.playButton);
        this.pauseButton = new JButton(this.createIcon("PauseIcon"));
        this.pauseButton.setEnabled(false);
        this.pauseButton.setToolTipText(this.RESOURCES.getString("PauseText"));
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JVLCPlayer.this.getVLCPlaylist().togglePause();
            }
        });
        buttonPanel.add(this.pauseButton);
        this.stopButton = new JButton(this.createIcon("StopIcon"));
        this.stopButton.setEnabled(false);
        this.stopButton.setToolTipText(this.RESOURCES.getString("StopText"));
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JVLCPlayer.this.getVLCPlaylist().stop();
            }
        });
        buttonPanel.add(this.stopButton);
        JPanel volumePanel = new JPanel(new FlowLayout(2, 0, 2));
        this.volumeButton = new JButton();
        Insets margin = this.volumeButton.getMargin();
        margin.left = Math.min(2, margin.left);
        margin.right = Math.min(2, margin.left);
        this.volumeButton.setMargin(margin);
        this.volumeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JVLCPlayer.this.getVLCAudio().toggleMute();
            }
        });
        volumePanel.add(this.volumeButton);
        this.volumeSlider = new JSlider();
        this.volumeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!JVLCPlayer.this.isAdjustingVolume) {
                    JVLCPlayer.this.getVLCAudio().setVolume(JVLCPlayer.this.volumeSlider.getValue());
                }
            }
        });
        this.volumeSlider.setPreferredSize(new Dimension(60, this.volumeSlider.getPreferredSize().height));
        volumePanel.add(this.volumeSlider);
        this.adjustVolumePanel();
        this.volumeButton.setEnabled(false);
        this.volumeSlider.setEnabled(false);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        JPanel buttonBarPanel = new JPanel(gridBag);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.anchor = 17;
        cons.fill = 2;
        this.timeLabel = new JLabel(" ");
        this.timeLabel.setPreferredSize(new Dimension(0, this.timeLabel.getPreferredSize().height));
        gridBag.setConstraints(this.timeLabel, cons);
        buttonBarPanel.add(this.timeLabel);
        ++cons.gridx;
        cons.weightx = 0.0;
        cons.anchor = 10;
        cons.fill = 0;
        gridBag.setConstraints(buttonPanel, cons);
        buttonBarPanel.add(buttonPanel);
        buttonBarPanel.setMinimumSize(buttonBarPanel.getPreferredSize());
        ++cons.gridx;
        cons.weightx = 1.0;
        cons.anchor = 13;
        cons.fill = 2;
        volumePanel.setPreferredSize(new Dimension(0, volumePanel.getPreferredSize().height));
        gridBag.setConstraints(volumePanel, cons);
        buttonBarPanel.add(volumePanel);
        this.controlBarPane.add((Component)buttonBarPanel, "Center");
        this.add((Component)this.controlBarPane, "South");
        this.adjustBorder();
    }

    private void adjustBorder() {
        if (this.isControlBarVisible()) {
            this.webBrowserPanel.setBorder(BorderFactory.createBevelBorder(1));
        } else {
            this.webBrowserPanel.setBorder(null);
        }
    }

    private Icon createIcon(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new ImageIcon(JWebBrowser.class.getResource(value));
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void load() {
        this.load((VLCPluginOptions)null);
    }

    public void load(String resourceLocation) {
        this.load(resourceLocation, null);
    }

    public void load(VLCPluginOptions options) {
        this.load_("", options);
    }

    public void load(Class<?> clazz, String resourcePath) {
        this.load(clazz, resourcePath, null);
    }

    public void load(Class<?> clazz, String resourcePath, VLCPluginOptions options) {
        this.addReferenceClassLoader(clazz.getClassLoader());
        this.load(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath), options);
    }

    public void load(String resourceLocation, VLCPluginOptions options) {
        if ("".equals(resourceLocation)) {
            resourceLocation = null;
        }
        this.load_(resourceLocation, options);
    }

    private void load_(String resourceLocation, VLCPluginOptions options) {
        if (options == null) {
            options = new VLCPluginOptions();
        }
        this.options = options;
        this.webBrowserObject.load(resourceLocation);
        boolean hasContent = this.webBrowserObject.hasContent();
        this.playButton.setEnabled(hasContent);
        this.pauseButton.setEnabled(hasContent);
        this.stopButton.setEnabled(hasContent);
        if (hasContent) {
            this.adjustVolumePanel();
            this.startUpdateThread();
        }
    }

    public boolean isControlBarVisible() {
        return this.controlBarPane.isVisible();
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        this.controlBarPane.setVisible(isControlBarVisible);
        this.adjustBorder();
    }

    public VLCAudio getVLCAudio() {
        return this.vlcAudio;
    }

    public VLCInput getVLCInput() {
        return this.vlcInput;
    }

    public VLCPlaylist getVLCPlaylist() {
        return this.vlcPlaylist;
    }

    public VLCVideo getVLCVideo() {
        return this.vlcVideo;
    }

    void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader() || this.referenceClassLoaderList.contains(referenceClassLoader)) {
            return;
        }
        this.referenceClassLoaderList.add(referenceClassLoader);
        WebServer.getDefaultWebServer().addReferenceClassLoader(referenceClassLoader);
    }

    protected void finalize() throws Throwable {
        for (ClassLoader referenceClassLoader : this.referenceClassLoaderList) {
            WebServer.getDefaultWebServer().removeReferenceClassLoader(referenceClassLoader);
        }
        this.referenceClassLoaderList.clear();
        super.finalize();
    }

    private static class NWebBrowserObject
    extends WebBrowserObject {
        private JVLCPlayer vlcPlayer;

        public NWebBrowserObject(JVLCPlayer vlcPlayer) {
            super(vlcPlayer.webBrowser);
            this.vlcPlayer = vlcPlayer;
        }

        protected WebBrowserObject.ObjectHTMLConfiguration getObjectHtmlConfiguration() {
            WebBrowserObject.ObjectHTMLConfiguration objectHTMLConfiguration = new WebBrowserObject.ObjectHTMLConfiguration();
            objectHTMLConfiguration.setHTMLLoadingMessage(this.vlcPlayer.RESOURCES.getString("LoadingMessage"));
            objectHTMLConfiguration.setHTMLParameters(this.vlcPlayer.options.getParameters());
            objectHTMLConfiguration.setWindowsClassID("9BE31822-FDAD-461B-AD51-BE1D1C159921");
            objectHTMLConfiguration.setWindowsInstallationURL("http://downloads.videolan.org/pub/videolan/vlc/latest/win32/axvlc.cab");
            objectHTMLConfiguration.setMimeType("application/x-vlc-plugin");
            objectHTMLConfiguration.setInstallationURL("http://www.videolan.org");
            objectHTMLConfiguration.setWindowsParamName("Src");
            objectHTMLConfiguration.setParamName("target");
            objectHTMLConfiguration.setVersion("VideoLAN.VLCPlugin.2");
            this.vlcPlayer.options = null;
            return objectHTMLConfiguration;
        }
    }
}

