/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.dj.nativeswing.NativeComponent;
import chrriis.dj.nativeswing.NativeComponentProxy;
import com.sun.jna.examples.WindowUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

class NativeComponentProxyPanel
extends NativeComponentProxy {
    private boolean isProxiedFiliation;
    private HierarchyBoundsListener hierarchyBoundsListener = new HierarchyBoundsListener(){

        public void ancestorMoved(HierarchyEvent e) {
            Component component = e.getChanged();
            if (component instanceof Window) {
                return;
            }
            NativeComponentProxyPanel.this.adjustPeerBounds();
        }

        public void ancestorResized(HierarchyEvent e) {
            NativeComponentProxyPanel.this.adjustPeerBounds();
        }
    };
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            this.adjustFocus();
        }

        protected void adjustFocus() {
            Container parent = NativeComponentProxyPanel.this;
            while (parent != null && !(parent instanceof Window)) {
                if (parent instanceof JInternalFrame) {
                    Window windowAncestor = SwingUtilities.getWindowAncestor(NativeComponentProxyPanel.this);
                    if (windowAncestor == null) break;
                    boolean focusableWindowState = windowAncestor.getFocusableWindowState();
                    windowAncestor.setFocusableWindowState(false);
                    try {
                        ((JInternalFrame)parent).setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    windowAncestor.setFocusableWindowState(focusableWindowState);
                    break;
                }
                parent = parent.getParent();
            }
        }
    };
    private EmbeddedPanel panel;
    private volatile boolean isInvoking;
    private Rectangle[] lastArea = new Rectangle[]{new Rectangle(this.getSize())};

    protected NativeComponentProxyPanel(NativeComponent nativeComponent, boolean isVisibilityConstrained, boolean isDestructionOnFinalization, boolean isProxiedFiliation) {
        super(nativeComponent, isVisibilityConstrained, isDestructionOnFinalization);
        this.setLayout(new BorderLayout(0, 0));
        this.isProxiedFiliation = isProxiedFiliation;
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NativeComponentProxyPanel.this.nativeComponent.requestFocus();
            }
        });
    }

    protected Component createPeer() {
        this.panel = new EmbeddedPanel();
        this.panel.add((Component)this.nativeComponent, "Center");
        return this.panel;
    }

    protected void connectPeer() {
        this.addHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.nativeComponent.addMouseListener(this.mouseListener);
    }

    protected void disconnectPeer() {
        this.removeHierarchyBoundsListener(this.hierarchyBoundsListener);
        this.nativeComponent.removeMouseListener(this.mouseListener);
    }

    protected void addPeer() {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (!(windowAncestor instanceof RootPaneContainer)) {
            throw new IllegalStateException("The window ancestor must be a root pane container!");
        }
        if (this.isProxiedFiliation) {
            JLayeredPane layeredPane = ((RootPaneContainer)((Object)windowAncestor)).getLayeredPane();
            layeredPane.setLayer(this.panel, Integer.MIN_VALUE);
            layeredPane.add(this.panel);
        } else {
            this.add(this.panel);
        }
    }

    protected void destroyPeer() {
        if (this.panel == null) {
            return;
        }
        Container parent = this.panel.getParent();
        if (parent != null) {
            parent.remove(this.panel);
            parent.invalidate();
            parent.validate();
            parent.repaint();
        }
        this.panel = null;
    }

    protected void adjustPeerShape() {
        if (this.isInvoking) {
            return;
        }
        this.isInvoking = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NativeComponentProxyPanel.this.isInvoking = false;
                NativeComponentProxyPanel.this.adjustPeerShape_();
            }
        });
    }

    protected Rectangle[] getPeerShapeArea() {
        return this.lastArea;
    }

    protected void adjustPeerShape_() {
        if (this.panel == null) {
            return;
        }
        Object[] rectangles = this.computePeerShapeArea();
        if (Arrays.equals(this.lastArea, rectangles)) {
            return;
        }
        this.lastArea = rectangles;
        if (rectangles.length == 0) {
            this.panel.setVisible(false);
        } else {
            if (!this.panel.isVisible()) {
                this.panel.setVisible(true);
            }
            WindowUtils.setComponentMask((Component)this.panel, (Rectangle[])rectangles);
        }
    }

    static class EmbeddedPanel
    extends Panel
    implements NativeComponent.NativeComponentHolder {
        public EmbeddedPanel() {
            super(new BorderLayout(0, 0));
        }

        public boolean contains(int x, int y) {
            return false;
        }

        public boolean contains(Point p) {
            return false;
        }
    }
}

