/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.Filter;
import chrriis.common.UIUtils;
import chrriis.dj.nativeswing.NativeComponent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

class BackBufferManager {
    private NativeComponent nativeComponent;
    private Component paintingComponent;
    private final Object backBufferLock = new Object();
    private BufferedImage backBuffer;

    public BackBufferManager(NativeComponent nativeComponent, Component paintingComponent) {
        this.nativeComponent = nativeComponent;
        this.paintingComponent = paintingComponent;
    }

    public void updateBackBufferOnVisibleTranslucentAreas() {
        int width = this.paintingComponent.getWidth();
        int height = this.paintingComponent.getHeight();
        if (width <= 0 || height <= 0) {
            if (this.backBuffer != null) {
                this.backBuffer.flush();
            }
            this.backBuffer = null;
            return;
        }
        this.updateBackBuffer(this.getTranslucentOverlays());
    }

    protected Rectangle[] getTranslucentOverlays() {
        Rectangle[] boundsArea = new Rectangle[]{new Rectangle(0, 0, this.paintingComponent.getWidth(), this.paintingComponent.getHeight())};
        Rectangle[] nonOpaqueAreas = UIUtils.subtract(boundsArea, UIUtils.getComponentVisibleArea(this.paintingComponent, new Filter<Component>(){

            @Override
            public boolean accept(Component c) {
                return !c.isOpaque();
            }
        }, false));
        return UIUtils.subtract(nonOpaqueAreas, UIUtils.subtract(boundsArea, UIUtils.getComponentVisibleArea(this.paintingComponent, new Filter<Component>(){

            @Override
            public boolean accept(Component c) {
                return c.isOpaque();
            }
        }, true)));
    }

    public void createBackBuffer() {
        this.updateBackBuffer(new Rectangle[]{new Rectangle(this.paintingComponent.getWidth(), this.paintingComponent.getHeight())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackBuffer(Rectangle[] rectangles) {
        if (rectangles == null || rectangles.length == 0) {
            return;
        }
        int width = this.paintingComponent.getWidth();
        int height = this.paintingComponent.getHeight();
        if (width <= 0 || height <= 0) {
            if (this.backBuffer != null) {
                this.backBuffer.flush();
            }
            this.backBuffer = null;
            return;
        }
        BufferedImage image = this.backBuffer != null && this.backBuffer.getWidth() == width && this.backBuffer.getHeight() == height ? this.backBuffer : new BufferedImage(width, height, 2);
        this.nativeComponent.paintComponent(image, rectangles);
        Object object = this.backBufferLock;
        synchronized (object) {
            if (this.backBuffer != null && this.backBuffer != image) {
                BufferedImage bufferedImage = this.backBuffer;
                synchronized (bufferedImage) {
                    Graphics g = image.getGraphics();
                    g.drawImage(this.backBuffer, 0, 0, null);
                    g.dispose();
                }
                this.backBuffer.flush();
            }
            this.backBuffer = image;
        }
        if (this.paintingComponent != this.nativeComponent) {
            Rectangle bounds = UIUtils.getBounds(rectangles);
            this.paintingComponent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyBackBuffer() {
        Object object = this.backBufferLock;
        synchronized (object) {
            if (this.backBuffer != null) {
                this.backBuffer.flush();
            }
            this.backBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBackBuffer(Graphics g) {
        Object object = this.backBufferLock;
        synchronized (object) {
            if (this.backBuffer != null) {
                BufferedImage bufferedImage = this.backBuffer;
                synchronized (bufferedImage) {
                    g.drawImage(this.backBuffer, 0, 0, this.paintingComponent);
                }
            }
        }
    }
}

