/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class ObjectRegistry {
    private Thread cleanUpThread;
    private int nextInstanceID = 1;
    private Map<Integer, WeakReference<Object>> instanceIDToObjectReferenceMap = new HashMap<Integer, WeakReference<Object>>();
    private static ObjectRegistry registry = new ObjectRegistry();

    private synchronized void startThread() {
        if (this.cleanUpThread != null) {
            return;
        }
        this.cleanUpThread = new Thread("Registry cleanup thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        1.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ObjectRegistry objectRegistry = ObjectRegistry.this;
                    synchronized (objectRegistry) {
                        Integer[] integerArray = ObjectRegistry.this.instanceIDToObjectReferenceMap.keySet().toArray(new Integer[0]);
                        int n = 0;
                        int n2 = integerArray.length;
                        while (n < n2) {
                            Integer instanceID = integerArray[n];
                            if (((WeakReference)ObjectRegistry.this.instanceIDToObjectReferenceMap.get(instanceID)).get() == null) {
                                ObjectRegistry.this.instanceIDToObjectReferenceMap.remove(instanceID);
                            }
                            ++n;
                        }
                        if (ObjectRegistry.this.instanceIDToObjectReferenceMap.isEmpty()) {
                            ObjectRegistry.this.cleanUpThread = null;
                            return;
                        }
                    }
                }
            }
        };
        this.cleanUpThread.setDaemon(true);
        this.cleanUpThread.start();
    }

    public synchronized int add(Object o) {
        int instanceID;
        do {
            ++this.nextInstanceID;
        } while (this.instanceIDToObjectReferenceMap.containsKey(instanceID));
        if (o == null) {
            return instanceID;
        }
        this.instanceIDToObjectReferenceMap.put(instanceID, new WeakReference<Object>(o));
        this.startThread();
        return instanceID;
    }

    public synchronized void add(Object o, int instanceID) {
        Object o2 = this.get(instanceID);
        if (o2 != null && o2 != o) {
            throw new IllegalStateException("An object is already registered with the id \"" + instanceID + "\" for object: " + o);
        }
        this.instanceIDToObjectReferenceMap.put(instanceID, new WeakReference<Object>(o));
        this.startThread();
    }

    public synchronized Object get(int instanceID) {
        WeakReference<Object> weakReference = this.instanceIDToObjectReferenceMap.get(instanceID);
        if (weakReference == null) {
            return null;
        }
        Object o = weakReference.get();
        if (o == null) {
            this.instanceIDToObjectReferenceMap.remove(instanceID);
        }
        return o;
    }

    public synchronized void remove(int instanceID) {
        this.instanceIDToObjectReferenceMap.remove(instanceID);
    }

    public int[] getInstanceIDs() {
        Object[] instanceIDObjects = this.instanceIDToObjectReferenceMap.keySet().toArray();
        int[] instanceIDs = new int[instanceIDObjects.length];
        int i = 0;
        while (i < instanceIDObjects.length) {
            instanceIDs[i] = (Integer)instanceIDObjects[i];
            ++i;
        }
        return instanceIDs;
    }

    public static ObjectRegistry getInstance() {
        return registry;
    }
}

