/*
 * Decompiled with CFR 0.152.
 */
package chrriis.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkURLClassLoader
extends ClassLoader {
    private URL codebaseURL;

    public NetworkURLClassLoader(String codebase) throws MalformedURLException {
        this.codebaseURL = new URL(codebase);
    }

    @Override
    protected URL findResource(String name) {
        try {
            return new URL(this.codebaseURL, name);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = String.valueOf(name.replace('.', '/')) + ".class";
        Class<?> clazz = null;
        BufferedInputStream in = new BufferedInputStream(this.getResourceAsStream(path));
        try {
            int n;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((n = ((InputStream)in).read(bytes)) != -1) {
                baos.write(bytes, 0, n);
            }
            bytes = baos.toByteArray();
            clazz = this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((InputStream)in).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        return super.findClass(name);
    }

    public static void main(String[] args) throws Exception {
        String codeBase = args[0];
        String mainClass = args[1];
        String[] newArgs = new String[args.length - 2];
        System.arraycopy(args, 2, newArgs, 0, newArgs.length);
        Class<?> clazz = new NetworkURLClassLoader(codeBase).loadClass(mainClass);
        clazz.getMethod("main", String[].class).invoke(null, new Object[]{newArgs});
    }
}

