/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.nvrlib.parser;

import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.ParsingException;
import java.io.BufferedReader;
import java.io.IOException;

public class ParsingContext {
    public StringBuffer text;
    int pos = 0;

    public String toString() {
        try {
            return this.pos + ": " + this.text.substring(this.pos, this.pos + 10);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public ParsingContext(BufferedReader reader) throws NetException {
        int BUF_LEN = 65536;
        StringBuffer sb = new StringBuffer(65536);
        while (true) {
            int readlen;
            char[] buf = new char[65536];
            try {
                readlen = reader.read(buf);
            }
            catch (IOException e) {
                throw new NetException("\u8aad\u307f\u8fbc\u307f\u5931\u6557", e);
            }
            if (readlen == -1) break;
            sb.append(buf, 0, readlen);
        }
        this.text = sb;
    }

    public ParsingContext(String s) {
        this.text = new StringBuffer(s);
    }

    public int seek(String keyword) throws ParsingException {
        int index = this.text.indexOf(keyword, this.pos);
        if (index == -1) {
            throw new ParsingException("key '" + keyword + "' not found", this.text.toString());
        }
        this.pos = index + keyword.length();
        return index;
    }

    public boolean seek(String keyword, String breakWord) throws ParsingException {
        int index = this.text.indexOf(keyword, this.pos);
        if (index == -1) {
            if (breakWord != null && this.text.indexOf(breakWord, this.pos) >= 0) {
                return false;
            }
            throw new ParsingException("key '" + keyword + "' not found", this.text.toString());
        }
        if (breakWord != null && this.text.substring(this.pos, index).indexOf(breakWord) >= 0) {
            return false;
        }
        this.pos = index + keyword.length();
        return true;
    }

    public String cut(String startKeyword, String endKeyword) throws ParsingException {
        int startLength;
        int startIndex;
        if (startKeyword == null) {
            startIndex = this.pos;
            startLength = 0;
        } else {
            startIndex = this.seek(startKeyword);
            startLength = startKeyword.length();
        }
        int endIndex = this.seek(endKeyword);
        return this.text.substring(startIndex + startLength, endIndex);
    }
}

