/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.nvrlib.model;

import com.aibonware.nvrlib.model.BaseArticle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class BaseArticleList<TArticle extends BaseArticle<TArticle>>
implements Iterable<TArticle> {
    protected Vector<TArticle> articles = new Vector();

    public int getArticleCount() {
        return this.articles.size();
    }

    public void addArticle(TArticle article) {
        this.articles.addElement(article);
    }

    public TArticle getArticle(int index) {
        return (TArticle)((BaseArticle)this.articles.elementAt(index));
    }

    public void removeArticle(int index) {
        this.articles.removeElementAt(index);
    }

    public void reverse() {
        Vector<BaseArticle> revObjects = new Vector<BaseArticle>();
        int i = this.articles.size() - 1;
        while (i >= 0) {
            revObjects.addElement((BaseArticle)this.articles.elementAt(i));
            ++i;
        }
        this.articles = revObjects;
    }

    public int getArticleIndexByArticleID(int articleId) {
        int size = this.articles.size();
        int i = 0;
        while (i < size) {
            if (((BaseArticle)this.articles.elementAt((int)i)).articleId == articleId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TArticle getArticleByArticleID(int articleId) {
        int size = this.articles.size();
        int i = 0;
        while (i < size) {
            if (((BaseArticle)this.articles.elementAt((int)i)).articleId == articleId) {
                return (TArticle)((BaseArticle)this.articles.elementAt(i));
            }
            ++i;
        }
        return null;
    }

    public List<TArticle> subList(int start, int end) {
        return this.articles.subList(start, end);
    }

    public void sort() {
        Collections.sort(this.articles, new Comparator<TArticle>(){

            @Override
            public int compare(TArticle src, TArticle dest) {
                if (((BaseArticle)src).sno != ((BaseArticle)dest).sno) {
                    return ((BaseArticle)src).sno - ((BaseArticle)dest).sno;
                }
                return ((BaseArticle)src).articleId - ((BaseArticle)dest).articleId;
            }
        });
    }

    public void replaceArticle(int index, TArticle art) {
        this.articles.set(index, art);
    }

    @Override
    public Iterator<TArticle> iterator() {
        return this.articles.iterator();
    }
}

