/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.view;

import com.aibonware.nvrlib.net.HttpCancellerProvider;
import com.aibonware.nvrlib.net.LoginSession;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.component.PagePanel;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItemView;
import com.aibonware.viewnaver.config.LoginConfig;
import com.aibonware.viewnaver.config.NetworkConfig;
import com.aibonware.viewnaver.task.ButtonBarStatus;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.HttpTaskCancellerProvider;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LoginView
extends JPanel {
    public boolean confirmed = false;
    public String userName = "";
    public String password = "";
    public JTextField userNameText;
    JPasswordField passwordText;
    NetworkConfig networkConfig;
    ConfigItemView networkConfigView;
    LoginConfig loginConfig;
    ConfigItemView loginConfigView;
    JButton notLoginButton;
    JButton okButton;
    JButton cancelButton;
    AbstractAction okAction;
    DocumentListener buttonActivator;
    private final Window parentWindow;

    private void applyConfig() throws ConfigException {
        try {
            this.networkConfigView.applyConfig();
            ViewNaver.instance.config.replaceChild(ViewNaver.instance.config.getNetworkConfig(), this.networkConfig);
            this.loginConfigView.applyConfig();
            ViewNaver.instance.config.replaceChild(ViewNaver.instance.config.getLoginConfig(), this.loginConfig);
        }
        catch (ConfigException e) {
            ViewNaver.println(e.getMessage());
            return;
        }
    }

    private void initInstance(JTextArea logText, String currentUserName) {
        this.networkConfigView.setConfig(this.networkConfig);
        this.networkConfigView.setBorder(new BevelBorder(0));
        this.loginConfigView.setConfig(this.loginConfig);
        PagePanel accountPage = new PagePanel();
        accountPage.setBorder(new BevelBorder(0));
        this.userNameText = new JTextField();
        this.passwordText = new JPasswordField();
        this.userName = currentUserName != null ? currentUserName : "";
        this.userNameText.setText(this.userName);
        accountPage.addLine("\u30e6\u30fc\u30b6\u540d\uff1a \t", PagePanel.glue(this.userNameText));
        accountPage.addLine("\u30d1\u30b9\u30ef\u30fc\u30c9: \t", PagePanel.glue(this.passwordText));
        ViewNaver.instance.deftex.plus(this.userNameText);
        ViewNaver.instance.deftex.plus(this.passwordText);
        this.notLoginButton.setEnabled(this.userName.length() > 0);
        this.okButton.setEnabled(false);
        PagePanel buttonBox = new PagePanel(this.notLoginButton, PagePanel.glue(), this.okButton, this.cancelButton);
        PagePanel panel = new PagePanel(PagePanel.glue(this.networkConfigView), "\n", PagePanel.glue(accountPage), "\n", PagePanel.glue(this.loginConfigView), "\n", PagePanel.glue(buttonBox));
        if (logText != null) {
            JScrollPane logPanel = new JScrollPane(logText, 22, 31);
            panel.addLine(logPanel);
        }
        this.add((Component)panel, "Center");
        this.parentWindow.setBounds(200, 200, 400, 320);
        ((RootPaneContainer)((Object)this.parentWindow)).getRootPane().setDefaultButton(this.okButton);
        this.userNameText.getDocument().addDocumentListener(this.buttonActivator);
        this.passwordText.getDocument().addDocumentListener(this.buttonActivator);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginView.this.confirmed = false;
                LoginView.this.parentWindow.dispose();
            }
        });
        this.okButton.setAction(this.okAction);
        this.notLoginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int proxyPort;
                String proxyHost;
                try {
                    LoginView.this.applyConfig();
                }
                catch (ConfigException ex) {
                    ViewNaver.println(ex.getMessage());
                    return;
                }
                if (ViewNaver.instance.config.getNetworkConfig().useProxy) {
                    proxyHost = ViewNaver.instance.config.getNetworkConfig().proxyHost;
                    proxyPort = ViewNaver.instance.config.getNetworkConfig().proxyPort;
                } else {
                    proxyHost = null;
                    proxyPort = 0;
                }
                LoginView.this.userName = LoginView.this.userNameText.getText();
                LoginSession session = new LoginSession(LoginView.this.userName, proxyHost, proxyPort, (HttpCancellerProvider)new HttpTaskCancellerProvider());
                ViewNaver.instance.multiSession.addSession((NaverSession)session);
                ViewNaver.instance.multiSession.activateSession((NaverSession)session);
                LoginView.this.confirmed = true;
                LoginView.this.parentWindow.dispose();
            }
        });
        this.parentWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                LoginView.this.userNameText.requestFocusInWindow();
            }
        });
    }

    public LoginView(Window parentWindow, JTextArea logText, String currentUserName) {
        super(new BorderLayout());
        this.networkConfig = (NetworkConfig)ViewNaver.instance.config.getNetworkConfig().cloneThis();
        this.networkConfigView = ViewNaver.instance.config.getNetworkConfig().getView();
        this.loginConfig = (LoginConfig)ViewNaver.instance.config.getLoginConfig().cloneThis();
        this.loginConfigView = ViewNaver.instance.config.getLoginConfig().getView();
        this.notLoginButton = new JButton("\u30ed\u30b0\u30a4\u30f3\u305b\u305a\u306b\u958b\u59cb");
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.okAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    LoginView.this.applyConfig();
                }
                catch (ConfigException e) {
                    ViewNaver.println(e.getMessage());
                    return;
                }
                LoginView.this.userName = LoginView.this.userNameText.getText();
                LoginView.this.password = new String(LoginView.this.passwordText.getPassword());
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getLoginFlow();
                ButtonBarStatus buttonBarStatus = new ButtonBarStatus(new JButton[0], new JButton[]{LoginView.this.cancelButton, LoginView.this.notLoginButton});
                buttonBarStatus.beginTask(LoginView.this.okButton, taskFlow, new JButton[]{LoginView.this.cancelButton, LoginView.this.notLoginButton});
                taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        try {
                            int proxyPort;
                            String proxyHost;
                            if (ViewNaver.instance.config.getNetworkConfig().useProxy) {
                                proxyHost = ViewNaver.instance.config.getNetworkConfig().proxyHost;
                                proxyPort = ViewNaver.instance.config.getNetworkConfig().proxyPort;
                            } else {
                                proxyHost = null;
                                proxyPort = 0;
                            }
                            ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u958b\u59cb..");
                            LoginSession naverSession = new LoginSession((this).LoginView.this.userName, proxyHost, proxyPort, (HttpCancellerProvider)new HttpTaskCancellerProvider());
                            naverSession.login((this).LoginView.this.password);
                            ViewNaver.instance.multiSession.addSession((NaverSession)naverSession);
                            ViewNaver.instance.multiSession.activateSession((NaverSession)naverSession);
                            ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u7d42\u4e86\u3002");
                            (this).LoginView.this.confirmed = true;
                            this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                                @Override
                                public void exec() {
                                    LoginView.this.parentWindow.dispose();
                                }
                            });
                        }
                        catch (NetException e) {
                            ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff1a");
                            ViewNaver.println(e.getMessage());
                        }
                    }
                });
            }
        };
        this.buttonActivator = new DocumentListener(){

            private void updateButtonStatus() {
                boolean anonButtonEnabled;
                boolean emptyUserName = LoginView.this.userNameText.getText().length() == 0;
                boolean emptyPassword = LoginView.this.passwordText.getPassword().length == 0;
                boolean okButtonEnabled = !emptyUserName && !emptyPassword;
                boolean bl = anonButtonEnabled = !emptyUserName;
                if (okButtonEnabled != LoginView.this.okButton.isEnabled()) {
                    LoginView.this.okButton.setEnabled(okButtonEnabled);
                }
                if (anonButtonEnabled != LoginView.this.notLoginButton.isEnabled()) {
                    LoginView.this.notLoginButton.setEnabled(anonButtonEnabled);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtonStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtonStatus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButtonStatus();
            }
        };
        this.parentWindow = parentWindow;
        this.initInstance(logText, currentUserName);
    }
}

