/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.task;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.net.SessionListener;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;

public class ButtonBarStatus {
    private Vector<ButtonInfo> buttonInfos = new Vector();
    private Vector<TaskInfo> taskInfos = new Vector();
    private SessionListener sessionListener;
    private boolean nowLogin = false;

    public ButtonBarStatus(JButton[] loginTimeButtons, JButton[] otherButtons) {
        JButton button;
        JButton[] jButtonArray = loginTimeButtons;
        int n = loginTimeButtons.length;
        int n2 = 0;
        while (n2 < n) {
            button = jButtonArray[n2];
            this.buttonInfos.addElement(new ButtonInfo(button, true));
            ++n2;
        }
        jButtonArray = otherButtons;
        n = otherButtons.length;
        n2 = 0;
        while (n2 < n) {
            button = jButtonArray[n2];
            this.buttonInfos.addElement(new ButtonInfo(button, false));
            ++n2;
        }
        this.sessionListener = new SessionListener(){

            @Override
            public void loginChanged(String userName, boolean nowLogin) {
                ButtonBarStatus.this.nowLogin = nowLogin;
                ButtonBarStatus.this.updateStatus();
            }
        };
        ViewNaver.instance.multiSession.addSessionListener(this.sessionListener);
    }

    private boolean isTaskDisableButton(JButton button) {
        for (TaskInfo taskInfo : this.taskInfos) {
            if (taskInfo.taskStatus != 0 || !taskInfo.disableButtons.contains(button)) continue;
            return true;
        }
        return false;
    }

    private void updateStatus() {
        for (ButtonInfo buttonInfo : this.buttonInfos) {
            if (buttonInfo.isLoginTimeOnly && !this.nowLogin) {
                buttonInfo.button.setEnabled(false);
                continue;
            }
            if (this.isTaskDisableButton(buttonInfo.button)) {
                buttonInfo.button.setEnabled(false);
                continue;
            }
            if (!this.isEnabledButton(buttonInfo.button)) {
                buttonInfo.button.setEnabled(false);
                continue;
            }
            buttonInfo.button.setEnabled(true);
        }
    }

    protected boolean isEnabledButton(JButton button) {
        return true;
    }

    public void beginTask(JButton taskButton, TaskFlow taskFlow, JButton[] disableButtons) {
        TaskInfo taskInfo = new TaskInfo(taskButton, taskFlow, disableButtons);
        this.taskInfos.addElement(taskInfo);
        taskInfo.taskFlow.addStatusReceiver(taskInfo);
    }

    public void dispose() {
        ViewNaver.instance.multiSession.removeSessionListener(this.sessionListener);
    }

    private static class ButtonInfo {
        public final JButton button;
        public final boolean isLoginTimeOnly;

        public ButtonInfo(JButton button, boolean isLoginTimeOnly) {
            this.button = button;
            this.isLoginTimeOnly = isLoginTimeOnly;
        }
    }

    private class TaskInfo
    extends TaskStatusReceiver {
        private final JButton taskButton;
        private final Action originalAction;
        public final TaskFlow taskFlow;
        private Vector<JButton> disableButtons = new Vector();
        private volatile int taskStatus = 1;

        public TaskInfo(JButton taskButton, TaskFlow taskFlow, JButton[] disableButtons) {
            this.taskButton = taskButton;
            this.taskFlow = taskFlow;
            JButton[] jButtonArray = disableButtons;
            int n = disableButtons.length;
            int n2 = 0;
            while (n2 < n) {
                JButton button = jButtonArray[n2];
                if (button != taskButton) {
                    this.disableButtons.addElement(button);
                }
                ++n2;
            }
            if (taskButton != null) {
                this.originalAction = taskButton.getAction();
                taskButton.setAction(new AbstractAction("\u4e2d\u6b62"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TaskInfo.this.taskFlow.cancel();
                    }
                });
            } else {
                this.originalAction = null;
            }
        }

        @Override
        public void statusChanged(int status) {
            this.taskStatus = status;
            ButtonBarStatus.this.updateStatus();
            if (this.taskStatus == 1) {
                ButtonBarStatus.this.taskInfos.removeElement(this);
                if (this.taskButton != null) {
                    this.taskButton.setAction(this.originalAction);
                }
            }
        }
    }
}

