/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.image;

import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.HttpServletResponse;
import com.aibonware.nvrlib.net.AnonymousSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.server.image.ImageCacheItem;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;

public class ImageCache {
    private Vector<ImageCacheItem> images = new Vector();
    private HashMap<String, ImageCacheItem> urlMapping = new HashMap();
    public final int maxWidth;
    public final int maxHeight;
    public final int maxSize;
    public final HashMap<RenderingHints.Key, Object> renderingHints;
    public static final HashMap<RenderingHints.Key, Object> RENDERING_HINTS_STANDARD = new HashMap<RenderingHints.Key, Object>(){
        {
            this.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            this.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            this.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            this.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        }
    };
    public static final HashMap<RenderingHints.Key, Object> RENDERING_HINTS_HISPEED = new HashMap<RenderingHints.Key, Object>(){
        {
            this.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            this.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            this.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            this.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            this.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        }
    };
    public static final AnonymousSession.ImageBinary INVALID_IMAGE_BINARY = new AnonymousSession.ImageBinary(null, null);

    public ImageCache(int maxImageWidth, int maxImageHeight, int maxImageSizePerKB, HashMap<RenderingHints.Key, Object> renderingHints) {
        this.maxWidth = maxImageWidth;
        this.maxHeight = maxImageHeight;
        this.maxSize = maxImageSizePerKB * 1024;
        this.renderingHints = renderingHints;
    }

    public synchronized int putImageUrl(String url) {
        ImageCacheItem image = this.urlMapping.get(url);
        if (image != null) {
            return image.no;
        }
        image = new ImageCacheItem(this.images.size(), url);
        this.images.addElement(image);
        this.urlMapping.put(url, image);
        return image.no;
    }

    private byte[] shrinkImage(String url) throws IOException, NetException {
        byte[] bin = ViewNaver.instance.server.outerSession.getImageBinary((String)url).bin;
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bin));
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (width > this.maxWidth || height > this.maxHeight) {
            if (width > this.maxWidth) {
                height = height * this.maxWidth / width;
                width = this.maxWidth;
            }
            if (height > this.maxHeight) {
                width = width * this.maxHeight / height;
                height = this.maxHeight;
            }
            if (width > this.maxWidth) {
                width = this.maxWidth;
            }
            BufferedImage shrinkImage = new BufferedImage(width, height, bufferedImage.getType());
            Graphics2D g2d = shrinkImage.createGraphics();
            g2d.setRenderingHints(this.renderingHints);
            g2d.drawImage(bufferedImage, 0, 0, width, height, null);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)shrinkImage, "jpg", bout);
            g2d.dispose();
            bout.close();
            bin = bout.toByteArray();
        }
        if (bin.length > this.maxSize) {
            throw new IOException("too large image size " + this.maxSize);
        }
        return bin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putImage(HttpServletResponse response, int imageNo, ServletOutputStream out) throws IOException, NetException {
        ImageCacheItem image = null;
        try {
            ImageCacheItem imageCacheItem = image = this.images.elementAt(imageNo);
            synchronized (imageCacheItem) {
                if (image.binary == INVALID_IMAGE_BINARY) {
                    this.putInvalidImage(response, out);
                    return;
                }
                if (image.binary == null) {
                    byte[] shrinkedImage = this.shrinkImage(image.url);
                    image.binary = new AnonymousSession.ImageBinary("image/jpeg", shrinkedImage);
                }
            }
            response.setStatus(200);
            response.setContentType(image.binary.contentType);
            out.write(image.binary.bin);
        }
        catch (Exception e) {
            if (image != null) {
                image.binary = INVALID_IMAGE_BINARY;
            }
            this.putInvalidImage(response, out);
        }
    }

    private void putInvalidImage(HttpServletResponse response, ServletOutputStream out) {
        response.setStatus(500);
    }
}

