/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.parser;

import com.aibonware.nvrlib.net.AnonymousSession;
import com.aibonware.nvrlib.net.HttpCancellerProvider;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.ParsingContext;
import com.aibonware.nvrlib.parser.ParsingException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.Goyaku;
import com.aibonware.viewnaver.model.GoyakuJiten;
import com.aibonware.viewnaver.task.HttpTaskCancellerProvider;
import java.io.BufferedReader;
import java.io.IOException;

public class GoyakuJitenParser {
    public String urlString;

    public GoyakuJitenParser(String urlString) {
        this.urlString = urlString;
    }

    public GoyakuJiten parse() throws NetException, ParsingException {
        String proxyHost = ViewNaver.instance.config.getNetworkConfig().proxyHost;
        int proxyPort = ViewNaver.instance.config.getNetworkConfig().proxyPort;
        AnonymousSession session = new AnonymousSession("", proxyHost, proxyPort, (HttpCancellerProvider)new HttpTaskCancellerProvider());
        BufferedReader reader = session.open(this.urlString, "MS932");
        GoyakuJiten result = this.parse(reader);
        result.sort();
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("URL\u30af\u30ed\u30fc\u30ba\u5931\u6557", e);
        }
        return result;
    }

    public GoyakuJiten parse(BufferedReader reader) throws ParsingException, NetException {
        GoyakuJiten goyakuList = new GoyakuJiten();
        ParsingContext ct = new ParsingContext(reader);
        ct.seek("<!==</td>");
        while (ct.seek("<b>\u3010", "#omake")) {
            int refStart;
            String line = ct.cut(null, "<br>");
            line = line.replace("\n", " ");
            int wordEnd = line.indexOf("&#");
            if (--wordEnd < 0) {
                wordEnd = line.indexOf("\u3011");
            }
            String word = line.substring(0, wordEnd);
            String explain = line.substring(line.indexOf("</b>") + "</b>".length()).trim();
            while ((refStart = explain.indexOf("&#")) != -1) {
                int refEnd = explain.indexOf(";", refStart);
                int refCode = Integer.parseInt(explain.substring(refStart + "&#".length(), refEnd));
                explain = String.valueOf(explain.substring(0, refStart)) + (char)refCode + explain.substring(refEnd + ";".length());
            }
            goyakuList.addGoyaku(new Goyaku(word, ViewNaver.strToHtml(explain)));
        }
        return goyakuList;
    }
}

