/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.net;

import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.net.DenySession;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.net.SessionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Vector;

public class MultiSession
implements NaverSession {
    private static DenySession denySession = new DenySession("");
    private Vector<NaverSession> sessions = new Vector();
    private Vector<SessionListener> listeners = new Vector();
    private NaverSession activeSession = denySession;

    public void addSession(NaverSession session) {
        this.sessions.addElement(session);
        if (this.activeSession == denySession) {
            this.activeSession = session;
            this.fireLoginChanged();
        }
    }

    private void fireLoginChanged() {
        for (SessionListener listener : this.listeners) {
            listener.loginChanged(this.getUserName(), this.nowLogin());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(NaverSession session) {
        Vector<NaverSession> vector = this.sessions;
        synchronized (vector) {
            this.sessions.removeElement(session);
        }
        if (this.activeSession == session) {
            this.activeSession = denySession;
            this.fireLoginChanged();
        }
    }

    public void activateSession(NaverSession session) {
        if (!this.sessions.contains(session)) {
            ViewNaver.println("warning: MultiSesson has not speficied session to be activate.");
        }
        this.activeSession = session;
        this.fireLoginChanged();
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.listeners.addElement(sessionListener);
        sessionListener.loginChanged(this.getUserName(), this.nowLogin());
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.listeners.removeElement(sessionListener);
    }

    public void login(String loginPassword) throws NetException {
        this.activeSession.login(loginPassword);
        for (SessionListener listener : this.listeners) {
            listener.loginChanged(this.getUserName(), true);
        }
    }

    public void logout() throws NetException {
        this.activeSession.logout();
        for (SessionListener listener : this.listeners) {
            listener.loginChanged(this.getUserName(), false);
        }
    }

    public void logoutAll() throws NetException {
        for (NaverSession session : this.sessions) {
            if (!session.nowLogin()) continue;
            session.logout();
        }
    }

    public BufferedReader open(String url) throws NetException {
        return this.activeSession.open(url);
    }

    public InputStream openStream(String url) throws NetException {
        return this.activeSession.openStream(url);
    }

    public BufferedReader open(String url, String encoding) throws NetException {
        return this.activeSession.open(url, encoding);
    }

    public boolean nowLogin() {
        return this.activeSession.nowLogin();
    }

    public void postArticle(String rawBoardName, int nid, String htmlContent) throws NetException {
        this.activeSession.postArticle(rawBoardName, nid, htmlContent);
    }

    public void replyArticle(String rawBoardName, int nid, String htmlContent, int sno) throws NetException {
        this.activeSession.replyArticle(rawBoardName, nid, htmlContent, sno);
    }

    public void deleteArticle(String rawBoardName, int nid, int articleId) throws NetException {
        this.activeSession.deleteArticle(rawBoardName, nid, articleId);
    }

    public int postThread(String boardName, String title, String content) throws NetException {
        return this.activeSession.postThread(boardName, title, content);
    }

    public void replyThread(String boardName, String title, String content, int nid, int sno) throws NetException {
        this.activeSession.replyThread(boardName, title, content, nid, sno);
    }

    public void modifyThread(String boardName, String title, String content, int nid) throws NetException {
        this.activeSession.modifyThread(boardName, title, content, nid);
    }

    public void deleteThread(String boardName, int nid) throws NetException {
        this.activeSession.deleteThread(boardName, nid);
    }

    public void sendMessage(String receiver, Country country, String messageText, boolean saveServer) throws NetException {
        this.activeSession.sendMessage(receiver, country, messageText, saveServer);
    }

    public void saveReceivedMessage(int[] messageIdList) throws NetException {
        this.activeSession.saveReceivedMessage(messageIdList);
    }

    public void saveSentMessage(int[] messageIdList) throws NetException {
        this.activeSession.saveSentMessage(messageIdList);
    }

    public void deleteReceivedMessage(int[] messageIdList) throws NetException {
        this.activeSession.deleteReceivedMessage(messageIdList);
    }

    public void deleteSentMessage(int[] messageIdList) throws NetException {
        this.activeSession.deleteSentMessage(messageIdList);
    }

    public void denyMessage(String sender, Country country) throws NetException {
        this.activeSession.denyMessage(sender, country);
    }

    public void cancelDenyList(int[] nidA) throws NetException {
        this.activeSession.cancelDenyList(nidA);
    }

    public String getUserName() {
        return this.activeSession.getUserName();
    }

    public Country getCountry() {
        return this.activeSession.getCountry();
    }
}

