/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.board;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.config.ThreadListConfig;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.board.BaseBoardView;
import com.aibonware.viewnaver.content.board.BoardContent;
import com.aibonware.viewnaver.model.Board;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.net.SessionListener;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.window.SearchRemoteThreadDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;

public class BoardView
extends BaseBoardView<Board> {
    private JButton updateButton = new JButton();
    JButton newThreadButton = new JButton("\u65b0\u898f\uff7d\uff9a");
    JButton searchThreadButton = new JButton();
    AbstractAction updateAction = new AbstractAction("\u66f4\u65b0"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int newPageNo = BoardView.this.getSpecifiedPageNo();
            if (newPageNo < 1) {
                ViewNaver.println("\u4e0d\u6b63\u306a\u30da\u30fc\u30b8\u756a\u53f7\u3067\u3059\u3002");
                return;
            }
            BoardView.this.loadNewPage((Board)BoardView.this.board, newPageNo, true);
        }
    };
    AbstractAction newThreadAction = new AbstractAction("\u65b0\u898f\uff7d\uff9a"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ViewNaver.instance.multiSession.nowLogin()) {
                ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            Window postThreadWindow = ViewNaver.instance.windowFactory.createPostThreadWindow(ViewNaver.instance.mainWindow, ((Board)BoardView.this.board).boardName);
            postThreadWindow.setVisible(true);
        }
    };
    AbstractAction searchThreadAction = new AbstractAction("\u691c\u7d22"){

        @Override
        public void actionPerformed(ActionEvent e) {
            BoardContent.BoardClientContentCategory boardCategory = (BoardContent.BoardClientContentCategory)BoardView.this.category;
            SearchRemoteThreadDialog dialog = new SearchRemoteThreadDialog(ViewNaver.instance.mainWindow, new BoardTitle(boardCategory.boardName, boardCategory.dispName));
            dialog.setVisible(true);
        }
    };
    private SessionListener sessionListener = new SessionListener(){

        @Override
        public void loginChanged(String userName, boolean nowLogin) {
            BoardView.this.nowLogin = nowLogin;
            BoardView.this.updateButtonStatus();
        }
    };
    private int currentTaskStatus = 1;
    boolean nowLogin = false;

    public BoardView(TabContentCategory category) {
        super(category);
        this.updateButton.setAction(this.updateAction);
        this.newThreadButton.setAction(this.newThreadAction);
        this.searchThreadButton.setAction(this.searchThreadAction);
        this.toolbar.add((Component)this.updateButton, 0);
        this.toolbar.add(this.newThreadButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.searchThreadButton);
        ViewNaver.instance.multiSession.addSessionListener(this.sessionListener);
    }

    @Override
    public void disposeTab() {
        ViewNaver.instance.multiSession.removeSessionListener(this.sessionListener);
        super.disposeTab();
    }

    private void updateButtonStatus() {
        if (this.currentTaskStatus == 0) {
            this.newThreadAction.setEnabled(false);
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.closeButton.setEnabled(false);
        } else if (this.currentTaskStatus == 1) {
            this.newThreadAction.setEnabled(this.nowLogin);
            this.prevButton.setEnabled(true);
            this.nextButton.setEnabled(true);
            this.closeButton.setEnabled(true);
        }
    }

    public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
        return new TaskStatusReceiver(){

            @Override
            public void statusChanged(int status) {
                if (status == 0) {
                    BoardView.this.updateButton.setAction(new AbstractAction("\u4e2d\u6b62"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            taskFlow.cancel();
                        }
                    });
                } else if (status == 1) {
                    BoardView.this.updateButton.setAction(BoardView.this.updateAction);
                }
                BoardView.this.updateButtonStatus();
            }
        };
    }

    @Override
    protected void loadNewPage(final Board oldboard, final int pageNo, final boolean forceUpdate) {
        TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getBoardFlow(oldboard.boardName, pageNo);
        taskFlow.addStatusReceiver(this.createTaskStatusReceiver(taskFlow));
        taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

            @Override
            public void exec() {
                final Board board = ViewNaver.instance.cache.getBoard(oldboard.boardName, pageNo, forceUpdate);
                if (board == null) {
                    return;
                }
                this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        ViewNaver.instance.mainWindow.containerView.update(new BoardContent(board));
                    }
                });
            }
        });
    }

    @Override
    protected ThreadListConfig getConfig() {
        return ViewNaver.instance.config.getBoardConfig();
    }
}

