/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import javax.swing.JCheckBox;
import org.w3c.dom.Element;

public class LoginConfig
extends ConfigItem {
    public boolean showLoginDialogOnBoot = false;

    public LoginConfig() {
        super("Login");
        this.loadConfig(null);
    }

    @Override
    public void loadConfig(Element elem) {
        this.showLoginDialogOnBoot = Config.getBooleanConfig(elem, "ShowLoginDialogOnBoot", false);
    }

    @Override
    public void saveConfig(Element elem) {
        Config.setBooleanConfig(elem, "ShowLoginDialogOnBoot", this.showLoginDialogOnBoot);
    }

    @Override
    public String getDispPath() {
        return "\u57fa\u672c";
    }

    @Override
    public ConfigItemView getView() {
        return new LoginConfigView();
    }

    private static class LoginConfigView
    extends ConfigItemView {
        JCheckBox showLoginDialogOnBootCheck = new JCheckBox("\u8d77\u52d5\u6642\u306b\u30ed\u30b0\u30a4\u30f3\u753b\u9762\u3092\u8868\u793a\u3059\u308b");
        private LoginConfig loginConfig;

        public LoginConfigView() {
            this.addLine(this.showLoginDialogOnBootCheck);
        }

        @Override
        public void setConfig(ConfigItem config) {
            this.loginConfig = (LoginConfig)config;
            this.showLoginDialogOnBootCheck.setSelected(this.loginConfig.showLoginDialogOnBoot);
        }

        @Override
        public void applyConfig() throws ConfigException {
            this.loginConfig.showLoginDialogOnBoot = this.showLoginDialogOnBootCheck.isSelected();
        }
    }
}

