/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver;

import com.aibonware.nvrlib.model.BoardType;
import com.aibonware.nvrlib.net.LoginSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.ParsingException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.Board;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.parser.BoardParser;
import com.aibonware.viewnaver.storage.StorageException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class Cache {
    private HashMap<String, SortedMap<Integer, CompositeThread>> compositeThreadsPerBoard = new HashMap();
    private HashMap<String, Vector<Board>> threadHeadersPerBoard = new HashMap();
    private HashMap<String, SortedMap<Integer, NThread>> threadHeaders = new HashMap();
    private Comparator<Integer> reverseIntegerComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer src, Integer dest) {
            return dest - src;
        }
    };

    public CompositeThread getCompositeThread(String boardName, int nid, boolean forceRemote) {
        try {
            if (!forceRemote) {
                CompositeThread compositeThread;
                SortedMap<Integer, CompositeThread> compositeThreads = this.compositeThreadsPerBoard.get(boardName);
                if (compositeThreads == null) {
                    compositeThreads = new TreeMap<Integer, CompositeThread>(this.reverseIntegerComparator);
                    this.compositeThreadsPerBoard.put(boardName, compositeThreads);
                }
                if ((compositeThread = (CompositeThread)((Object)compositeThreads.get(nid))) != null) {
                    return compositeThread;
                }
                try {
                    if (ViewNaver.instance.threadStorage.existsThread(boardName, nid)) {
                        return ViewNaver.instance.threadStorage.readThread(boardName, nid);
                    }
                }
                catch (StorageException e) {
                    ViewNaver.err(e);
                }
            }
            ViewNaver.println("\u30b9\u30ec\u30c3\u30c9 " + nid + "\u306e\u8aad\u8fbc\u958b\u59cb...");
            CompositeThread compositeThread = (CompositeThread)ViewNaver.instance.web.queryWebThreadContents(ViewNaver.instance.multiSession, boardName, nid, null, ViewNaver.instance.modelProvider);
            ViewNaver.println("\u30b9\u30ec\u30c3\u30c9 " + nid + "\u306e\u8aad\u8fbc\u7d42\u4e86.");
            return compositeThread;
        }
        catch (NetException e) {
            ViewNaver.err((Exception)((Object)e));
            return null;
        }
        catch (ParsingException e) {
            ViewNaver.err((Exception)((Object)e));
            ViewNaver.println(LoginSession.getAlertString((String)e.parsingText));
            return null;
        }
    }

    public void putCompositeThread(CompositeThread compositeThread) {
        SortedMap<Integer, CompositeThread> compositeThreads = this.compositeThreadsPerBoard.get(compositeThread.boardName);
        if (compositeThreads == null) {
            compositeThreads = new TreeMap<Integer, CompositeThread>(this.reverseIntegerComparator);
            this.compositeThreadsPerBoard.put(compositeThread.boardName, compositeThreads);
        }
        compositeThreads.put(((NThread)compositeThread.thread).nid, compositeThread);
        int i = 0;
        int maxThreadNum = ViewNaver.instance.config.getCapacityConfig().maxCompositeThreadCache;
        int limitNid = -1;
        if ((double)compositeThreads.size() * 1.1 > (double)maxThreadNum) {
            for (int nid : compositeThreads.keySet()) {
                if (i++ <= maxThreadNum) continue;
                limitNid = nid;
                break;
            }
        }
        if (limitNid != -1) {
            Set<Integer> nids = compositeThreads.keySet();
            Iterator<Integer> iter = nids.iterator();
            while (iter.hasNext()) {
                int nid = iter.next();
                if (nid >= limitNid) continue;
                iter.remove();
            }
        }
    }

    private int findPageIndex(Vector<Board> pages, int pageNo) {
        int i = 0;
        while (i < pages.size()) {
            Board page = pages.elementAt(i);
            if (page.pageNo == pageNo) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Board getBoard(String boardName, int pageNo, boolean update) {
        try {
            SortedMap<Integer, NThread> curThreads;
            Vector<Board> pages;
            if (pageNo < 1) {
                pageNo = 1;
            }
            if ((pages = this.threadHeadersPerBoard.get(boardName)) == null) {
                pages = new Vector();
                this.threadHeadersPerBoard.put(boardName, pages);
            }
            int pageIndex = this.findPageIndex(pages, pageNo);
            if (!update && pageIndex != -1) {
                return pages.elementAt(pageIndex);
            }
            ViewNaver.println(String.valueOf(boardName) + " page=" + pageNo + "\u306e\u8aad\u8fbc\u958b\u59cb..");
            BoardTitle boardTitle = (BoardTitle)ViewNaver.instance.boardTitles.getBoardTitle(boardName);
            if (boardTitle == null) {
                boardTitle = new BoardTitle(boardName, boardName, BoardType.Text);
            }
            BoardParser parser = new BoardParser(ViewNaver.instance.modelProvider);
            Board newBoard = (Board)parser.parse(ViewNaver.instance.multiSession, ViewNaver.instance.web.getBoardPageUrl(boardName, pageNo), boardTitle.boardName, boardTitle.dispName, boardTitle.boardType, pageNo);
            ViewNaver.println(String.valueOf(boardName) + " page=" + pageNo + "\u306e\u8aad\u8fbc\u5b8c\u4e86.");
            if (pageIndex != -1) {
                pages.setSize(pageIndex);
            }
            if (pages.size() < ViewNaver.instance.config.getCapacityConfig().maxBoardPageCache) {
                pages.add(newBoard);
            }
            if ((curThreads = this.threadHeaders.get(boardName)) == null) {
                curThreads = new TreeMap<Integer, NThread>(this.reverseIntegerComparator);
                this.threadHeaders.put(boardName, curThreads);
            }
            Iterator iterator = newBoard.iterator();
            while (iterator.hasNext()) {
                NThread newThread = (NThread)((Object)iterator.next());
                NThread oldThread = (NThread)((Object)curThreads.get(newThread.nid));
                if (oldThread != null) {
                    newThread.oldArticleNum = oldThread.articleNum;
                }
                try {
                    curThreads.put(newThread.nid, newThread);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int i = 0;
            int maxThreadNum = ViewNaver.instance.config.getCapacityConfig().maxBoardPageCache * 35;
            int limitNid = -1;
            if (curThreads.size() > maxThreadNum) {
                for (int nid : curThreads.keySet()) {
                    if (i++ <= maxThreadNum) continue;
                    limitNid = nid;
                    break;
                }
            }
            if (limitNid != -1) {
                Set<Integer> nids = curThreads.keySet();
                Iterator<Integer> iter = nids.iterator();
                while (iter.hasNext()) {
                    int nid = iter.next();
                    if (nid >= limitNid) continue;
                    iter.remove();
                }
            }
            return newBoard;
        }
        catch (NetException e) {
            ViewNaver.err((Exception)((Object)e));
            return null;
        }
        catch (ParsingException e) {
            ViewNaver.err((Exception)((Object)e));
            return null;
        }
    }
}

