/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.servlet;

import Acme.Serve.servlet.ServletException;
import Acme.Serve.servlet.ServletInputStream;
import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.HttpServlet;
import Acme.Serve.servlet.http.HttpServletRequest;
import Acme.Serve.servlet.http.HttpServletResponse;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseServlet
extends HttpServlet {
    public static volatile boolean mustReject = false;

    public abstract String getName();

    protected boolean isText() {
        return true;
    }

    @Override
    public final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MiniServer server = ViewNaver.instance.server;
        boolean isText = this.isText();
        if (isText) {
            response.setStatus(200);
            response.setContentType("text/html; charset=Shift_JIS");
        }
        ServletOutputStream out = response.getOutputStream();
        if (mustReject) {
            if (isText) {
                out.println("\u5916\u90e8\u30a2\u30af\u30bb\u30b9\u306f\u7dca\u6025\u906e\u65ad\u3055\u308c\u307e\u3057\u305f\u3002");
            }
            out.flush();
            out.close();
            return;
        }
        String sid = request.getParameter("sid");
        try {
            if (isText) {
                out.println("<html><head><title>" + this.getName() + "</title></head><body>");
            }
            if (!this.getName().equals("login") && !server.isValidSid(sid)) {
                if (isText) {
                    this.dispLogin(server, request, response, out);
                }
            } else {
                UserSession user = server.getSession(sid);
                if (user != null && user.warning != null && isText) {
                    out.println(String.valueOf(user.warning) + "<br>");
                }
                if (user != null) {
                    Vector<String> messages = user.clearOnceMessages();
                    for (String msg : messages) {
                        out.println(msg);
                    }
                }
                this.dispContents(server, user, request, response, out);
            }
        }
        catch (Exception e) {
            if (isText) {
                out.println(e.getMessage());
            }
            ViewNaver.err(e);
        }
        if (isText) {
            out.println("</body></html>");
        }
        out.flush();
        out.close();
    }

    public void dispLogin(MiniServer server, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
        String sid = server.createSid();
        out.println("<form method=\"post\" action=\"login\">");
        out.println("<input type=\"hidden\" name=\"sid\" value=\"" + sid + "\">");
        out.println("<input type=\"password\" name=\"pwd\">");
        out.println("<input type=\"submit\" value=\"OK\">");
        out.println("</form>");
    }

    public abstract void dispContents(MiniServer var1, UserSession var2, HttpServletRequest var3, HttpServletResponse var4, ServletOutputStream var5) throws Exception;

    protected String getPostContent(HttpServletRequest request) throws IOException {
        ServletInputStream reqIn = request.getInputStream();
        int contentLength = request.getContentLength();
        if (contentLength == -1) {
            return "";
        }
        byte[] content = new byte[contentLength];
        int i = 0;
        while (i < contentLength) {
            int c = reqIn.read();
            if (c == -1) break;
            content[i] = (byte)c;
            ++i;
        }
        return new String(content, "Shift_JIS");
    }

    protected TreeMap<String, String> getPostParams(HttpServletRequest request) throws IOException {
        String content = this.getPostContent(request);
        StringTokenizer pairs = new StringTokenizer(content, "&");
        TreeMap<String, String> params = new TreeMap<String, String>();
        while (pairs.hasMoreTokens()) {
            String pair = pairs.nextToken();
            int equalPos = pair.indexOf("=");
            if (equalPos == -1) {
                throw new IOException("invalid post request");
            }
            params.put(pair.substring(0, equalPos), pair.substring(equalPos + 1));
        }
        return params;
    }
}

