/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.movie;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.decorator.EmbeddedMovieDecorator;
import com.aibonware.viewnaver.server.UserSession;
import com.aibonware.viewnaver.server.conv.ConverterFilter;
import com.aibonware.viewnaver.server.image.ImageConverterFilter;
import com.aibonware.viewnaver.server.movie.Movie;
import com.aibonware.viewnaver.server.movie.MovieServlet;
import java.util.Vector;

public class MovieConverterFilter
implements ConverterFilter {
    private char marker;
    Vector<String> movieUrls = new Vector();
    static /* synthetic */ Class class$0;

    public MovieConverterFilter() {
        this.marker = ViewNaver.instance.getPUA(ImageConverterFilter.class);
    }

    public ConverterFilter newInstance() {
        return new MovieConverterFilter();
    }

    public String preprocess(String contents) {
        return EmbeddedMovieDecorator.walkMovie(contents, new EmbeddedMovieDecorator.MovieWalker(){

            public String walk(String contents, int prefixStart, int suffixStart, int prefixLength, int suffixLength) {
                String movieDesc = contents.substring(prefixStart + prefixLength, suffixStart);
                int urlStart = movieDesc.indexOf(" src=");
                while (movieDesc.charAt(urlStart + " src=".length()) == ' ') {
                    ++urlStart;
                }
                int urlEnd = movieDesc.indexOf(" ", urlStart + " src=".length());
                String movieUrl = movieDesc.substring(urlStart + " src=".length(), urlEnd);
                movieUrl = MovieConverterFilter.this.dequote(movieUrl);
                MovieConverterFilter.this.movieUrls.addElement(movieUrl);
                return String.valueOf(MovieConverterFilter.this.marker);
            }
        });
    }

    private String dequote(String s) {
        s = s.trim();
        while (s.charAt(0) == '\"' || s.charAt(0) == '\'') {
            s = s.substring(1);
        }
        while (s.charAt(s.length() - 1) == '\"' || s.charAt(s.length() - 1) == '\'') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String postprocess(UserSession user, String contents) {
        for (String movieUrl : this.movieUrls) {
            int pos = contents.indexOf(this.marker);
            Movie movie = user.movieCache.putMovieUrl(user, movieUrl);
            contents = String.valueOf(contents.substring(0, pos)) + "<a href=\"" + MovieServlet.createUrl(user, movie.no) + "\">" + movie.getCaption() + "</a>" + contents.substring(pos + 1);
        }
        return contents;
    }
}

