/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.server.conv.ContentsConverter;
import com.aibonware.viewnaver.server.image.ImageCache;
import com.aibonware.viewnaver.server.movie.MovieCache;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSession {
    public final String sid;
    public String warning = null;
    public ImageCache imageCache;
    public MovieCache movieCache;
    private CompositeThread cachedThread = null;
    public Vector<String> onceMessages = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnceMessage(String msg) {
        Vector<String> vector = this.onceMessages;
        synchronized (vector) {
            this.onceMessages.addElement(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> clearOnceMessages() {
        Vector<String> vector = this.onceMessages;
        synchronized (vector) {
            Vector<String> cp = new Vector<String>();
            cp.addAll(this.onceMessages);
            this.onceMessages.clear();
            return cp;
        }
    }

    public UserSession(String sid, int maxImageWidth, int maxImageHeight, int maxImageSize, HashMap<RenderingHints.Key, Object> renderingHints) {
        this.sid = sid;
        this.imageCache = new ImageCache(maxImageWidth, maxImageHeight, maxImageSize, renderingHints);
        this.movieCache = new MovieCache();
    }

    public void invalidateCache() {
        this.cachedThread = null;
    }

    public CompositeThread updateCachedThread(UserSession user, ContentsConverter conv, String boardName, int nid) throws Exception {
        CompositeThread result = ViewNaver.instance.web.queryWebThreadContents(boardName, nid, null);
        result.contents = conv.convert(user, null, result.contents);
        this.cachedThread = result;
        return this.cachedThread;
    }

    public CompositeThread getCachedThread(UserSession user, ContentsConverter conv, String boardName, int nid, int start) throws Exception {
        if (this.cachedThread != null && this.cachedThread.boardName.equals(boardName) && this.cachedThread.thread.nid == nid && start < this.cachedThread.articleList.getArticleCount()) {
            return this.cachedThread;
        }
        this.updateCachedThread(user, conv, boardName, nid);
        return this.cachedThread;
    }
}

