/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.parser;

import com.aibonware.viewnaver.model.Article;
import com.aibonware.viewnaver.model.ArticleList;
import com.aibonware.viewnaver.model.Country;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.ParsingContext;
import com.aibonware.viewnaver.parser.ParsingException;
import java.io.BufferedReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;

public class ThreadParser {
    public ArticleList resultArticleList = null;
    public String resultRawContents = null;
    public NThread resultThread = null;
    private NThread templateThread = null;
    private BufferedReader reader;
    private static SimpleDateFormat articleDateFormat = new SimpleDateFormat("MM-dd HH:mm");
    private static SimpleDateFormat threadDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Pattern guard1 = Pattern.compile("<span\\s*id\\s*=\\s*[\"'](comment:|thread:|poster:)[\\-\\dA-Za-z\\._]*[\"']>", 2);
    private static Pattern guard2 = Pattern.compile("href\\s*=\\s*[\"'](comment:|thread:|poster:)[\\-\\dA-Za-z\\._]*[\"']", 2);

    public ThreadParser(BufferedReader reader, NThread templateThread) {
        this.reader = reader;
        this.templateThread = templateThread;
    }

    public void parse() throws NetException, ParsingException {
        ParsingContext ct = new ParsingContext(this.reader);
        this.parseThreadHeaderAndContents(ct, this.templateThread);
        this.resultArticleList = new ArticleList();
        this.parseAricleList(this.resultThread.createDate, this.resultArticleList, ct);
    }

    private void parseThreadHeaderAndContents(ParsingContext ct, NThread templateThread) throws ParsingException {
        try {
            int nid = Integer.parseInt(ct.cut("name=nid value='", "'"));
            ct.seek("tab_bbs01_on.gif");
            ct.seek("class='nboard_tb'");
            String countryText = ct.cut("alt='", "'");
            Country country = countryText.contains("KOREA") ? Country.KOREA : (countryText.contains("JAPAN") ? Country.JAPAN : Country.UNKNOWN);
            ct.seek("<span");
            String title = ct.cut(">", "</span>");
            String dispId = ct.cut("gray04'>No.", "&nbsp;").trim();
            String poster = ct.cut("\u6295\u7a3f\u8005:", "&nbsp;&nbsp;&nbsp;").trim();
            if (poster.contains("javascript:ui")) {
                int start = poster.indexOf("')\">") + 4;
                int end = poster.indexOf("</a>");
                poster = poster.substring(start, end);
            } else if (poster.equals("\u904b\u55b6\u8005")) {
                poster = "enjoymaster";
            }
            String dateText = ct.cut("\u4f5c\u6210\u65e5:", "</td>").trim();
            Date createDate = threadDateFormat.parse(dateText);
            int viewNum = Integer.parseInt(ct.cut("\u95b2\u89a7\u6570:", "&nbsp;").trim());
            String enqueteText = ct.cut(null, "<div style='overflow-x:auto");
            StringBuffer enqueteHtml = new StringBuffer();
            if (enqueteText.indexOf("<span id='poll'>") >= 0) {
                ParsingContext enqct = new ParsingContext(enqueteText);
                enqct.seek("<tr class='PollTitle'>");
                enqct.seek("<table");
                enqueteHtml.append("#\u30a2\u30f3\u30b1\u30fc\u30c8<table>");
                while (enqct.seek("class=c>", "</table>")) {
                    String name = enqct.cut(null, "</td>");
                    String value = enqct.cut("class=c>", "</td>");
                    enqueteHtml.append("<tr><td>");
                    enqueteHtml.append(name);
                    enqueteHtml.append("</td><td>");
                    enqueteHtml.append(value);
                    enqueteHtml.append("</td></tr>");
                    enqct.seek("<tr><td height=10 colspan=3></td></tr>");
                }
                enqueteHtml.append("</table>");
            }
            String contentsText = ct.cut(">", "<script for=window event=onload>");
            int end = contentsText.lastIndexOf("</div>");
            end = contentsText.lastIndexOf("</div>", end - 1);
            this.resultRawContents = enqueteHtml + contentsText.substring(0, end);
            Pattern guard1 = Pattern.compile("<span\\s*id\\s*=\\s*[\"'](comment:|thread:|poster:)[\\-\\dA-Za-z\\._]*[\"']>", 2);
            Pattern guard2 = Pattern.compile("href\\s*=\\s*[\"'](comment:|thread:|poster:)[\\-\\dA-Za-z\\._]*[\"']", 2);
            this.resultRawContents = guard1.matcher(this.resultRawContents).replaceAll("<span>");
            this.resultRawContents = guard2.matcher(this.resultRawContents).replaceAll("href=\"\"");
            this.resultThread = templateThread != null ? new NThread(templateThread.depth, dispId, templateThread.isAdminThread, templateThread.nid, templateThread.country, title, templateThread.articleNum, poster, createDate, createDate, viewNum, templateThread.mail, new Date(), templateThread.isHot, null) : new NThread(0, dispId, false, nid, country, title, -1, poster, createDate, createDate, viewNum, null, new Date(), false, null);
        }
        catch (ParseException e) {
            throw new ParsingException(e, ct.text.toString());
        }
    }

    public void parseAricleList(Date startDate, ArticleList articleList, ParsingContext ct) throws ParsingException {
        try {
            while (true) {
                ct.seek("<td height='11'></td>");
                if (!ct.seek("<td align='left' nowrap>", "ment_writer")) break;
                String replyText = ct.cut(null, "<img src=");
                boolean isReply = replyText.indexOf(8594) >= 0;
                String countryText = ct.cut("http://static.naver.com/enjoyjapan/tbbs/img_09/", ">");
                Country country = countryText.contains("ico_kor") ? Country.KOREA : (countryText.contains("ico_jpn") ? Country.JAPAN : Country.UNKNOWN);
                String author = ct.cut(null, "<span class='small00'>");
                if (author.contains("\u904b\u55b6\u8005")) {
                    author = "enjoymaster";
                } else {
                    int start = author.indexOf("')\">") + "')\">".length();
                    int end = author.indexOf("</a>", start);
                    author = author.substring(start, end);
                }
                String dateText = ct.cut(null, "</span>");
                Date postDate = articleDateFormat.parse(dateText);
                String contents = ct.cut("<td class='ln13'>&nbsp;&nbsp;", " </td>");
                contents = contents.replace("\r\n", "<br>");
                int delPos = contents.indexOf(" <a href='javascript:delete_ment(");
                if (delPos != -1) {
                    contents = contents.substring(0, delPos);
                }
                if (isReply && contents.startsWith("&nbsp;&nbsp;&nbsp;&nbsp;")) {
                    contents = contents.substring("&nbsp;&nbsp;&nbsp;&nbsp;".length());
                }
                int articleId = Integer.parseInt(ct.cut("<div id='repl_", "'"));
                int sno = Integer.parseInt(ct.cut("return add_reply(\"", "\""));
                articleList.addArticle(new Article(author, country, contents, articleId, postDate, isReply, sno));
            }
            GregorianCalendar carendar = new GregorianCalendar();
            carendar.setTime(startDate);
            carendar.add(12, -1);
            startDate = carendar.getTime();
            int year = carendar.get(1);
            int i = 0;
            while (i < articleList.getArticleCount()) {
                Date newPostDate;
                Article art = articleList.getArticle(i);
                carendar.setTime(art.postDate);
                carendar.add(1, year - 1970);
                art.postDate = newPostDate = carendar.getTime();
                ++i;
            }
        }
        catch (ParseException e) {
            throw new ParsingException(e, ct.text.toString());
        }
    }

    public NThread getResultThread() {
        return this.resultThread;
    }

    public String getResultRawContents() {
        return this.resultRawContents;
    }

    public ArticleList getResultArticleList() {
        return this.resultArticleList;
    }
}

