/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.parser;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.Board;
import com.aibonware.viewnaver.model.BoardType;
import com.aibonware.viewnaver.model.Country;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.ParsingContext;
import com.aibonware.viewnaver.parser.ParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BoardParser {
    private String urlString;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yy/MM/dd");

    public BoardParser(String urlString) {
        this.urlString = urlString;
    }

    public Board parse(String boardName, String dispName, BoardType boardType, int pageNo) throws ParsingException, NetException {
        BufferedReader reader = ViewNaver.instance.naverSession.open(this.urlString);
        Board page = this.parse(boardName, dispName, boardType, reader, pageNo);
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("URL\u30af\u30ed\u30fc\u30ba\u5931\u6557", e);
        }
        return page;
    }

    private Board parse(String boardName, String dispName, BoardType boardType, BufferedReader reader, int pageNo) throws ParsingException, NetException {
        ParsingContext ct = new ParsingContext(reader);
        ct.seek("BBS TOP");
        ct.seek("\u7dcf\u6570");
        String pageNoText = ct.cut("No.", "<");
        pageNoText = pageNoText.replace("&nbsp;", "");
        pageNoText = pageNoText.trim();
        int totalPages = Integer.parseInt(pageNoText.substring(pageNoText.indexOf(47) + 1));
        ct.seek("<!-- List -->");
        Board page = new Board(boardName, dispName, boardType, pageNo, totalPages);
        this.parseThreadSummaries(ct, page);
        return page;
    }

    private void parseThreadSummaries(ParsingContext ct, Board page) throws ParsingException, NetException {
        while (ct.seek("<td", "</table>")) {
            Date createDate;
            String poster;
            int articleNum;
            Country country;
            String title;
            int depth;
            boolean isHot;
            boolean isAdminThread;
            String dispId;
            String dispIdText = ct.cut("nboard'>", "</td>");
            String imgText = ct.cut(null, "align='left'>");
            String depthText = ct.cut(null, "<a ");
            String nidText = ct.cut("href='", "'");
            String countryAndTitleText = ct.cut(">", "</a>");
            String artNumText = ct.cut(null, "</td>");
            String authorText = ct.cut("<font color='#000000'>", "</font>");
            String dateText = ct.cut("nboard'>", "</td>");
            String viewNumText = ct.cut("gray04'>", "</td>");
            if (dispIdText.contains("bbs_kokuchi")) {
                dispId = "";
                isAdminThread = true;
                isHot = false;
            } else if (dispIdText.contains("add_hot_icon1")) {
                dispId = "";
                isAdminThread = false;
                isHot = true;
            } else {
                dispId = dispIdText;
                isAdminThread = false;
                isHot = false;
            }
            int start = 0;
            int depthEnd = depthText.indexOf("<img");
            if (depthEnd == -1) {
                depth = 0;
            } else {
                int depthCount = 2;
                while ((start = depthText.indexOf("&nbsp;", start)) != -1 && start <= depthEnd) {
                    start += 5;
                    ++depthCount;
                }
                depth = depthCount / 2;
            }
            nidText = nidText.substring(nidText.indexOf("nid=") + 4);
            int end = nidText.indexOf(38);
            if (end == -1) {
                end = nidText.length();
            }
            int nid = Integer.parseInt(nidText.substring(0, end));
            start = countryAndTitleText.indexOf(">");
            if (start == -1) {
                title = countryAndTitleText;
                country = Country.UNKNOWN;
            } else {
                int japan = countryAndTitleText.indexOf("alt='JAPAN'");
                int korea = countryAndTitleText.indexOf("alt='KOREA'");
                japan = japan >= 0 ? japan : Integer.MAX_VALUE;
                korea = korea >= 0 ? korea : Integer.MAX_VALUE;
                country = japan < korea ? Country.JAPAN : Country.KOREA;
                title = countryAndTitleText.substring(start + 2);
            }
            start = artNumText.indexOf(91);
            if (start == -1) {
                articleNum = 0;
            } else {
                end = artNumText.indexOf(93);
                articleNum = Integer.parseInt(artNumText.substring(start + 1, end));
            }
            if (authorText.contains("javascript:ui")) {
                start = authorText.indexOf("')\">") + 4;
                end = authorText.indexOf("</a>");
                poster = authorText.substring(start, end);
            } else {
                poster = authorText.equals("\u904b\u55b6\u8005") ? "enjoymaster" : authorText;
            }
            try {
                createDate = dateFormat.parse(dateText);
            }
            catch (ParseException e) {
                throw new ParsingException(e, ct.toString());
            }
            int viewNum = Integer.parseInt(viewNumText);
            String imgUrl = null;
            start = imgText.indexOf("<img src='");
            if (start != -1) {
                end = imgText.indexOf(39, start += "<img src='".length());
                imgUrl = imgText.substring(start, end);
            }
            page.addTitle(new NThread(depth, dispId, isAdminThread, nid, country, title, articleNum, poster, createDate, createDate, viewNum, null, new Date(), isHot, imgUrl));
            if (ct.seek("<tr align='center'>", "</table>")) continue;
            break;
        }
    }
}

