/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.model;

import com.aibonware.viewnaver.model.Article;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArticleList {
    private Vector<Article> articles = new Vector();

    public int getArticleCount() {
        return this.articles.size();
    }

    public void addArticle(Article article) {
        this.articles.addElement(article);
    }

    public Article getArticle(int index) {
        return this.articles.elementAt(index);
    }

    public void removeArticle(int index) {
        this.articles.removeElementAt(index);
    }

    public void reverse() {
        Vector<Article> revObjects = new Vector<Article>();
        int i = this.articles.size() - 1;
        while (i >= 0) {
            revObjects.addElement(this.articles.elementAt(i));
            ++i;
        }
        this.articles = revObjects;
    }

    public int getArticleIndexByArticleID(int articleId) {
        int size = this.articles.size();
        int i = 0;
        while (i < size) {
            if (this.articles.elementAt((int)i).articleId == articleId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Article getArticleByArticleID(int articleId) {
        int size = this.articles.size();
        int i = 0;
        while (i < size) {
            if (this.articles.elementAt((int)i).articleId == articleId) {
                return this.articles.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public List<Article> subList(int start, int end) {
        return this.articles.subList(start, end);
    }

    public void sort() {
        Collections.sort(this.articles, new Comparator<Article>(){

            @Override
            public int compare(Article src, Article dest) {
                if (src.sno != dest.sno) {
                    return src.sno - dest.sno;
                }
                return src.articleId - dest.articleId;
            }
        });
    }

    public void merge(ArticleList newArticles) {
        Article art;
        int i = 0;
        while (i < this.getArticleCount()) {
            art = this.getArticle(i);
            art.prevIsNew = art.isNew;
            art.isNew = false;
            if (newArticles.getArticleByArticleID(art.articleId) == null) {
                art.isDeleted = true;
            }
            ++i;
        }
        i = 0;
        while (i < newArticles.getArticleCount()) {
            art = newArticles.getArticle(i);
            if (this.getArticleByArticleID(art.articleId) == null) {
                this.articles.addElement(art);
            }
            ++i;
        }
        this.sort();
    }
}

