/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.format;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.Article;
import com.aibonware.viewnaver.model.ArticleList;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.model.Poster;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;

public class DefaultFormatter {
    private String SPAN;
    private String HR;
    private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");

    public DefaultFormatter() {
        this.SPAN = ViewNaver.instance.getBrowserFactory().SPAN;
        this.HR = ViewNaver.instance.getBrowserFactory().HR;
    }

    public String formatThreadHeader(CompositeThread compositeThread) {
        NThread thread = compositeThread.thread;
        String urlString = "http://bbs.enjoykorea.jp/tbbs/read.php?board_id=" + compositeThread.boardName + "&nid=" + thread.nid;
        return String.valueOf(thread.country.toHtml()) + " " + "<b>" + thread.poster + "</b> " + thread.title + " " + df.format(thread.createDate) + " " + "<a href=\"" + urlString + "\">URL</a><br>" + "\u95b2\u89a7\u6570:" + thread.viewNum + " ";
    }

    public String formatThreadContent(CompositeThread compositeThread) {
        return "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"><base href=\"http://bbs.enjoykorea.jp/\"><style> A.DEF:link, A.DEF:visited, A.DEF:active { color: black; border-width: 1px; text-decoration: none; }A.DEF:hover { color: gray; border-width: 1px; text-decoration: none; }</style></head><body><" + this.SPAN + " id=\"thread:header\">" + this.formatThreadHeader(compositeThread) + "</" + this.SPAN + ">" + this.HR + "<table><tr><td>" + "<" + this.SPAN + " id=\"thread:content\">" + ViewNaver.instance.threadDecorator.decorate(compositeThread.contents) + "</" + this.SPAN + ">";
    }

    public String formatThreadContentFooter(CompositeThread compositeThread) {
        return "</td></tr></table><font size=-1><" + this.SPAN + " id=\"comment:-1\"></" + this.SPAN + ">";
    }

    public String formatArticleFooter(CompositeThread compositeThread) {
        return "</font></body></html>";
    }

    public String formatArticleList(CompositeThread compositeThread) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        ArticleList articles = compositeThread.articleList;
        int lastVisibleSno = -1;
        int i = 0;
        while (i < articles.getArticleCount()) {
            Article art = articles.getArticle(i);
            Poster poster = new Poster(art.author, art.country);
            FilterType filterType = ViewNaver.instance.config.filterConfig.filters.get(poster);
            if (filterType == null) {
                filterType = FilterType.NOAction;
            }
            boolean isFavoritePerson = ViewNaver.instance.config.favoritePersonConfig.persons.contains(poster);
            String articleContent = this.formatArticle(lastVisibleSno, art, filterType, isFavoritePerson);
            if (!filterType.equals((Object)FilterType.Hidden)) {
                lastVisibleSno = art.sno;
            }
            out.println(articleContent);
            ++i;
        }
        out.close();
        return writer.toString();
    }

    public String formatPerson(String poster, boolean isFavoritePerson) {
        if (isFavoritePerson) {
            return String.valueOf(ViewNaver.instance.config.favoritePersonConfig.startTag) + poster + ViewNaver.instance.config.favoritePersonConfig.endTag;
        }
        return poster;
    }

    public String formatInnerArticle(int lastVisibleSno, Article art, FilterType filterType, boolean isFavoritePerson) {
        if (filterType.equals((Object)FilterType.Hidden)) {
            return "";
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        if (lastVisibleSno != art.sno) {
            out.print(this.HR);
        } else {
            out.print("<br>");
        }
        if (art.isReply) {
            out.print("&nbsp;&nbsp;");
        }
        out.print(String.valueOf(df.format(art.postDate)) + " ");
        if (filterType.equals((Object)FilterType.NOAction)) {
            out.print(String.valueOf(art.country.toHtml()) + " ");
            String start = "";
            String end = "";
            if (art.isDeleted) {
                start = "<s>";
                end = "</s>";
            }
            if (art.isNew) {
                start = String.valueOf(start) + "<b>";
                end = "</b>" + end;
            }
            out.print("<a class=\"DEF\" href=\"comment:" + art.articleId + "\"" + ">" + start + this.formatPerson(art.author, isFavoritePerson) + end + "</a> ");
            out.print(ViewNaver.instance.articleDecorator.decorate(art.content));
        } else {
            out.print("(\uff8c\uff68\uff99\uff80\u6e08\u307f) ");
        }
        out.print("<br>");
        out.close();
        return writer.toString();
    }

    public String formatArticle(int lastVisibleSno, Article art, FilterType filterType, boolean isFavoritePerson) {
        String artText = filterType.equals((Object)FilterType.Hidden) ? "" : this.formatInnerArticle(lastVisibleSno, art, filterType, isFavoritePerson);
        return "<" + this.SPAN + " id=\"comment:" + art.articleId + "\">" + artText + "</" + this.SPAN + ">";
    }
}

