/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.message;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.message.MessageContentView;
import com.aibonware.viewnaver.content.message.MessageListView;
import com.aibonware.viewnaver.content.message.ReceivedMessageContentView;
import com.aibonware.viewnaver.model.Message;
import com.aibonware.viewnaver.model.MessageTitle;
import com.aibonware.viewnaver.model.Poster;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.ParsingException;
import com.aibonware.viewnaver.storage.StorageException;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.window.WriteMessageWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;

public class ReceivedMessageContentView
extends MessageContentView {
    private JButton replyButton = new JButton("\u8fd4\u4fe1");
    private JButton denyButton = new JButton("\u53d7\u4fe1\u62d2\u5426");

    public ReceivedMessageContentView(TabContentCategory category) {
        super(category, "http://bbs.enjoykorea.jp/memo/memo_view.php?no=", new MessageListView.MessageAdapter(){

            public void saveMessage(Message message) {
                try {
                    ViewNaver.instance.messageStorage.saveReceivedMessage(ViewNaver.instance.naverSession.getUserName(), message);
                }
                catch (StorageException e) {
                    ViewNaver.err(e);
                }
            }

            public Message getMessage(int messageId) {
                return ViewNaver.instance.messageStorage.getReceivedMessage(messageId);
            }
        });
        this.replyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MessageTitle message = ReceivedMessageContentView.this.messageListView.getSelectedMessage();
                if (message == null) {
                    return;
                }
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageFlow(message.messageId);
                taskFlow.execute(new WorkerTask(this, message){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ MessageTitle val$message;
                    {
                        this.this$1 = var1_1;
                        this.val$message = messageTitle;
                    }

                    public void exec() {
                        try {
                            ViewNaver.println("\u8fd4\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u8aad\u307f\u8fbc\u307f\u958b\u59cb..");
                            String replyText = 2.access$0(this.this$1).getReplyMessageText(this.val$message);
                            ViewNaver.println("\u8fd4\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                            this.taskFlow.execute(new GUITask(this, this.val$message, replyText){
                                final /* synthetic */ 3 this$2;
                                private final /* synthetic */ MessageTitle val$message;
                                private final /* synthetic */ String val$replyText;
                                {
                                    this.this$2 = var1_1;
                                    this.val$message = messageTitle;
                                    this.val$replyText = string;
                                }

                                public void exec() {
                                    WriteMessageWindow replyWindow = new WriteMessageWindow(ViewNaver.instance.mainWindow, this.val$message.person, this.val$message.country, this.val$replyText);
                                    replyWindow.setVisible(true);
                                }
                            });
                        }
                        catch (NetException e) {
                            ViewNaver.err(e);
                        }
                        catch (ParsingException e) {
                            ViewNaver.err(e);
                        }
                    }
                });
            }

            static /* synthetic */ ReceivedMessageContentView access$0(2 var0) {
                return var0.ReceivedMessageContentView.this;
            }
        });
        this.denyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessageTitle[] messageList = ReceivedMessageContentView.this.messageListView.getSelectedMessageList();
                if (messageList.length == 0) {
                    ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return;
                }
                HashSet<Poster> senders = new HashSet<Poster>();
                int i = 0;
                while (i < messageList.length) {
                    Poster sender = new Poster(messageList[i].person, messageList[i].country);
                    if (!senders.contains(sender)) {
                        senders.add(sender);
                    }
                    ++i;
                }
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getDenyListFlow();
                taskFlow.execute(new WorkerTask(this, senders){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ HashSet val$senders;
                    {
                        this.this$1 = var1_1;
                        this.val$senders = hashSet;
                    }

                    public void exec() {
                        try {
                            for (Poster sender : this.val$senders) {
                                ViewNaver.println(String.valueOf(sender.name) + "\u306e\u53d7\u4fe1\u62d2\u5426\u958b\u59cb..");
                                ViewNaver.instance.naverSession.denyMessage(sender.name, sender.country);
                            }
                            ViewNaver.println("\u53d7\u4fe1\u62d2\u5426\u7d42\u4e86\u3002");
                        }
                        catch (NetException e) {
                            ViewNaver.err(e);
                        }
                    }
                });
            }
        });
        this.toolbar.addSeparator();
        this.toolbar.add(this.replyButton);
        this.toolbar.add(this.denyButton);
        this.add((Component)this.toolbar, "North");
    }

    protected void saveServerMessage(int[] messageIdList) throws NetException {
        ViewNaver.instance.naverSession.saveReceivedMessage(messageIdList);
    }

    protected void deleteServerMessage(int[] messageIdList) throws NetException {
        ViewNaver.instance.naverSession.deleteReceivedMessage(messageIdList);
    }
}

