/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.message;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.content.message.MessageListView;
import com.aibonware.viewnaver.model.Message;
import com.aibonware.viewnaver.model.MessageTitle;
import com.aibonware.viewnaver.model.MessageTitleList;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.MessageParser;
import com.aibonware.viewnaver.parser.ParsingException;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class MessageListView
extends JTable {
    private MessageTitleList titles = null;
    private final Browser messageArea;
    private final String messageUrlBase;
    private final JLabel messageHeader;
    private final MessageAdapter messageAdapter;
    private Object[] headerNames = new Object[]{"No", "Server state", "Date", "Country", "ID", "Title"};
    private int[] headerWidthList = new int[]{40, 30, 80, 30, 90, 400};
    private DefaultTableModel tableModel = new DefaultTableModel(this.headerNames, 0){

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    private TableColumnModel columnModel;
    private static SimpleDateFormat titleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private static SimpleDateFormat headerDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public MessageListView(Browser messageArea, String messageUrlBase, JLabel messageHeader, MessageAdapter messageSaver) {
        this.messageArea = messageArea;
        this.messageUrlBase = messageUrlBase;
        this.messageHeader = messageHeader;
        this.messageAdapter = messageSaver;
        this.setModel(this.tableModel);
        this.columnModel = this.getColumnModel();
        int i = 0;
        while (i < this.headerWidthList.length) {
            this.columnModel.getColumn(i).setPreferredWidth(this.headerWidthList[i]);
            ++i;
        }
        this.setShowGrid(false);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int row = MessageListView.this.getSelectedRow();
                if (row == -1) {
                    return;
                }
                MessageTitle title = MessageListView.this.titles.getMessageTitle(row);
                Message message = MessageListView.this.messageAdapter.getMessage(title.messageId);
                if (message == null) {
                    MessageListView.this.showEmptyMessage();
                } else {
                    MessageListView.this.showMessage(message, title.title);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 1) {
                    int row = MessageListView.this.rowAtPoint(event.getPoint());
                    if (row == -1) {
                        return;
                    }
                    MessageTitle messageTitle = MessageListView.this.titles.getMessageTitle(row);
                    TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageFlow(messageTitle.messageId);
                    taskFlow.execute(new WorkerTask(this, messageTitle){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ MessageTitle val$messageTitle;
                        {
                            this.this$1 = var1_1;
                            this.val$messageTitle = messageTitle;
                        }

                        public void exec() {
                            try {
                                ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8No." + this.val$messageTitle.messageId + "\u306e\u8aad\u307f\u8fbc\u307f\u958b\u59cb..");
                                MessageParser parser = new MessageParser(this.val$messageTitle, String.valueOf(MessageListView.access$2(3.access$0(this.this$1))) + this.val$messageTitle.messageId);
                                Message message = parser.parse();
                                ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8No." + this.val$messageTitle.messageId + "\u306e\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                                MessageListView.access$1(3.access$0(this.this$1)).saveMessage(message);
                                this.taskFlow.execute(new GUITask(this, message, this.val$messageTitle){
                                    final /* synthetic */ 4 this$2;
                                    private final /* synthetic */ Message val$message;
                                    private final /* synthetic */ MessageTitle val$messageTitle;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$message = message;
                                        this.val$messageTitle = messageTitle;
                                    }

                                    public void exec() {
                                        3.access$0(4.access$0(this.this$2)).showMessage(this.val$message, this.val$messageTitle.title);
                                    }
                                });
                            }
                            catch (ParsingException e) {
                                ViewNaver.err(e);
                            }
                            catch (NetException e) {
                                ViewNaver.err(e);
                            }
                        }

                        static /* synthetic */ 3 access$0(4 var0) {
                            return var0.this$1;
                        }
                    });
                }
            }

            static /* synthetic */ MessageListView access$0(3 var0) {
                return var0.MessageListView.this;
            }
        });
    }

    public void showEmptyMessage() {
        this.messageArea.setBodyHtml("<font color=gray><i>\uff08\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u5185\u5bb9\u306f\u307e\u3060\u30b5\u30fc\u30d0\u304b\u3089\u53d6\u5f97\u3057\u3066\u3044\u307e\u305b\u3093\u3002\uff09</i></font>");
        this.messageHeader.setText(" ");
    }

    public void showMessage(Message message, String title) {
        this.messageArea.setBodyHtml("<font face=\"MS UI Gothic\">" + message.text + "</font>");
        this.messageHeader.setText("    " + (Object)((Object)message.country) + " " + message.poster + "     " + headerDateFormat.format(message.postDate));
    }

    public void setMessageList(MessageTitleList newTitles) {
        if (this.titles != null) {
            this.titles.merge(newTitles);
        } else {
            this.titles = newTitles;
        }
        this.titles.sort();
        this.messageArea.setBodyHtml("");
        this.messageHeader.setText(" ");
        this.tableModel.setRowCount(0);
        if (this.titles == null) {
            return;
        }
        int i = 0;
        while (i < this.titles.getMessageCount()) {
            MessageTitle title = this.titles.getMessageTitle(i);
            String readText = title.received ? " " : "*";
            String serverState = title.remoteStored ? "s" : " ";
            this.tableModel.addRow(new Object[]{title.messageId, serverState, titleDateFormat.format(title.date), title.country, String.valueOf(readText) + title.person, title.title});
            ++i;
        }
    }

    public MessageTitle getSelectedMessage() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return this.titles.getMessageTitle(row);
    }

    public int[] getSelectedMessageIdList() {
        int[] rows = this.getSelectedRows();
        int[] idList = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            idList[i] = this.titles.getMessageTitle((int)rows[i]).messageId;
            ++i;
        }
        return idList;
    }

    public MessageTitle[] getSelectedMessageList() {
        int[] rows = this.getSelectedRows();
        MessageTitle[] messageList = new MessageTitle[rows.length];
        int i = 0;
        while (i < rows.length) {
            messageList[i] = this.titles.getMessageTitle(rows[i]);
            ++i;
        }
        return messageList;
    }

    static /* synthetic */ String access$2(MessageListView messageListView) {
        return messageListView.messageUrlBase;
    }

    public static interface MessageAdapter {
        public void saveMessage(Message var1);

        public Message getMessage(int var1);
    }
}

