/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.favorite;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.command.ShowThreadCommand;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.favorite.FavoriteContent;
import com.aibonware.viewnaver.model.FavoriteThread;
import com.aibonware.viewnaver.model.FavoriteThreads;
import com.aibonware.viewnaver.task.TaskFlow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class FavoriteContentView
extends TabContentView {
    private FavoriteThreads threads;
    protected JTable table;
    private static TableColumnModel tableColumnModel = null;
    protected JTextField pageText;
    protected JButton closeButton;
    protected JButton deleteButton;
    protected JToolBar toolbar;
    private FavoriteContent content;
    private Object[] headerNames = new Object[]{"board", "country", "poster", "title"};
    private int[] headerWidthList = new int[]{60, 30, 80, 250};
    private DefaultTableModel tableModel = new DefaultTableModel(this.headerNames, 0){

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };

    public FavoriteContentView(TabContentCategory category) {
        super(category);
        if (tableColumnModel == null) {
            this.table = new RowToolTipTable(this.tableModel);
            tableColumnModel = this.table.getColumnModel();
            int i = 0;
            while (i < this.headerWidthList.length) {
                tableColumnModel.getColumn(i).setPreferredWidth(this.headerWidthList[i]);
                ++i;
            }
        } else {
            this.table = new RowToolTipTable(this.tableModel, tableColumnModel);
        }
        this.table.setAutoResizeMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() < 2) {
                    return;
                }
                int row = FavoriteContentView.this.table.rowAtPoint(event.getPoint());
                if (row == -1) {
                    return;
                }
                FavoriteThread thread = FavoriteContentView.this.threads.getThread(row);
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(thread.boardName, thread.nid);
                taskFlow.execute(new ShowThreadCommand(thread.boardName, thread.nid, thread.poster, thread.title));
            }
        });
        this.closeButton = new JButton("\u9589\u3058\u308b");
        this.deleteButton = new JButton("\u524a\u9664");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewNaver.instance.mainWindow.container.removeContent(FavoriteContentView.this.content);
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = FavoriteContentView.this.table.getSelectedRow();
                if (row < 0) {
                    return;
                }
                FavoriteContentView.this.tableModel.removeRow(row);
                ViewNaver.instance.favoriteThreads.removeThread(row);
                ViewNaver.instance.favoriteThreads.save("favorite.xml");
            }
        });
        this.toolbar = new JToolBar();
        this.toolbar.add(this.closeButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.deleteButton);
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    public void setClientContent(TabContent c) {
        this.content = (FavoriteContent)c;
        this.threads = this.content.threads;
        this.tableModel.setRowCount(0);
        int i = 0;
        while (i < this.threads.getThreadCount()) {
            FavoriteThread thread = this.threads.getThread(i);
            this.tableModel.addRow(new Object[]{thread.boardName, thread.country, thread.poster, ViewNaver.htmlToStr(thread.title)});
            ++i;
        }
    }

    private class RowToolTipTable
    extends JTable {
        public RowToolTipTable(TableModel tableModel) {
            super(tableModel);
            this.setToolTipText("");
        }

        public RowToolTipTable(TableModel tableModel, TableColumnModel tableColumnModel) {
            super(tableModel, tableColumnModel);
            this.setToolTipText("");
        }

        public String getToolTipText(MouseEvent event) {
            int row = this.rowAtPoint(event.getPoint());
            if (row == -1) {
                return null;
            }
            FavoriteThread thread = FavoriteContentView.this.threads.getThread(row);
            return thread.title;
        }
    }
}

