/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.w3c.dom.Element;

public class NetworkConfig
extends ConfigItem {
    public boolean useProxy = false;
    public String proxyHost = "127.0.0.1";
    public int proxyPort = 8080;

    public NetworkConfig() {
        super("Proxy");
        this.loadConfig(null);
    }

    public void loadConfig(Element elem) {
        this.useProxy = Config.getBooleanConfig(elem, "UseProxy", false);
        this.proxyHost = Config.getStringConfig(elem, "ProxyHost", "127.0.0.1");
        this.proxyPort = Config.getIntConfig(elem, "ProxyPort", 8080);
    }

    public void saveConfig(Element elem) {
        Config.setBooleanConfig(elem, "UseProxy", this.useProxy);
        Config.setStringConfig(elem, "ProxyHost", this.proxyHost);
        Config.setIntConfig(elem, "ProxyPort", this.proxyPort);
    }

    public String getDispPath() {
        return "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af.\u63a5\u7d9a";
    }

    public ConfigItemView getView() {
        return new NetworkConfigView();
    }

    private static class NetworkConfigView
    extends ConfigItemView {
        JTextField proxyHostText = new JTextField();
        JTextField proxyPortText = new JTextField();
        JCheckBox useProxyCheck = new JCheckBox("\u30d7\u30ed\u30ad\u30b7\u3092\u4f7f\u7528\u3059\u308b");
        private NetworkConfig networkConfig;

        private void changeEnable() {
            this.setLineEnabled(this.useProxyCheck.isSelected(), this.proxyHostText);
            this.setLineEnabled(this.useProxyCheck.isSelected(), this.proxyPortText);
        }

        public NetworkConfigView() {
            this.addLine(this.useProxyCheck);
            this.addLine("   \u30d7\u30ed\u30ad\u30b7\u30b5\u30fc\u30d0\u30a2\u30c9\u30ec\u30b9\uff1a\t", NetworkConfigView.glue(this.proxyHostText));
            this.addLine("   \u30d7\u30ed\u30ad\u30b7\u30dd\u30fc\u30c8\u756a\u53f7\uff1a\t", NetworkConfigView.glue(this.proxyPortText));
            this.useProxyCheck.addActionListener(new ActionListener(this){
                final /* synthetic */ NetworkConfigView this$1;
                {
                    this.this$1 = networkConfigView;
                }

                public void actionPerformed(ActionEvent e) {
                    NetworkConfigView.access$0(this.this$1);
                }
            });
        }

        public void setConfig(ConfigItem config) {
            this.networkConfig = (NetworkConfig)config;
            this.useProxyCheck.setSelected(this.networkConfig.useProxy);
            this.proxyHostText.setText(this.networkConfig.proxyHost);
            this.proxyPortText.setText(String.valueOf(this.networkConfig.proxyPort));
            this.changeEnable();
        }

        public void applyConfig() throws ConfigException {
            block2: {
                try {
                    this.networkConfig.useProxy = this.useProxyCheck.isSelected();
                    this.networkConfig.proxyHost = this.proxyHostText.getText();
                    this.networkConfig.proxyPort = Integer.parseInt(this.proxyPortText.getText());
                }
                catch (NumberFormatException e) {
                    if (!this.useProxyCheck.isSelected()) break block2;
                    throw new ConfigException("\u30dd\u30fc\u30c8\u756a\u53f7\u306b\u306f\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
        }

        static /* synthetic */ void access$0(NetworkConfigView networkConfigView) {
            networkConfigView.changeEnable();
        }
    }
}

