/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.component.PagePanel;
import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import com.aibonware.viewnaver.model.Country;
import com.aibonware.viewnaver.model.Poster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FavoritePersonConfig
extends ConfigItem {
    public Set<Poster> persons = new HashSet<Poster>();
    public String startTag = "<font color=\"green\">";
    public String endTag = "</font>";

    public FavoritePersonConfig() {
        super("FavoritePersonList");
        this.loadConfig(null);
    }

    public void loadConfig(Element elem) {
        this.persons = new HashSet<Poster>();
        if (elem == null) {
            return;
        }
        this.startTag = Config.getStringConfig(elem, "StartTag", "<font color=\"green\">");
        this.endTag = Config.getStringConfig(elem, "EndTag", "</font>");
        NodeList children = elem.getElementsByTagName("FavoritePerson");
        int i = 0;
        while (i < children.getLength()) {
            Element filterElem = (Element)children.item(i);
            Poster poster = Config.getPosterConfig(filterElem, "Poster");
            this.persons.add(poster);
            ++i;
        }
    }

    public void saveConfig(Element elem) {
        Config.setStringConfig(elem, "StartTag", this.startTag);
        Config.setStringConfig(elem, "EndTag", this.endTag);
        NodeList children = elem.getElementsByTagName("FavoritePerson");
        int i = 0;
        while (i < children.getLength()) {
            elem.removeChild(children.item(i));
            ++i;
        }
        for (Poster poster : this.persons) {
            Document doc = elem.getOwnerDocument();
            Element personElem = doc.createElement("FavoritePerson");
            elem.appendChild(personElem);
            Config.setPosterConfig(personElem, "Poster", poster);
        }
    }

    public String getDispPath() {
        return "\u57fa\u672c.\u304a\u6c17\u306b\u5165\u308aID";
    }

    public ConfigItemView getView() {
        return new FavoritePersonConfigView();
    }

    private static class FavoritePersonConfigView
    extends ConfigItemView {
        JTable table;
        JTextField startTagField;
        JTextField endTagField;
        JButton deleteButton;
        private FavoritePersonConfig favoritePersonConfig;
        private DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"Country", "Poster"}, 0);

        public FavoritePersonConfigView() {
            this.table = new JTable(this.tableModel);
            this.startTagField = new JTextField();
            this.endTagField = new JTextField();
            this.deleteButton = new JButton("\u524a\u9664");
            this.setAlignmentX(0.0f);
            this.addLine("\u304a\u6c17\u306b\u5165\u308aID\u306b\u5bfe\u3059\u308b\u52b9\u679c\uff1a\n", FavoritePersonConfigView.glue(new PagePanel("  \u958b\u59cb\u30bf\u30b0\t", FavoritePersonConfigView.glue(this.startTagField), "\n", "  \u7d42\u4e86\u30bf\u30b0\t", FavoritePersonConfigView.glue(this.endTagField))), "\n", FavoritePersonConfigView.glue(this.table.getTableHeader()), this.newline(0), FavoritePersonConfigView.glue(this.table), "\n", FavoritePersonConfigView.glue(), this.deleteButton);
            this.deleteButton.addActionListener(new ActionListener(this){
                final /* synthetic */ FavoritePersonConfigView this$1;
                {
                    this.this$1 = favoritePersonConfigView;
                }

                public void actionPerformed(ActionEvent e) {
                    int row = this.this$1.table.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    FavoritePersonConfigView.access$0(this.this$1).removeRow(row);
                }
            });
        }

        public void setConfig(ConfigItem config) {
            this.favoritePersonConfig = (FavoritePersonConfig)config;
            for (Poster poster : this.favoritePersonConfig.persons) {
                this.tableModel.addRow(new Object[]{poster.country, poster.name});
            }
            this.startTagField.setText(this.favoritePersonConfig.startTag);
            this.endTagField.setText(this.favoritePersonConfig.endTag);
        }

        public void applyConfig() throws ConfigException {
            this.favoritePersonConfig.persons.clear();
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                Country country = (Country)((Object)this.tableModel.getValueAt(i, 0));
                String name = (String)this.tableModel.getValueAt(i, 1);
                this.favoritePersonConfig.persons.add(new Poster(name, country));
                ++i;
            }
            this.favoritePersonConfig.startTag = this.startTagField.getText();
            this.favoritePersonConfig.endTag = this.endTagField.getText();
        }

        static /* synthetic */ DefaultTableModel access$0(FavoritePersonConfigView favoritePersonConfigView) {
            return favoritePersonConfigView.tableModel;
        }
    }
}

